#!/bin/bash
#check the terraform and puppet configurations for the database master and replicas.

if [ -f /etc/profile.d/proxy.sh ]; then
source /etc/profile.d/proxy.sh
fi
source /var/lib/postgresql/virt_env/healthcheck/bin/activate


if [ $2 != "t" ] && [ $2 != "m" ]; then
	echo "time duration is t for hours and m for minutes"
	echo "sh datacollection.sh $schema $time_type $time_duration $fqdn $database"
	exit 1
fi

if [ -z $4 ]; then
	echo "invalid amount of parameters"
	echo "sh datacollection.sh $schema $time_type $time_duration $fqdn $database"
	exit 1
fi

schema=$1
time_type=$2
time_duration=$3
fqdn=$4
database=$5
pushd /var/lib/postgresql/healthcheck/
#$6 argument will tell if box is sfo or aws
if [ $6 == 'true' ] && [ -n $6 ]; then 
  python wrapper.py $schema $time_type $time_duration $fqdn $database
else
  envdir /var/lib/postgresql/env/datacollection/ python wrapper.py $schema $time_type $time_duration $fqdn $database
fi
popd

