__author__ = 'kaceymiriholston'
import commands
import sys, os

def check_installed(prog):
#checks if program is installed
    if not os.system("which %s"%prog):
        print "%s is on path, great!"%prog
    else:
        print "ERROR: %s is not on the path, the program can't run without it."%prog

def check_writable(path):
#checks if path is writeable
    if not os.access(path, os.R_OK):
        print "ERROR:This file must be readable by the postgres user. The path used is  %s. Please ensure this is correct and that the permissions are set correctly." %path
    else:
        print "We have write access to the %s file, great!"%path

user_input = raw_input("Enter database name, ** for all databases, or *+ if you have specified the databases in a check_databases.txt file :")
req_sleep = None
if user_input in ('**', '*+'):
    req_sleep = ""
    while not req_sleep in ('y', 'n'):
        req_sleep = raw_input("Are there more than 10 databases in this check? y or n : ")
    if req_sleep == 'n':
        req_sleep = None

time = ""
while not time in ("t", "m"):
    time = raw_input("Please enter the measurement of how long you would like to run this. Enter t for hours and m for minutes: ")
    if time == "t":
        the_input = "hours"
    elif time == "m":
        the_input = "minutes"
length = raw_input("Please provide the amount of %s you would like to run it for: "%the_input)
is_password = 'f'
while (is_password !='n' and is_password !='y'):
    is_password = raw_input("Please indicate if there is a password(y or n): ")
if is_password == 'y':
    password = raw_input("Please specify the password: ")
else:
    password = None

if password:
    config = commands.getstatusoutput("PGPASSWORD=%s psql --tuples-only --no-align --command 'show config_file;' -U postgres"%password)[1]
else:
    config = commands.getstatusoutput("psql --tuples-only --no-align --command 'show config_file;' -U postgres")[1]


if sys.version_info[:2] < (2,6):
    print "ERROR: This version requires Python 2.6. Found version " + '.'.join(map(str, sys.version_info))
else:
   print "Python version " + '.'.join(map(str, sys.version_info)) + ", great."

check_installed("sar")
check_writable(config)
check_writable(os.getcwd())

#Ensures can connect to psql, logging is on.
try:
    if password:
        x = commands.getstatusoutput("PGPASSWORD=%s psql --tuples-only --no-align --command 'show logging_collector;' postgres"%password)
    else:
        x = commands.getstatusoutput("psql --tuples-only --no-align --command 'show logging_collector;' postgres")
    if not x[1].find('psql:') == -1:
        print "ERROR: Can not connect to psql with this error: %s"%x[1]
    elif not x[1].find('on') == -1:
        print "Can connect to psql, great!\nLogging collector is on, great!"
    elif not x[1].find('off') == -1:
        print "ERROR: Can connect to psql, great!\n But logging is off, contact the client to get this turned on. It requires a restart."
    else:
        print "ERROR: Please assess this message for an attempt at a PSQL connection returned %s"%x[1]
except:
    print "ERROR: Can't access postgresql."

#Ensures there is enough room in the log directory, and that the log directory is writeable.
try:
    if password:
        y = commands.getstatusoutput("PGPASSWORD=%s psql --tuples-only --no-align --command 'show log_directory;' postgres"%password)
    else:
        y = commands.getstatusoutput("psql --tuples-only --no-align --command 'show log_directory;' postgres")
    if y[0] == 0:
        if y[1] == 'pg_log':
            y = commands.getstatusoutput("psql --tuples-only --no-align --command 'show data_directory;' postgres")
        x = commands.getstatusoutput("df -Pm %s | tail -1 | awk '{print $4}'"%y[1])
        if not int(x[1])/ 9216 > 0:
            print "ERROR: There is not enough space for the logs in " + y[1] + "There are only " + str(x[1]) + "MB left."
        else:
            print "There is plenty of room in the log file " + y[1] + " Great! There is " + str(int(x[1])/1024) + "G left."
        check_writable(y[1])
    else:
        print "ERROR: Can't access the log_directory" + y
except:
    print "ERROR: Can't access the log_directory"
log_path = y[1]

print '\n\nUse this call to start the datacollection script: '
final_string = 'python datacollection.py -d "{database}" -c {conf_file} -{measurement} {length_time} '.format(database = user_input, conf_file = config, measurement = time, length_time = length)
if password:
    final_string = final_string + '-p "{password}" '.format(password=password)
if req_sleep:
    final_string = final_string + '-s'
print final_string