import os, commands, json, traceback, sys, boto3, glob, logging
from common import write_pidfile_or_die, remove_pidfile, assume_role, s3_assume_role_client, sqs_assume_role_client
#v2 will support batch sqs message processing
#PHC box script

def receive_sqs(cpu):
	print "Receiving and Parsing SQS  message"
	sqscredentials=assume_role("assumeSQS")
	sqs_client=sqs_assume_role_client(sqscredentials)
	queue_url='https://sqs.us-west-2.amazonaws.com/673385534282/Clio_Pull_Request'
	try:
		message = sqs_client.receive_message(QueueUrl=queue_url, MessageAttributeNames=['All'])
		if len(message) <= 1: #message with content has length of 2.
			remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
			print "No message received."
			exit(0)
		for data in message.get('Messages'):
			sqs_message_receipt_handle = data.get('ReceiptHandle')
			date_stamp = data.get('MessageAttributes').get('date_stamp').get('StringValue')
			fqdn=data.get('MessageAttributes').get('fqdn').get('StringValue')
			s3_path=data.get('MessageAttributes').get('s3_path').get('StringValue')
			s3_filename=data.get('MessageAttributes').get('s3filename').get('StringValue')
			schema=data.get('MessageAttributes').get('schema').get('StringValue')
			database=data.get('MessageAttributes').get('database').get('StringValue')
			db_type=data.get('MessageAttributes').get('db_type').get('StringValue')
		pull_from_s3(s3_path, database)
		delete_sqs_message(sqs_client, queue_url, sqs_message_receipt_handle)
		run_pgBadger(schema, fqdn, date_stamp, database, db_type, cpu)
	except ValueError:  # includes simplejson.decoder.JSONDecodeError
		print 'Decoding JSON has failed'

def pull_from_s3(s3_path, database):
	csv_path="OUTPUT/project/logs/"
	if not os.path.exists(database):
		os.makedirs(database)
		print "made directory %s" %database
	s3credentials=assume_role("assumePullS3")
	s3_client=s3_assume_role_client(s3credentials)
	s3_prefix=s3_path.split('/', 1)[1]+"/"+csv_path
	print s3_prefix
	list=s3_client.list_objects_v2(Bucket='d8a', Prefix=s3_prefix)['Contents']
	for s3_key in list:
			s3_object = s3_key['Key']
			localpath =  database+"/"+(s3_object.rsplit('/', 1)[1])
			if not s3_object.endswith("/"):
				s3_client.download_file('d8a', s3_object, localpath)
			else:
				print "failure"
				if not os.path.exists(s3_object):
					os.makedirs(s3_object)
	# print "aws s3 cp s3://%s/%s %s/ --recursive" %(s3_path, csv_path, database)
	# os.system('envdir /var/lib/postgresql/env /usr/local/bin/aws s3 cp s3://%s/%s %s/ --recursive' %(s3_path, csv_path, database))

def delete_sqs_message(sqs_client, queue_url, sqs_message_receipt_handle):
	print "deleting received queue message"
	response = sqs_client.delete_message(QueueUrl=queue_url, ReceiptHandle=sqs_message_receipt_handle)
	if response: 
		print "delete sqs message suscessful"
		return
	else:
		print "deleting sqs message unsuccessful"
		remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
		exit(1)

def run_pgBadger(schema, fqdn, date_stamp, database, db_type, cpus):
	try:
		print "running pgbadger"
		datacollection_files = glob.glob("/var/lib/postgresql/healthcheck/%s/datacollection-*csv.gz" %database)
		print "datacollectionfiles %s" %datacollection_files
		dc_files=""
		for dc_file in datacollection_files:
			dc_files = dc_files + " " +dc_file
		print dc_files
		print "running pgbadger against %s" % dc_files
		os.system('pgbadger -j %s -t 75 %s' % (cpus, dc_files))
		upload_analyzed_file_to_s3(schema, fqdn, date_stamp, database, db_type, dc_files)
	except Exception:
		remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
		exit(1)

def upload_analyzed_file_to_s3(schema, fqdn, date_stamp, database, db_type, dc_files):
	try:
		s3Bucket="clio-webhost/"
		s3Key=database+"/"+schema+"/"+db_type+"/"+fqdn+"/"+date_stamp+"/"
		s3_path=s3Bucket+s3Key
		s3_filename="/var/lib/postgresql/healthcheck/out.html"
		if os.path.isfile(s3_filename):
			logging.info("running s3 cp")
			s3pushcredentials=assume_role("assumePushS3")
			s3_client=s3_assume_role_client(s3pushcredentials)
			#response is actually None
			response=s3_client.upload_file(s3_filename, 'clio-webhost', s3Key+"out.html", ExtraArgs={'ContentType': 'text/html'})
			if not response:
				logging.info("successful")
				send_sqs(fqdn, s3_path, schema, date_stamp, database, db_type)
			else:
				logging.error("s3 upload of out.html failed")
				remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
				exit (1)
		else:
			cleanup(dc_files)
	except Exception as problem: 
		print problem
		remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
		exit (1)
	cleanup(dc_files)

def cleanup(dc_files):
	remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
	os.system('rm -rf /var/lib/postgresql/healthcheck/OUTPUT* /var/lib/postgresql/healthcheck/out.html %s' % (dc_files))
	exit(1)

def send_sqs(fqdn, s3_path, schema, date_stamp, database, db_type):
	queue_url='https://sqs.us-west-2.amazonaws.com/673385534282/Clio_RDS_Update'
	s3_url='https://s3-us-west-2.amazonaws.com/'+s3_path+'out.html'
	try:
		logging.info("sending sqs message for update")
		sqscredentials=assume_role("assumeSQS")
		sqs_client=sqs_assume_role_client(sqscredentials)
		response = sqs_client.send_message(
		    QueueUrl=queue_url,
		    MessageBody='Update Clio-RDS Index',
		    MessageAttributes={
		        'date_stamp': {
		            'StringValue': date_stamp,
		            'DataType': 'String'
		        },
		        'fqdn': {
		            'StringValue': fqdn,
		            'DataType': 'String'
		        },
		        's3_path': {
		            'StringValue': s3_path,
		            'DataType': 'String'
		        },
		        's3filename': {
		            'StringValue': "out.html",
		            'DataType': 'String'
		        },
		        'schema': {
		            'StringValue': schema,
		            'DataType': 'String'
		        },
		        'database': {
		            'StringValue': database,
		            'DataType': 'String'
		        },
		        'db_type': {
		            'StringValue': db_type,
		            'DataType': 'String'
		        },
		        's3_url': {
		        		'StringValue': s3_url,
		            'DataType': 'String'
		        }
		    }
		)
		remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
	except Exception as e:
		traceback.print_exc()
		print "Could not send sqs message"
		remove_pidfile("/var/lib/postgresql/healthcheck/analysis.pid")
		exit(1)

if __name__ == '__main__':

	try:
		if len(sys.argv) > 0:
			write_pidfile_or_die("/var/lib/postgresql/healthcheck/analysis.pid")
			receive_sqs(sys.argv[1])
		else:
			print("Error: Not enough parameters")
			exit(1)
	except Exception as e:
		traceback.print_exc()
		exit(1)


