// apply bulk
package main

import (
	"code.justin.tv/d8a/iceman/lib/bulk"
	"code.justin.tv/d8a/iceman/lib/dbconf"
	"code.justin.tv/d8a/iceman/lib/queries"

	"github.com/spf13/cobra"
)

// createCmd represents the create command
var bulkRestartCmd = &cobra.Command{
	Use:   "bulk_restart [operation_name]",
	Short: "reset the progress of a bulk operation",
	Long:  "This will wipe out the progress of a bulk operation if it has been run in the past.",
	RunE: func(cmd *cobra.Command, args []string) error {
		if len(args) != 1 {
			return cmd.Usage()
		}

		conf, err := dbconf.NewDBConf(path, env, schema, "bulk")
		if err != nil {
			return err
		}

		params, err := getOverrideParams()
		if err != nil {
			return err
		}

		err = conf.SubstituteDBParams(params)
		if err != nil {
			return err
		}

		db, err := dbconf.OpenDBFromDBConf(conf)
		if err != nil {
			return err
		}
		defer queries.TryClose(db)

		if err := bulk.ResetProgress(db, conf.DriverQueries, args[0]); err != nil {
			return err
		}
		return nil
	},
}

func init() {
	bulkRestartCmd.PersistentFlags().StringVarP(&connHost, "host", "", "", "host to use instead of the one specified in dbConf.yaml")
	bulkRestartCmd.PersistentFlags().IntVarP(&connPort, "port", "", 0, "port to use instead of the one in dbConf.yaml")
	bulkRestartCmd.PersistentFlags().StringVarP(&connUser, "user", "U", "", "username to use instead of the one specified in dbConf.yaml")
	bulkRestartCmd.PersistentFlags().StringVarP(&connDb, "dbname", "d", "", "database name to use instead of the one specified in dbConf.yaml")
	bulkRestartCmd.PersistentFlags().BoolVarP(&connPw, "password-prompt", "W", false, "whether to prompt for a password to use instead of the one specified in dbConf.yaml")
	RootCmd.AddCommand(bulkRestartCmd)
}
