package bulk

import (
	"database/sql"
	"time"

	"code.justin.tv/d8a/iceman/lib/queries"
)

func ResetProgress(db *sql.DB, driverQueries queries.DriverQueries, bulkName string) error {
	singleBulk := driverQueries.GetSingleBulk()
	row := db.QueryRow(singleBulk, bulkName)
	var id int
	var executeTime time.Time
	var completed bool
	var nextRow int
	err := row.Scan(&id, &executeTime, &completed, &nextRow)
	if err != nil {
		return err
	}

	updateQuery := driverQueries.UpdateBulk()
	if _, err := db.Exec(updateQuery, executeTime, false, 0, bulkName); err != nil {
		return err
	}
	return nil
}
