package dbconf

import (
	"github.com/stretchr/testify/require"
	"testing"
)

func TestSubstituteDBParams(T *testing.T) {
	params := make(map[string]string)
	input := ""
	output := ""

	verify(T, input, params, output)

	input = "host=myhost port=23"
	output = "host=myhost port=23"
	verify(T, input, params, output)

	params["port"] = "689"
	output = "host=myhost port=689"
	verify(T, input, params, output)

	params["dbname"] = "db"
	output = "dbname=db host=myhost port=689"
	verify(T, input, params, output)

	delete(params, "port")
	output = "dbname=db host=myhost port=23"
	verify(T, input, params, output)
}

func verify(T *testing.T, input string, params map[string]string, output string) {
	conf := DBConf{
		DBUrl: input,
	}
	err := conf.SubstituteDBParams(params)
	require.Nil(T, err)
	require.Equal(T, output, conf.DBUrl)
}

func TestUsualEnvironment(t *testing.T) {
	dbconf, err := NewDBConf("test_dbconf", "production", "testschema", "operation")
	require.NotNil(t, dbconf)
	require.Nil(t, err)

	dbconf, err = NewDBConf("test_dbconf", "development", "testschema", "operation")
	require.NotNil(t, dbconf)
	require.Nil(t, err)

}

func TestRandomEnvironment(t *testing.T) {
	dbconf, err := NewDBConf("test_dbconf", "sometestenv", "testschema", "operation")
	require.NotNil(t, dbconf)
	require.Nil(t, err)

}

func TestNonExistentEnvironment(t *testing.T) {
	dbconf, err := NewDBConf("test_dbconf", "nonexistenv", "testschema", "operation")
	require.Nil(t, dbconf)
	require.NotNil(t, err)

}
