package queries

import (
	"github.com/stretchr/testify/require"
	"testing"
)

func TestSqlitePlaceholders(t *testing.T) {

	var q = SqliteQueries{}

	onePlaceholder := q.CreatePlaceholders(1)
	require.Equal(t, "$1", onePlaceholder)

	threePlaceholders := q.CreatePlaceholders(3)
	require.Equal(t, "$1, $2, $3", threePlaceholders)
}

func TestPostgresPlaceholders(t *testing.T) {

	var q = PostgresQueries{}

	onePlaceholder := q.CreatePlaceholders(1)
	require.Equal(t, "$1", onePlaceholder)

	threePlaceholders := q.CreatePlaceholders(3)
	require.Equal(t, "$1, $2, $3", threePlaceholders)
}

func TestMysqlPlaceholders(t *testing.T) {

	var q = MySQLQueries{}

	onePlaceholder := q.CreatePlaceholders(1)
	require.Equal(t, "?", onePlaceholder)

	threePlaceholders := q.CreatePlaceholders(3)
	require.Equal(t, "?, ?, ?", threePlaceholders)
}
