package tables

import (
	"strings"

	"github.com/go-sql-driver/mysql"
	"github.com/lib/pq"
	"github.com/mattn/go-sqlite3"
)

func IsMissingTableError(err error) bool {

	pgErr, ok := err.(*pq.Error)
	if ok && pgErr.Code.Name() == "undefined_table" {
		return true
	}

	sqliteErr, ok := err.(sqlite3.Error)
	if ok && sqliteErr.Code == sqlite3.ErrError && strings.HasPrefix(sqliteErr.Error(), "no such table") {
		return true
	}

	//Error: 1146 SQLSTATE: 42S02 (ER_NO_SUCH_TABLE)
	//Message: Table '%s.%s' doesn't exist
	mysqlErr, ok := err.(*mysql.MySQLError)
	if ok && mysqlErr.Number == 1146 {
		return true
	}

	return false
}
