// writing to file for migration/bulk creation
package util

import (
	"os"
	"text/template"

	"code.justin.tv/d8a/iceman/lib/queries"
)

// WriteTemplateToFile populates the specified file
// with a given template. This is called when one
// creates a new migration or bulk operation
func WriteTemplateToFile(path string, t *template.Template, data interface{}) (string, error) {
	f, err := os.Create(path)
	if err != nil {
		return "", err
	}
	defer queries.TryClose(f)

	err = t.Execute(f, data)
	if err != nil {
		return "", err
	}

	return f.Name(), nil
}
