package comparison

import ()

type ComparableMap struct {
	internalValue map[string]ComparableResults
}

func (self *ComparableMap) ResetResults() {
	for _, value := range self.internalValue {
		value.ResetResults()
	}
}

func (self *ComparableMap) NextResultFromPath(path []string) interface{} {

	if len(path) == 0 {
		return self.internalValue
	}

	nextSegment := path[0]
	remainingSegments := path[1:]

	nextSegmentValue, ok := self.internalValue[nextSegment]
	if !ok {
		return nil
	}

	retVal := nextSegmentValue.NextResultFromPath(remainingSegments)

	if len(remainingSegments) == 0 {
		delete(self.internalValue, nextSegment)
	}

	return retVal
}
