package comparison

import (
	"reflect"
)

func DeepCompare(methodName string, preprocessor ComparePreprocessor, old []ComparableResults, new []ComparableResults) (bool, error) {
	if len(old) != len(new) {
		return false, nil
	}

	for resultIndex := 0; resultIndex < len(old); resultIndex++ {
		if preprocessor != nil {
			areSame, err := preprocessor.Preprocess(methodName, resultIndex, &PreprocessFixture{
				old: old[resultIndex],
				new: new[resultIndex],
			})

			if !areSame || err != nil {
				return areSame, err
			}
		}
	}

	return reflect.DeepEqual(old, new), nil
}
