package comparison

type PreprocessFixture struct {
	old ComparableResults
	new ComparableResults
}

type ComparePreprocessor interface {
	Preprocess(methodName string, resultIndex int, fixture *PreprocessFixture) (bool, error)
}

type ValuePair struct {
	Old interface{}
	New interface{}
}

func (self *PreprocessFixture) ExtractValues(path ...string) []*ValuePair {
	self.old.ResetResults()
	self.new.ResetResults()

	arrayPath := []string(path)
	results := make([]*ValuePair, 0)
	for {
		old := self.old.NextResultFromPath(arrayPath)
		new := self.new.NextResultFromPath(arrayPath)

		if old == nil && new == nil {
			break
		}
		results = append(results, &ValuePair{
			Old: old,
			New: new,
		})
	}

	return results
}
