package gen

import (
	"log"

	"github.com/clipperhouse/typewriter"
)

func init() {
	template := typewriter.Template{
		Name: "root",
		Text: replayTemplate,
		FuncMap: map[string]interface{}{
			"method": func(interfaceName string, method methodModel) map[string]interface{} {
				return map[string]interface{}{
					"InterfaceName": interfaceName,
					"Method":        method,
				}
			},
			"add": func(left int, right int) int {
				return left + right
			},
		},
	}

	parsedTemplate, err := template.Parse()
	if err != nil {
		log.Fatalln(err)
	}

	err = typewriter.Register(&wrapperWriter{
		writerName: "migrationconsumer",
		typePrefix: "consumer_",
		imports: []typewriter.ImportSpec{
			typewriter.ImportSpec{Path: "code.justin.tv/d8a/migration"},
			typewriter.ImportSpec{Path: "golang.org/x/net/context"},
		},
		template: parsedTemplate,
	})
	if err != nil {
		log.Fatalln(err)
	}
}
