resource "aws_dynamodb_table" "progress_table" {
    name = "${var.stream_name}_progress"
    read_capacity = "${var.shard_count}"
    write_capacity = "${var.shard_count * 40}"
    hash_key = "consumer_group"
    range_key = "shard_id"

    attribute = {
        name = "consumer_group"
        type = "S"
    }

    attribute = {
        name = "shard_id"
        type = "S"
    }
}
