resource "aws_iam_policy" "replay_kinesis_access_policy" {
    name = "${var.stream_name}-replay-access-policy"
    count = "${signum(var.add_access_roles)}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": "kinesis:*",
            "Resource": "${aws_kinesis_stream.replay_stream.arn}"
        }
    ]
}
EOF
}

resource "aws_iam_policy_attachment" "replay_kinesis_access" {
    name = "${var.stream_name}-replay-access"
    count = "${signum(var.add_access_roles)}"
    roles = ["${split(",", "${var.access_roles}")}"]
    policy_arn = "${aws_iam_policy.replay_kinesis_access_policy.arn}"
}

resource "aws_iam_policy" "replay_dynamodb_access_policy" {
    name = "${var.stream_name}-progress-replay-access-policy"
    count = "${signum(var.add_access_roles)}"
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": "dynamodb:*",
            "Resource": "${aws_dynamodb_table.progress_table.arn}"
        }
    ]
}
EOF
}

resource "aws_iam_policy_attachment" "replay_dynamodb_access" {
    name = "${var.stream_name}-progress-replay-access"
    count = "${signum(var.add_access_roles)}"
    roles = ["${split(",", "${var.access_roles}")}"]
    policy_arn = "${aws_iam_policy.replay_dynamodb_access_policy.arn}"
}