#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        twitch-service-bladerunner-dev)
            ENVIRONMENTS=(prod staging dev)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac
for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    echo "wtf"
    ROLE=`terraform output -state=./terraform/${ACCOUNT}/.terraform/terraform.tfstate ${ENVIRONMENT}-iam_role_arn`
    echo "ROLE=${ROLE}"
    tcs sandstorm role-flags \
        --owner team-d8a \
        --name d8a-${ENVIRONMENT}-mylons-tcs-example \
        --secret_key "d8a/mylons-tcs-example/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
