

module "bs-prod" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-service-bladerunner-dev"
  eb_application_name = "${module.bs-app-twitch-service-bladerunner-dev.beanstalk_application_name}"
  vpc_id = "vpc-0dfa316b"
  ec2_subnet_ids = "subnet-967590f0,subnet-5e54eb05,subnet-4bf2cd02"
  elb_subnet_ids = "subnet-967590f0,subnet-5e54eb05,subnet-4bf2cd02"
  elb_loadbalancer_security_groups = "sg-988927e2"
  auto_scaling_lc_security_groups = "sg-988927e2"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "d8a-blade-runner"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "d8a@twitch.tv"
  service = "d8a/mylons-tcs-example"
  env = "prod"
  associate_public_address = "false"

}
