// Code generated by go-bindata.
// sources:
// data/almanac.json
// data/audrey.json
// data/channels.json
// data/cohesion.json
// data/digestion.json
// data/discovery.json
// data/friendship.json
// data/im-store.json
// data/partnerships.json
// data/presence.json
// data/pubsub-broker.json
// data/rails.json
// data/similar-channels.json
// data/skadi.json
// data/streams-api.json
// data/tmi-api.json
// data/tmi-clue.json
// data/tmi-pubsub.json
// data/tmi-room.json
// data/users-service.json
// data/video-usher-api-find.json
// data/video-usher-api-usher.json
// data/video-usher-api-video.json
// data/video-usher-api-videoapi.json
// data/video-usher-api-viewcount.json
// data/videoshim.json
// data/visage-api.json
// data/visage-kraken.json
// data/visage-v1.json
// data/visage-v2.json
// data/visage-v3.json
// data/visage-v4.json
// DO NOT EDIT!

package routes

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _dataAlmanacJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x74\x8e\x31\x4b\xc6\x30\x10\x86\xf7\xfc\x8a\x23\xf3\x47\x82\x8e\xdf\x26\x22\x75\x33\xa0\x9b\x38\xc4\xe4\x6c\xa3\x4d\x52\x92\x4b\x96\xd2\xff\x2e\x09\xad\x20\xda\xe5\x78\x39\xde\x7b\x9e\x63\x2b\x03\xe0\xb9\x1a\x7e\x05\x6e\xa2\x45\xf1\x59\x32\xb9\x20\xa8\xca\xea\x2c\x46\xa9\x67\xaf\x83\x36\xd2\x78\x7b\x64\x7e\x69\x47\x29\x16\xc2\xcc\xaf\xf0\xca\x00\x00\xd6\x3e\x01\xf8\xa2\x89\x30\x85\x06\x94\xf5\x56\xfe\x86\x8a\x0e\x15\x3b\x48\x18\x6f\x7f\xb2\x5e\x9c\xa8\x37\xe2\x6e\xf7\x0d\x48\x2a\xe1\x07\xa6\x84\x56\x45\x95\xbb\xb4\x0b\x82\xf6\xd8\xe8\xe7\x0d\x8f\x34\x45\xdb\x3a\xea\xe9\xf9\x85\xf7\xf5\x76\x39\x7f\xd3\xe2\x7b\x19\x65\x2a\x21\xb8\x30\xfe\x15\x3d\xa2\x9e\x69\xba\x9f\xd0\x7c\xfd\xe7\x18\x1e\x0e\x05\x03\x78\x63\x1b\xfb\x0e\x00\x00\xff\xff\xd8\x9b\xdb\xb4\x55\x01\x00\x00")

func dataAlmanacJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataAlmanacJson,
		"data/almanac.json",
	)
}

func dataAlmanacJson() (*asset, error) {
	bytes, err := dataAlmanacJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/almanac.json", size: 341, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataAudreyJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xbc\x93\xcd\x6e\xea\x30\x10\x85\xf7\x79\x0a\xcb\x6b\x84\x75\xb7\xd9\xde\x46\xed\xa2\x12\xa8\x65\x57\x55\xc8\xd8\x07\x92\x2a\xb1\x91\x33\x49\xa9\x10\xef\x5e\x25\xb8\xaa\x4a\x7e\xa0\x21\x74\x03\x96\x3d\x39\xdf\xcc\x99\x99\x7d\xc0\x18\xcf\x4b\xc5\x43\xc6\x95\xd5\x98\xbe\x15\x39\x25\x66\x4a\xa5\x78\xc7\x4a\xc8\x42\x3b\x7c\x08\x95\x69\x7f\xe4\x93\xea\x03\x67\x0b\x42\xce\x43\xf6\x12\x30\xc6\xd8\xbe\xfe\x65\x8c\x6f\x25\x11\x9c\xa9\xc4\x44\xf9\x4f\xac\x01\x2d\x42\x15\x4b\x63\x90\x2e\x13\x2d\xb6\x36\xa7\xbc\x96\xa8\xc3\x8d\xcc\x50\xc5\x6e\x40\xf3\x9f\x2f\x19\x28\xb6\xba\x7a\xbb\x8f\x16\xbc\xbe\x3d\x4c\xce\xb3\x1c\x14\x0c\x35\x01\xa7\xf7\x03\xe5\x2f\x28\x45\x39\x48\x42\x55\x4d\x1b\x6d\x3e\x7b\xbe\x06\x27\xc2\xea\x6f\x99\xe8\x4e\x0b\xc7\x2f\xb1\x87\xa9\x91\xa2\xbb\xd6\xbb\xe8\x31\x5a\x44\x63\x90\x85\x83\x54\x94\x58\xd3\xe9\xf7\x93\x0f\x58\xd8\x5b\x3b\xff\x9d\x8b\x08\x91\x59\x42\x8f\x33\xe7\xb3\x1a\xd1\x23\x65\xb3\x0c\xa6\x63\xbb\xfe\xfb\xc7\xd9\xfa\xc6\x43\xd2\x93\xc6\xb1\x53\x3e\x93\x71\x5b\xf4\x05\x15\xa1\x3f\x75\xad\x48\x0f\x7d\xb0\x01\x97\xc1\x8f\x13\xd1\xc3\xbf\x66\x14\xda\x52\xf8\xcd\xd2\xfc\x59\x53\x86\x6d\xcf\x08\xae\x35\x21\x89\xd1\xd8\x0d\x1e\x04\x8d\x55\xb1\x11\x31\x64\x4a\x71\x53\xfb\xf4\x7e\x90\x78\x29\x5d\x4b\xeb\xb0\xdb\x96\xd2\x3d\x48\xa3\x53\xb8\x36\x82\x97\x0f\x18\x7b\x0d\x0e\xc1\x67\x00\x00\x00\xff\xff\xc7\x62\x8a\xdf\xdf\x07\x00\x00")

func dataAudreyJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataAudreyJson,
		"data/audrey.json",
	)
}

func dataAudreyJson() (*asset, error) {
	bytes, err := dataAudreyJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/audrey.json", size: 2015, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataChannelsJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x74\x8d\x31\xce\x83\x30\x0c\x46\xf7\x9c\xe2\x93\x67\x04\x3b\xfb\xaf\xff\x02\xdd\xaa\x0a\x01\xb1\x02\x55\x71\xaa\xc4\xa1\x03\xe2\xee\x55\xb2\x55\x69\x17\x0f\x7e\xcf\xcf\x87\x01\x28\xee\x33\xf5\xa0\xd9\x5b\x6e\xef\x29\xea\x2a\xad\xee\xdd\x8b\xa7\x6e\x5e\x46\x11\x7e\x44\x6a\xb2\x17\x7c\x52\x8e\xd4\xe3\x6a\x00\xe0\x28\x13\xa0\xe7\xa8\xca\x41\x72\xe3\xf3\xa2\x50\x19\x37\x2e\xf9\x8a\x6c\xac\x8b\xb7\x99\xfd\xff\x5d\xa8\x6c\xcf\xe6\x77\xda\xf2\x94\x5c\x17\x92\xc8\x2a\xae\xee\x3b\xd6\xa1\x28\x43\xa5\x7c\x7b\x64\x80\x9b\x39\xcd\x3b\x00\x00\xff\xff\xca\x68\x9e\x39\x01\x01\x00\x00")

func dataChannelsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataChannelsJson,
		"data/channels.json",
	)
}

func dataChannelsJson() (*asset, error) {
	bytes, err := dataChannelsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/channels.json", size: 257, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataCohesionJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xcc\x93\x3f\x6b\xf3\x30\x10\xc6\x77\x7d\x8a\x43\x73\x88\x70\x46\x6f\x2f\x6f\x4d\x3b\x14\x5a\xa8\x3b\x95\x62\x14\xe9\xa8\xd5\xc4\x92\xb1\x4e\x2e\x25\xe4\xbb\x17\xdd\x90\x50\xc8\x9f\x0e\xc6\xed\x62\xac\x7b\xee\x4e\x3f\xf4\xf0\xec\x04\x80\x8c\xa3\x91\x25\x48\x13\x2c\x2e\xdf\x53\x24\xe7\x97\x34\xaa\x0f\x5c\x2b\x13\x5a\x8c\x2e\x78\x65\x3a\x7b\x38\xc8\x45\x1e\x1a\x42\x22\x8c\xb2\x84\x17\x01\x00\xb0\xe3\x2f\x80\xec\x35\x11\x0e\x3e\x2f\x54\x63\xa1\x74\x8c\xc1\x38\x4d\x2e\xf8\xa8\x4a\x67\x8b\x66\xe3\xbc\xe5\x3f\x55\xb2\xd8\xd0\x67\x8f\xb9\xb0\x3a\x48\x2b\xbe\x82\xd7\x79\xdd\x61\xde\x35\x16\x8d\x19\x50\x13\x36\x3c\x74\x6c\xe8\x90\xda\x60\x73\xcb\xe3\x73\x2d\xb9\xba\x5f\xcc\x85\x94\x7a\x7b\x19\xe9\xe1\x69\x62\xa6\x75\xda\x6e\x58\x3b\xc9\xc3\xea\x9f\x83\xd2\x64\xda\xeb\x54\xff\xea\xff\x77\x73\xfb\x67\x71\x8b\x97\xa0\x6e\xaa\xfb\xaa\xae\x66\x77\xf0\x57\xb1\x94\x09\xc9\xd3\xe9\x04\x7e\x57\x8e\x40\xb7\xd5\xec\xd1\x7b\x43\x3a\xff\x40\x93\xf3\xfc\xc0\xb4\xe9\x81\x38\x38\xe7\x23\x75\x25\xdb\x02\xe0\x55\xec\xc5\x57\x00\x00\x00\xff\xff\x27\xcb\x80\x34\xe2\x05\x00\x00")

func dataCohesionJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataCohesionJson,
		"data/cohesion.json",
	)
}

func dataCohesionJson() (*asset, error) {
	bytes, err := dataCohesionJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/cohesion.json", size: 1506, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataDigestionJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xb4\x93\x3f\x6b\xc3\x30\x10\xc5\x77\x7f\x0a\xa1\x39\xe4\xe8\xea\xad\x24\xa6\x1d\x0a\x2d\x38\x5b\xe9\x20\xa4\xa3\x76\x91\xa5\xa2\x3b\x0b\x4a\xc8\x77\x2f\x96\x13\xd3\xc1\xc5\x7f\x70\x3c\x9d\xd1\x7b\xba\x1f\x4f\x77\xe7\x4c\x08\x21\x24\x45\x2d\x73\x21\xb5\x37\xb8\xff\x6a\x89\x6b\xb7\xe7\x08\xb1\x36\xe8\xc1\xd4\x9f\x48\x5c\x7b\x07\xba\x31\x40\x18\x22\x06\xb9\xeb\x7d\xc1\xb7\x8c\x24\x73\xf1\x9e\xfe\xbb\xef\x3c\x54\x49\xe1\x54\x83\xdd\xd5\x4f\xc8\xcf\xa8\x2c\x57\x57\xeb\x20\xf8\x56\xcc\x18\x5c\xa7\x81\xf8\x00\xd5\xa8\xa8\x41\xae\xbc\x49\xf7\x14\x27\x39\x9c\x5d\x76\x33\xda\x96\x1c\x50\x35\x13\x6d\x75\xa5\x9c\x43\x0b\xf9\xad\xa0\xe4\x82\x9c\x46\xdd\xab\x79\x8e\x68\x91\xf1\xbe\x48\xc7\xe2\xa5\x38\x15\x0b\x53\x3a\xf4\x4d\x16\x32\x6d\x9c\xcb\xd6\x10\xcb\x93\x78\xb4\xb6\x7f\x1c\x9a\x80\xe8\x1f\x81\x40\xd9\xed\x42\x18\x86\xf5\xe0\x5b\xc7\x33\x01\xf4\x98\x76\x35\x42\x79\x43\x98\xb5\xac\x13\x23\x7a\x5d\xe6\x9f\xff\xe9\xde\x5e\xcb\xbf\x78\xa9\xfa\xc8\x2e\xd9\x6f\x00\x00\x00\xff\xff\x76\x0e\xb5\xfc\x97\x04\x00\x00")

func dataDigestionJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataDigestionJson,
		"data/digestion.json",
	)
}

func dataDigestionJson() (*asset, error) {
	bytes, err := dataDigestionJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/digestion.json", size: 1175, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataDiscoveryJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x9c\xd0\xb1\x6e\xc3\x20\x10\x06\xe0\x9d\xa7\x38\x31\x47\x61\xcf\x56\x55\x55\x3b\x76\x48\xa7\xaa\xb2\x88\xef\x64\x53\x39\x06\xc1\xe1\xb6\x8a\xf2\xee\x15\x4c\x75\xc0\x6a\xec\x85\xe1\xff\xf1\x87\xef\x2e\x02\x40\x86\xa9\x95\x07\x90\xad\x45\xda\x7f\xc6\xc0\x66\xdc\xf3\xa4\xbe\xe8\xa4\xd0\x84\xd6\x4e\xe4\x7f\xe4\x2e\x5d\xf4\x36\x32\x05\x79\x80\x77\x01\x00\x70\xc9\x27\x80\x74\x9a\x99\xfc\x98\x10\x15\x62\xd7\x51\xe0\xfc\x41\x2e\x47\x7d\xa6\xd4\x14\xc5\x99\xb8\xb7\x98\xaa\xe7\xa7\xa3\xcc\xe9\x75\xb7\x0c\xb3\x75\x25\x3a\x0b\x57\x82\x5d\x32\x0a\x71\x9e\x6e\x20\xd5\x60\x6a\xe3\xa7\xaa\x99\x57\x1b\xf0\x50\xc2\x1a\xb1\x59\xfa\xe9\xd7\xb7\x3b\xdc\x04\xe8\xc1\xe8\x05\xfb\xa6\x5a\x89\xe7\x8d\xe4\xc3\x79\xeb\xc8\xb3\xa9\xcd\x10\x1d\x6a\xa6\xa6\x76\xe5\xcf\x7b\x0f\xc7\xc7\x97\xff\x5f\x2c\x75\x33\x22\x7d\x6f\x5e\x3b\xd2\x29\x76\xaa\x27\x3d\x70\x5f\xda\xb7\x79\x0d\x17\x00\x1f\xe2\x2a\x7e\x03\x00\x00\xff\xff\x53\xe7\xcf\x2f\x6c\x03\x00\x00")

func dataDiscoveryJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataDiscoveryJson,
		"data/discovery.json",
	)
}

func dataDiscoveryJson() (*asset, error) {
	bytes, err := dataDiscoveryJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/discovery.json", size: 876, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataFriendshipJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xbc\x56\x3d\x0f\x9b\x30\x10\xdd\xf9\x15\x16\x73\x14\x2b\x2b\x73\x51\x97\x4a\x8d\xd4\x74\xaa\x2a\xe4\xda\x97\xe2\x34\xd8\xd4\x3e\x58\xa2\xfc\xf7\xca\x04\x4a\x93\x98\x8f\x12\x9c\x05\x24\x73\xbe\xf7\xfc\xee\xee\x99\x4b\x44\x48\x6c\x6b\x1e\x27\x24\xe6\x5a\xc0\xf6\x54\x59\x94\x6a\x8b\x35\xe5\x39\x43\x7a\x34\x12\x94\xb0\xb9\x2c\x29\x2b\xcb\x78\xe3\xc2\x8d\xae\x10\x6c\x9c\x90\x6f\x11\x21\x84\x5c\x9a\x27\x21\x71\xc9\x10\xc1\x28\x97\x8a\x56\x16\x8c\xa5\x89\x7b\x65\x52\x74\x69\xa8\x81\xdf\x15\x58\xb4\x4d\xa2\x66\x93\x62\x05\xb8\x1d\x3f\x01\xb3\x5b\x54\xf6\x1c\x54\x00\xe6\x5a\xb8\xb0\x8f\xe9\x21\x6e\x56\xaf\x9b\xc5\xe0\x34\x69\x81\xa4\x78\xe6\xc1\x84\x68\x79\xf8\xe0\xf7\x5f\x03\xc3\x1b\x38\x01\xc7\x4e\x02\x1f\x85\x0f\xe9\xa7\xf4\x90\x2e\x66\xa1\x34\xca\xa3\xe4\x0c\xa5\x56\x03\x65\x18\x08\x59\xa7\x08\x13\xf8\x06\xec\x03\x83\x00\x1a\x18\xe0\xba\x28\x40\x09\xf0\x54\xc0\x29\xe0\x0d\x58\xab\x09\xff\xa6\xa6\x09\x32\xe3\xe0\x7c\x8d\x20\xa4\x2d\xa4\xb5\x53\x54\x5e\x53\x62\x6c\x0c\xd7\xae\xbc\xe7\x88\x70\x06\x84\xcc\xc5\x05\x28\xf2\xd8\x94\xfd\x73\xca\x5c\x96\x6b\x97\x78\xd4\x5e\x38\x87\x12\x03\x39\xcc\x18\x70\x2b\xf6\x30\xf0\x5c\xb9\xeb\xdd\x2a\xe6\x9e\xd5\xbb\xc5\xba\x0f\x53\xe8\x15\x18\x61\x73\xef\xb1\x03\x44\x5e\x97\xe3\xce\xe9\x28\xd7\x95\xc2\x19\x7e\x1b\x46\x97\xff\x76\xdd\x60\xaa\xf4\x9e\x47\x7f\x9c\x35\xff\xe5\x61\xd3\xac\x37\xb6\x30\xc0\x62\xff\xf9\xcb\x6b\x5d\x32\xcd\xa1\x1d\x97\x1b\x95\x40\x5a\x8c\xfa\x52\xa0\xf9\xe8\x4f\xfe\xe8\x04\x1d\x07\x69\xbb\x51\x0d\x3c\xa1\x53\xb6\xfc\x7e\xfc\xfe\xdf\x2f\x54\xe3\xcd\xbd\x19\x86\xf0\xe7\x5c\x0e\xcb\xe0\xef\xee\x87\x77\x4c\xff\x91\x15\xf2\x2c\x99\xf1\x77\xe0\xd3\x47\x5f\x03\x44\x84\x7c\x8f\xae\xd1\x9f\x00\x00\x00\xff\xff\xdb\x7e\xfd\x81\xc4\x0c\x00\x00")

func dataFriendshipJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataFriendshipJson,
		"data/friendship.json",
	)
}

func dataFriendshipJson() (*asset, error) {
	bytes, err := dataFriendshipJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/friendship.json", size: 3268, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataImStoreJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x93\x41\x4b\xc4\x30\x10\x85\xef\xfd\x15\x43\xce\x6b\x83\xd7\xde\x45\x6f\x2e\xa8\x27\x91\x12\x93\xa1\x89\xb6\x69\x49\x26\x41\x58\xf6\xbf\x4b\x52\x17\x76\x6d\x2d\xad\xec\x25\x84\xbc\x97\xf7\xf1\x26\xe4\x50\x00\x30\x1f\x25\xab\x80\xc9\x5e\x61\xf9\x11\x3c\x19\x5b\x52\xe4\x52\x0b\xe2\xa6\xbb\xf1\xd4\x3b\xe4\x79\x65\xbb\x64\x77\x7d\x20\xf4\xac\x82\xd7\x02\x00\xe0\x90\x57\x00\x36\x08\x22\x74\x36\x45\xf1\x78\xcb\x49\x3b\x14\xca\xf3\x6a\xdc\xd4\x46\xf1\x0e\xbd\x17\x0d\xfa\x9c\x93\xef\x58\xd1\x61\xba\xd0\x20\xd5\x53\xb5\x43\xd2\xbd\x4a\xfa\xfd\xdd\x33\xcb\xa7\xc7\xdd\x1a\xe8\x3c\x60\x22\x5e\x31\x7f\x08\x8b\xf9\xfb\x97\x4d\xf9\x67\x43\x5b\xaa\x72\x85\x26\x8b\xa4\xa1\xf7\x4b\xa8\xfd\xe3\xd3\x3a\x56\xb0\x97\x11\xe7\x4d\x7e\x6b\x1b\x9b\x28\x7c\x0f\x0d\x77\xc1\x5a\x63\x9b\x29\x41\xa3\x68\x49\x4b\x8d\xf2\xf3\xdf\x08\x4f\x82\x8c\xe4\x0e\x25\x9a\x88\xae\xd4\xd4\xb5\x53\xd2\xe8\xaa\x4f\xae\xfa\xd2\xb5\x11\x69\x6c\xda\x8a\x36\x0d\xef\xef\x4f\x73\x72\xd5\xf9\x9d\x96\xbe\xcf\xba\x97\x1a\x67\x19\x85\x9b\x61\xe1\xd7\x10\x85\x7b\x10\x56\xb5\xe8\xe6\x10\x3f\xf1\x05\xc0\x5b\x71\x2c\xbe\x03\x00\x00\xff\xff\xab\x4f\xf6\xe3\x58\x04\x00\x00")

func dataImStoreJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataImStoreJson,
		"data/im-store.json",
	)
}

func dataImStoreJson() (*asset, error) {
	bytes, err := dataImStoreJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/im-store.json", size: 1112, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPartnershipsJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x8f\x31\x4b\x04\x31\x10\x85\xfb\xfc\x8a\x21\xf5\x71\xe9\xb7\x13\x11\x2d\x2d\xae\x13\x09\xb9\xcd\xb0\x1b\xe1\x26\x61\x32\x59\x85\x65\xff\xbb\x24\x8a\x8d\x41\x96\xc5\x26\x45\xf8\xde\xfb\xe6\xad\x0a\x40\xe7\x65\xd4\x03\xe8\x31\x7a\x3c\xbf\x95\x2c\x81\xce\xb2\x98\x77\xbc\x9a\xe4\x58\x08\x39\xcf\x21\x65\x7d\xaa\x2c\xc7\x22\x98\xf5\x00\x2f\x0a\x00\x60\x6d\x2f\x80\x4e\x4e\x04\x99\x6a\xcf\x4f\xca\x0c\x25\x23\xdb\xe0\x4d\xe2\x98\x90\x25\xe0\x57\x4b\x4b\x90\xbb\x61\xc5\x27\x14\xfb\x9d\xb0\x3d\xee\x86\x32\x47\x5f\xc9\xc7\x87\x8b\x6e\xbf\xdb\xe9\xbf\xe4\xc9\xc9\x38\xef\xd4\x3f\xdf\x5d\xee\x9f\xf6\x1f\xf0\xe7\xd2\xe3\xfb\xfa\xb5\x81\x3c\x7e\x1c\xee\xf4\x78\x2d\x93\xe1\x42\x14\x68\xea\x0b\x1a\x62\x7f\x21\x3d\x91\x02\x78\x55\x9b\xfa\x0c\x00\x00\xff\xff\x36\xca\x70\xc0\x5b\x02\x00\x00")

func dataPartnershipsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPartnershipsJson,
		"data/partnerships.json",
	)
}

func dataPartnershipsJson() (*asset, error) {
	bytes, err := dataPartnershipsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/partnerships.json", size: 603, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPresenceJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xa4\x90\xb1\x4e\xc3\x30\x10\x40\x77\x7f\xc5\xc9\x73\x55\x2b\x8c\x5d\x11\xa2\x1b\x95\x80\x09\xa1\xc8\xd8\x47\x62\x48\xcf\x96\x7d\xb6\x90\xaa\xfe\x3b\x4a\xca\xe6\x34\x0a\xb0\x78\xf0\xb3\xdf\xd3\xdd\x49\x00\xc8\x54\x8c\xdc\x81\x34\xde\xe2\xf6\x23\x27\x76\xb4\xe5\xa2\x4c\xaf\x59\x85\x88\x09\xc9\xa0\xd2\x21\xc8\xcd\xf8\x38\xfa\xcc\x98\xe4\x0e\x5e\x04\x00\xc0\x69\x3a\x01\x64\xd0\xcc\x18\x69\x14\xa9\xd2\xa8\xf7\xe8\x90\x6c\x9a\xfe\x4c\x9c\xf4\x11\x47\xd8\x21\xb7\x15\x3c\x22\xf7\xde\x8e\xf8\xfe\xee\x49\x4e\xb7\xe7\xcd\xa2\xdf\xd3\xe0\x08\x6b\x7d\xf0\x89\xdb\x0b\x6c\x4b\x33\x57\x38\x3c\x3c\xae\x49\xdc\xac\x49\xfc\xc3\xdf\xa8\x84\xcc\x8e\xba\x2b\x3b\xaa\xe9\xef\x97\x74\xbd\x10\xf2\x72\xe1\xf0\xbc\xa2\x60\xf1\x2d\x77\x2a\x66\x22\x47\x5d\xdd\xd8\xa3\x1e\xb8\xbf\xed\xd1\x7c\xfe\x79\x88\x4b\xa2\xe8\x38\x33\x03\x7e\x85\xa2\xe3\x5e\x93\x1d\x30\xce\x15\x7e\xf4\x02\xe0\x55\x9c\xc5\x77\x00\x00\x00\xff\xff\x43\x57\xe3\x44\xeb\x02\x00\x00")

func dataPresenceJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPresenceJson,
		"data/presence.json",
	)
}

func dataPresenceJson() (*asset, error) {
	bytes, err := dataPresenceJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/presence.json", size: 747, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataPubsubBrokerJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xb4\x91\x4d\x6b\xc4\x20\x10\x40\xef\xfe\x8a\xc1\xf3\x76\xa5\xd7\xbd\x97\x1e\x5b\x68\x6f\xa5\x2c\x9a\x0c\x6b\x3f\xa2\xd6\x19\xa5\x10\xf2\xdf\x8b\x86\x52\x88\x09\xa4\x87\xbd\x24\xe0\x73\xde\x43\x1d\x05\x80\xa4\xdc\xc9\x13\xc8\xce\xf7\x78\x7c\x4f\xc4\x6f\xee\xc8\x59\x75\x56\xb3\x0a\xc9\x50\x32\x37\x26\xfa\x0f\x8c\x6a\xfe\xc9\x43\x19\x8a\x3e\x31\x92\x3c\xc1\x8b\x00\x00\x18\xeb\x17\x40\x06\xcd\x8c\xd1\x15\xa1\xea\xd1\xa4\x8b\xb2\xa8\x3f\xd9\xd6\xa9\xba\xc3\xe9\x01\x0b\xae\xf4\xbc\xa4\x03\xb2\xf5\x7d\xe1\xf7\x77\xcf\xb2\xae\x4e\x87\xed\xc4\x80\x44\xfa\x82\xd4\xea\x83\x27\x3e\xb7\xf8\xcf\xff\xf8\xf0\xb4\x23\x90\x6f\x7f\x1b\x57\x4b\xcc\xd7\x94\x75\x5c\x39\x05\x7e\x87\xac\xe3\x9a\x7b\xaf\x37\xe2\x57\x42\xe2\x15\xf7\xfc\x00\x2d\xff\x7f\x03\x33\xba\xed\xc2\x92\x36\x7e\x01\xf0\x2a\x26\xf1\x13\x00\x00\xff\xff\x58\xb8\xf6\x6e\x8d\x02\x00\x00")

func dataPubsubBrokerJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataPubsubBrokerJson,
		"data/pubsub-broker.json",
	)
}

func dataPubsubBrokerJson() (*asset, error) {
	bytes, err := dataPubsubBrokerJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/pubsub-broker.json", size: 653, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataRailsJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xd4\x7d\x4b\x8f\xe4\x38\x92\xe6\xbd\x7f\x45\xa2\xfc\x52\xdd\x18\xb4\x7a\xab\x7b\xe6\x10\xb7\x7d\x34\x16\x0b\x2c\xb6\x07\x98\x9a\xd3\x62\x41\xd0\x25\x86\x3b\x2b\x24\x51\x4d\x52\x1e\x19\x33\x98\xff\xbe\x10\xa9\xb7\xe4\xa2\x91\x66\x8a\xc8\x39\x54\x66\x56\x84\x19\xbf\x4f\x46\xa3\xf1\x65\x24\xff\xfd\x77\xdf\xbe\xfd\x64\x1e\xf9\x4f\x2f\xdf\x7e\xca\x55\x21\xfe\xf8\x5b\x6b\xac\xac\xff\x68\x1f\xd9\xbb\xb8\x76\xff\xfd\xf4\x0f\x9d\x88\x56\xad\x15\xe6\xa7\x97\x6f\xff\xf7\x77\xdf\xbe\x7d\xfb\xf6\xef\xee\xcf\x6f\xdf\x7e\x6a\xb8\xb5\x42\xd7\x9d\x7a\xc6\x8d\x11\xd6\x38\x79\xf7\xbb\x9a\x57\x62\xf7\x17\x95\xb0\x77\x55\x74\xbf\xfa\xc9\xfd\xe8\x3f\xfe\xe1\x79\xa1\x0f\x29\xde\x85\xce\x4a\x5e\xdf\x5a\x7e\x13\x3f\xff\xf1\xe5\x55\xe9\x8a\xdb\xdf\x6f\x71\x78\x23\x33\xfb\x2e\x6d\x7e\xef\xb5\x2e\x83\xd6\x1e\xf4\xff\xfc\xeb\xaf\x61\xf4\x2d\xc8\xab\x56\xb5\x65\x0d\xbf\x89\xcb\xf4\xcf\xb4\x4f\x9b\xf4\xb3\x52\x3e\x04\x6b\x4a\xfe\x21\xf4\xd1\x17\xce\xc0\x67\x1a\x69\xe8\x5d\x01\x40\x2c\xec\x87\xf2\xa2\x92\x75\x56\x70\x73\xbf\x2a\xae\x8b\x23\x54\x88\x6c\x64\x1d\xba\x12\x0f\xfd\x66\x09\x79\x91\x75\x21\xbe\x63\xbe\xb4\x35\x42\x9b\xec\xa5\xfb\x8b\xc9\x22\xe3\x05\xd3\xe2\x21\xea\x56\xb0\x5c\xd5\xaf\xf2\x66\xb2\x2b\xb7\xf9\x9d\xf1\xdc\x4a\x05\xa0\xb6\x2d\xe0\x32\x2f\x60\x8f\xea\x3f\xff\xed\x5f\xa0\xa6\x09\xd3\x4d\x62\xf8\xd4\x8a\xf0\x4a\x3b\x89\x59\xae\x05\xb7\xbb\xae\x4c\x6a\xb5\xac\x16\xef\x49\xfc\x6a\xf1\x7e\xb6\xdd\xb2\x17\x59\x64\xa2\x90\x36\x89\x60\xa7\xf8\x19\x0c\x93\xc8\x99\xbb\xfa\x14\xf3\x25\x91\x6b\x9b\xe2\x99\xeb\xfd\xeb\x0f\x40\xaf\x10\xc6\x6a\xf5\xb1\xc7\xef\x7f\xfc\xf5\x7f\xff\xf5\xd7\xbf\x42\x29\xba\x3f\xa5\xb1\x9a\x5b\xa5\xe3\xc3\xdd\x5c\x99\x34\xd4\x2d\x8b\x8e\xa6\x42\x11\xd3\x56\xa6\x01\x56\xd5\x82\x06\x81\x8b\x73\x7d\x65\x6f\xe2\x23\xba\x6a\x7a\x35\xda\x4a\xe9\x0b\x8d\x80\x27\xa9\x88\x78\x58\x9a\x9e\x63\xb4\x3d\xac\x83\x18\xc0\xf1\xdd\xc2\x08\x1c\x11\xfd\x07\x74\x82\x98\x3f\x87\x8f\x40\xa6\xf4\xf6\x38\x64\x92\x68\x9d\x88\x4d\x17\x8a\x75\x7e\x97\x0f\xe1\x2b\xbd\x10\xa5\xb0\xc7\x93\xa8\x85\xd2\xc5\x2b\xa0\x4d\x30\xa3\xd0\xd6\x55\x1b\x45\xc1\x2b\x50\x51\x88\x8d\x77\x3d\x09\xda\x78\xe7\x0b\x8d\x80\xa7\x89\x77\x53\x2d\x44\x40\x53\x34\xbf\xb6\x90\xd7\x52\xb0\x8a\xdf\x64\xce\xb4\x30\x8d\xaa\x4d\xac\x3b\xec\x97\x71\xe4\x1d\x31\x55\xf2\x84\x61\xa4\xb7\x3c\xe1\x48\xea\x3c\xfb\x18\xe9\xe4\x48\x5c\x8b\x9a\x14\x51\x47\xfb\xa4\x56\x61\xfd\xee\x13\x6a\x04\xdd\xf0\x41\x73\x00\xf6\xca\x4f\xb8\x51\x74\xd2\xcf\xc9\xa5\xf3\x3a\x37\x86\x20\x82\x07\x49\x07\x7f\x06\x33\xba\xee\xbf\x2d\xa4\x05\xb6\x44\x4b\x13\x0d\xae\x25\xcf\xdf\x4a\x69\x2c\x13\xb5\xd5\x32\x3a\x8c\x6e\xf4\x49\x03\xe8\xa6\xf4\x14\x42\xa7\x98\x29\x85\x08\x4d\xa0\xdc\xd6\x18\x28\x44\x6e\xe9\xe0\x83\xe3\x96\x0a\xa8\x1d\x6d\xa9\x90\xb5\xa0\xd5\x72\x4b\x7e\xe7\x8d\x15\xd1\x8b\x1a\x83\xda\x99\x2b\xb7\x03\x46\x04\x9b\x13\x56\x69\x13\x58\x9c\xb2\x22\x3b\x56\x14\xc8\x97\x47\x2e\xe4\xab\xaf\x23\x0f\x78\xff\x3e\x92\xa1\x5f\x69\x9d\xb3\x89\x20\x42\xbf\xaa\x9a\x48\xe4\x8c\x15\xd4\x44\x2a\x64\x11\x26\xaf\x0c\x13\x15\x97\x65\x74\x50\x19\x15\x49\xc3\xca\x54\x6c\x14\x05\x8a\x58\x92\x08\x4d\x13\x40\x66\xf5\x00\x8b\x19\x13\x01\x7c\xd4\x98\x81\x47\x04\x8a\x89\x01\x41\xa8\x58\x52\x88\x42\x27\x88\x0f\x08\x74\x92\xa0\x90\xab\xe6\x43\xcb\xdb\xdd\xb2\xbb\x2a\x8b\x84\x1e\x7e\xad\x4f\xdb\x26\xd7\xa5\xa7\x10\x22\x69\xa1\x14\x44\x88\xda\xeb\xa6\xc6\x60\xcd\x76\x43\x87\xa0\xf5\x6e\xa8\x44\x34\xe2\x0d\x1f\x8a\xb6\xbc\x47\x28\x85\x0b\x45\xcb\xa6\xe2\x72\x52\x3b\x4f\x64\x43\xd6\xff\x83\x32\x63\x56\xa2\x24\x6d\x79\x2c\x2d\x33\x82\xeb\xfc\xce\x1e\xb2\x10\x0a\xd0\xa2\x27\x1a\x0b\x45\x32\x3a\xb2\xe2\x37\xc1\xda\xa6\x54\x3c\xce\x28\x33\x3d\x6c\x74\x99\xd8\xb4\xb5\xbd\x6b\x65\x6d\x29\x98\xf8\x9e\x8b\xa6\x8b\xe7\x51\x46\xda\x2d\x00\x6b\xac\x2a\xe7\xcc\xf2\x37\x51\xa8\xf7\x3a\xb6\xaf\x5a\x2a\x93\x76\x54\xcb\xa2\xa3\xa9\x50\xb8\xb5\xa8\x94\x95\xb9\xaa\x81\x2d\x7b\x14\xa7\x6b\xd1\x0b\x06\x59\x23\xea\x42\xd6\x37\x70\xed\x4c\x84\x96\x9a\xc8\xc0\x37\x16\x1b\xc3\x80\xa6\xa7\x9e\xec\x11\xe7\xa7\x13\x0f\x4a\x17\x4d\x32\x04\xa9\x63\x7e\x65\x0d\x44\xb6\x09\x92\x3e\xf7\xeb\x5b\xe4\xab\xe0\xb6\xd5\xa2\x60\xf9\x9d\xd7\xb5\xe8\x67\x59\x9d\x3f\x3d\x38\x64\xff\x71\xa3\x7f\x19\x74\x91\xa6\xd9\x12\x8b\x6b\x22\x5b\x62\x94\x4d\x65\x53\x7a\x0a\x21\x8a\xa6\x43\x42\x84\xa6\x29\x6d\x6b\x0c\x34\xed\xd8\xd2\xc1\x4f\x3b\xf6\xbd\x1a\x36\xed\xd8\xf2\x21\x98\x76\xec\x12\x4a\xe1\x42\x30\xed\x20\xe3\x42\x12\x02\xc9\xd8\x90\x85\xc4\x1b\xaf\x20\x9b\x4e\x4e\x8c\xa4\x0d\xbb\x92\x32\x5e\x00\x3e\xdb\x83\xf2\x02\x3d\x8a\x1f\x31\x59\xad\x6a\x76\x93\xbc\xb6\x57\x55\x5d\x23\x18\x2c\x15\xe9\xf8\x74\xff\x62\xbc\x94\x1c\x5c\x07\x4b\x2d\x34\x93\x52\x5d\x79\xc9\xae\x9d\x5b\x15\xec\x5d\xe9\x02\x42\x64\xab\x44\xe2\x1a\x77\xae\x0b\x06\xcd\x4e\x9b\x09\x53\x83\x67\xd0\x6e\x77\xce\x81\xa6\xab\xf5\x27\x7a\xb4\xfa\xfe\xc1\x6e\x5a\xb5\x4d\xec\x40\x60\xa3\x4f\x3a\x10\xd8\x94\x9e\x42\x88\xa2\xb2\x48\x88\xd0\x0c\x04\xb6\x35\x06\x1a\x08\x6c\xe9\xe0\x07\x02\x5b\x2a\xf0\x81\xc0\x96\x0f\xc1\x40\x60\x97\x50\x0a\x17\x82\x81\x00\x19\x17\x92\x81\x00\x19\x1b\xb2\x81\x40\xc5\x8d\x61\x0d\xd7\xb6\x16\x9a\x59\xa5\x20\x83\xeb\xad\x0e\x49\xeb\xde\x16\x0b\x8e\xc8\x3b\x8c\x68\x42\x5f\xad\xac\x7c\x95\x39\x77\xab\x76\x59\xc5\xf5\x5b\xa1\xde\x6b\xd6\x68\xf1\x90\x90\xf6\xbe\xd0\xbf\xac\xf5\x91\x06\x5b\x92\x8b\xeb\x31\x96\xc4\x28\x7b\x8b\x45\xc9\xb1\x44\x28\xfc\x08\x45\x80\xa6\x77\x58\xd6\x0c\xa8\x67\x58\xd2\xc0\xf7\x0a\x4b\x0a\xf0\x1e\x61\xc9\x83\xa0\x37\xd8\x10\x89\xe5\x40\xd0\x0b\xa0\x39\x90\x44\x7f\x34\x0b\xb2\xa8\xaf\x78\x6b\xef\x2c\x2f\xa5\xa8\xad\x77\x8e\xf7\xbb\xb4\xa2\x94\x06\xe0\x21\x0b\xe5\xcb\xa8\x88\x6d\x33\x4b\x4e\x71\xd1\x6c\x49\x89\x32\x9a\x2d\x4a\x8e\x25\x42\x11\xcd\x50\x04\x68\xa2\xd9\xb2\x66\x40\xd1\x6c\x49\x03\x1f\xcd\xb6\x0e\x0b\x8b\x66\x4b\x1e\x04\xd1\x6c\x43\x24\x96\x03\x41\x34\x43\x73\x20\x89\x66\x68\x16\x74\xd1\xcc\x6d\xaa\x32\xe3\xee\xff\x88\x4e\x39\x5f\x69\xd3\x46\x8f\x65\xd9\xf1\x64\x48\x22\x08\x96\x04\x51\x14\x59\xd5\x12\x2c\x8e\xac\xa8\x10\x44\x92\x15\x8d\x88\x58\xb2\xe2\x42\x11\x4d\xb6\x64\xe2\x79\x50\x44\x14\x0a\x1e\x34\x51\x85\x82\x09\x59\x64\x69\xf8\x2d\x3a\x9e\x38\x1d\xd2\x28\xe2\x4a\x84\x02\x53\x44\x8c\x28\x40\x9a\xe8\xe0\x2d\x0d\x8a\x09\x1e\x16\x1f\x09\x3c\x24\xbc\xfd\x7b\x5c\x82\x56\x3f\x02\x43\x31\x09\x5a\x78\x34\x26\x49\x6b\x8e\x46\x25\x6c\xb9\x1f\xaa\x75\x27\x82\xa4\x95\x91\x27\xe0\x57\xba\x47\x07\xe1\xa3\x3c\x7c\xc9\x28\x36\xaa\x2c\x39\xd1\xc6\x97\x45\xd9\xf1\x64\x68\x62\x0e\x92\x04\x55\x1c\x5a\xd6\x12\x30\x22\x2d\xa9\x50\xc4\xa6\xad\xfb\x42\xa3\xd4\x92\x0b\x49\xbc\xda\x90\x89\xe7\x41\x12\xc3\x08\x78\xd0\xc4\x35\xa1\x2b\x69\x0c\x6c\x81\x71\x26\x4c\xd3\x52\xee\x9a\xc7\x5f\x50\xd0\x6b\xd1\x06\x0e\x5f\x26\x1c\x9c\xf0\xf3\xe1\xa0\x44\x81\xa1\xb7\x3a\x2c\x20\xf4\xd0\x04\x81\xa0\x87\x8d\x08\x00\x3d\x36\x45\xc3\x9f\xc0\xe1\xb8\x14\x0d\x3d\x05\x97\xa6\x61\xa7\x20\xd3\x0d\x5a\x5a\x9d\xdf\xb9\x11\xac\xe1\x1f\x95\x5b\x56\x91\x55\xa3\xb4\x65\xf9\x9d\xeb\x9b\xb8\xf2\xfc\x8d\xe5\xe6\x01\x60\xb6\x2e\xe8\xb2\x5b\x10\xba\x4d\x6c\xf8\xbe\xca\xba\x60\xd3\x8f\xb5\x7a\x95\x25\x64\xc4\xb5\xe1\xbb\x5b\x10\x3d\xdf\xc8\x18\xba\xa1\x49\x1a\x4d\xd7\xa5\x27\xd5\x33\x45\x84\xdd\x98\x09\xd6\x1c\x36\x64\x28\x42\xc1\xca\x05\xfa\x91\xbc\x62\xb5\xb2\x4c\x0b\x58\x34\x5e\x97\x71\x99\xeb\xd3\x55\xdb\x9c\x61\xce\xeb\x5c\x94\x8c\xd7\x05\xd3\xe2\xb5\xad\xa3\xec\x37\xd0\xdc\x14\x72\x12\x57\xd7\x41\x32\x51\x35\xf6\x63\xa8\xbc\x24\xba\x3b\xe5\x9c\xc3\x58\x8b\x4a\x3d\x04\x86\xeb\xb2\x04\x7a\x96\xa9\x81\x65\xe0\x77\x4e\x60\xe9\x4b\x4f\x21\x44\x1b\x58\xe6\x95\x09\x1c\xd6\x6c\x18\x51\x0c\x70\xf6\x08\xa5\x70\x39\x2b\xd2\xa5\x70\x21\x19\x08\x0d\xd7\xc3\x6a\xd1\x8d\x1b\x86\x56\xa7\x5b\x80\x33\xaf\x54\x2f\x4e\x0d\xeb\xc3\x6b\x3e\x69\x4c\xf6\x79\x44\x54\xd2\x9a\x46\x5c\x33\x5f\xf3\xa1\x6c\xe4\xab\xb2\xe3\xc9\x50\x34\xf0\x1d\xaf\x89\x27\x42\xd0\x96\x4c\xdb\xb8\xe1\x2e\x30\xa1\x6d\x21\x4e\x62\x88\x45\x89\xe0\x34\xb6\x25\x0f\x1a\xbf\xb0\x82\x57\xfd\x81\xa7\xa2\x60\xdd\xff\xb1\xd6\x1c\x3f\x35\x30\x53\xbc\x2c\x94\x90\x31\x65\xa2\xd2\xf7\xbe\xd1\x6c\xd6\x7a\xf8\x29\x97\xe7\x14\xd7\x8c\x3d\x17\xca\xc6\xeb\x4a\x84\x02\x53\xf8\x67\x14\x20\xcd\x02\x8a\xb7\x34\x68\xc0\xee\x61\xf1\x8b\x27\x93\xc3\xc1\xc6\x18\x1e\x97\x60\x5c\x31\x02\x43\x31\x09\x62\x5e\x34\x26\xc9\x38\x21\x1a\x95\x6c\xb1\xc4\xca\xfc\x4d\xd8\x6e\xd8\x53\xb4\x79\xd7\xd7\x2c\x7f\xc0\x64\xb1\x12\x41\xbe\xc4\x71\x5c\x18\x6d\x38\xc0\x7e\x1a\xfa\x6b\x48\x62\xcc\x97\x7f\x05\x51\xe0\x42\x3b\x1a\x2c\xe8\x1d\x7f\x0b\x41\x34\x44\x7f\x47\x44\x24\x3d\xfe\x18\x8a\x10\x4b\xf1\x35\xe8\x0f\xa1\x88\xdb\x3f\xc4\x87\xd0\x74\x06\x3f\xc4\xa7\x9c\xd7\xc3\xb8\x1c\x02\xf8\xbd\x01\x2b\xfd\xcb\xa4\x4b\x1e\x92\xdc\x98\x3a\x9d\x99\x3e\x95\xd9\xf4\xdd\xac\x90\x26\x57\x2d\x68\x6d\xfb\xb9\xf5\xa6\x52\xce\x60\x6b\xda\xab\xc9\xb5\xbc\x0a\x66\xd5\xf0\x9b\x78\xb6\x7b\xa5\x9c\xc1\xd6\x9d\x7c\x2a\x6a\xc8\x0c\x6a\xc5\x70\xd0\x3c\x83\x55\xbf\x12\x8c\xa8\xed\x75\x09\xa7\xd4\xf4\x47\x9d\xb3\xef\x46\x95\x25\x47\x54\xf4\xb6\x90\x33\xb8\xfa\xf8\x3c\x00\xb9\x53\x80\xf1\x5c\x77\x0a\x39\x83\x6b\xec\x9d\x47\x6b\x9a\xa4\x37\x1f\x1d\x18\xf3\xca\x8b\xc0\xab\x92\x47\x56\x74\xda\xe7\x04\x72\xb7\xc8\x91\xc8\x6e\xae\x4d\xcd\x0e\x33\x61\x3a\x75\x86\x14\x4f\xe6\x84\x09\x4e\x6a\x90\xa3\xae\xa5\x84\xd9\xc6\x29\xd3\x8b\xc4\xc9\xc2\x39\xb3\x83\xf8\x71\xe5\x39\x83\xfb\x14\x1e\x34\x63\x73\xcd\xf3\x37\xc6\x9b\x46\xf0\xe1\x02\xac\xa6\xd1\xea\xf8\x21\xd8\x1d\xd5\x4b\xaf\x86\xf6\xda\x0d\x1f\x2d\x7e\x13\xa0\x1e\x78\x41\xc7\x6b\xd1\xb2\x89\x8c\x73\x0b\x3e\xa4\x51\x6e\x5e\x72\x2c\x11\x92\x08\x87\x21\x40\x14\xdd\x16\x35\x03\x8b\x6d\x0b\x1a\x04\x91\x6d\xe3\xaa\xc0\xb8\xb6\xe0\x41\x11\xd5\xd6\x44\x62\x39\x50\x44\x34\x2c\x87\x73\xa2\x59\x2c\x8b\xf3\x0e\x1a\xcc\x7f\xf0\xc1\xba\xd1\xa6\x11\x9a\xe1\xb2\xff\xf7\x8a\x38\xf3\x08\x00\xf0\x2b\x12\x89\x9f\x93\xa9\x0f\x34\x3c\x28\x82\xec\xd2\x3e\x21\xab\x1f\x46\x19\xe4\xde\xbb\x94\xa9\x1f\xc2\xe9\x26\xcd\xea\xd5\x82\x6f\xeb\x72\x6a\x97\x99\x0a\xb6\xd2\x27\x1e\x6d\x1d\x47\x62\x90\x27\x64\xe0\xe7\x81\x53\x7a\x3f\x98\xca\x5a\x11\x19\x0c\x27\x4a\xfe\x13\xd9\x2b\xcf\xc5\x55\xa9\x37\x96\xab\xba\x16\x11\x31\x66\x38\xeb\xb4\x57\x02\x9d\xe1\xae\x1c\x4c\xe7\xca\x09\x71\xdb\x3a\x02\xd9\x09\xd3\x61\xbf\xc9\xb2\x64\xc6\x6a\xc1\x2b\x28\x83\x99\x0a\x1d\x0f\xb7\xa0\xe6\xaa\x94\xe5\x77\x0e\x18\xc4\xf4\x6e\xb1\x54\xa3\xe3\xa3\x85\x11\xb6\xff\x4a\xf6\x26\x3e\xa0\x84\xd6\x7a\x74\x8c\xdc\x65\x5b\xbc\xae\x95\xf5\xb7\xae\x30\xc8\x4a\x9b\x27\xb5\xa3\x7a\x22\xaf\x42\xbd\x83\xbd\x79\x57\xf9\x44\x6e\x79\x29\x38\x60\x4d\xfa\x09\x39\xa7\x7d\x22\x3b\x51\xf3\x2b\xe4\x58\xc2\x13\x7a\x5e\xfd\xcc\x9a\x95\x06\x45\xb0\xd7\xa7\x63\x98\xdf\x79\x7d\x13\xac\xe1\xc6\xbc\x2b\xc8\x5b\x15\x9e\xd8\x4a\x8d\x32\x6a\x74\x70\xf0\x58\xe1\x7e\x4a\x17\x43\x7d\x1f\xd9\x08\x6d\xa4\xb1\xa2\xb6\x2c\x57\xea\x0d\x3c\x1e\x1e\x3b\xd9\x6d\x01\x84\x35\xd6\x35\x21\x17\xab\xd9\x95\x43\x4e\x29\xf6\x35\xb6\x54\x23\xb7\x99\x91\x56\x30\x7f\x0d\x8c\x55\x6f\x22\x76\x58\xb2\x56\xa7\xe3\x27\xab\xae\x36\x54\x0d\xda\x3e\xf5\x9c\x66\x2a\x74\x3c\x5e\x35\x6f\x0b\x16\x31\x4e\x19\x15\xe8\x38\xb8\x9c\x4f\x35\xde\xa7\xd8\x68\x75\xd3\xf0\x61\xcb\xbe\x36\x65\xdb\x77\x1b\x1c\xaf\x5a\x55\xa9\x14\x0f\x8a\xa0\xe3\x69\x44\x5d\x8c\xa5\xcb\xfa\x26\x8c\xf5\x6f\x96\x81\xa7\x4d\xcf\x0a\xa0\xe4\x68\x59\xa3\xa5\xd2\x6e\xfa\xe9\x20\xe0\xec\x36\xaa\x94\x23\xf5\x57\x55\x96\xea\x9d\xf1\x12\x6c\xae\xb9\x0e\x61\x1c\x55\x75\xde\x6a\xdd\xc5\x68\x63\x39\x64\x93\xa7\x0f\xa4\x2b\x3d\xe4\xca\xc1\x44\xe8\x21\xc5\xfb\x55\x45\xb2\x59\x28\x91\x51\xe9\xe2\xf0\x07\xd3\xe2\xd6\x75\x62\xe0\xd1\xde\x52\x8b\x30\x6a\xb9\x72\x0b\x91\xc6\x67\xd2\xa3\x66\x64\x23\x1a\xd5\xa4\x41\xc3\xc2\xbf\xd0\x05\x6f\xd2\x9d\x34\x89\x7b\xc4\x2f\x6f\x9e\xf0\x3a\x32\xb8\x23\xa7\x7b\x08\x19\xbc\x37\xe0\x91\xe9\xde\xf8\x85\x2e\x11\x52\x3e\xe7\x0b\xc7\x24\x7b\x6c\xdf\xb2\x52\x45\x67\x6e\x4f\x8a\xa4\x3e\x36\x15\x1b\x45\x81\xc2\xdb\x66\xa6\x00\xd5\xc2\x0c\x9e\xa0\xfa\x1f\xaa\x58\x6d\xdc\x1a\x55\x42\x36\x92\x67\x8a\x97\x5e\x09\x5b\x09\x73\x2e\x71\x5e\x31\x27\x43\xe9\x16\xb3\x72\xe3\x48\x50\x38\xc6\xaa\x6a\xe2\x08\x10\xb8\xc6\x90\x08\x57\xf2\xe8\x1b\xc9\xe7\xaa\xa4\x15\x32\x2f\x38\x92\x06\x45\x95\x20\xe0\x69\x36\xca\x16\x75\x02\xda\xfe\x5a\x90\xc0\x6f\x7b\x7d\xa8\xd6\xb6\x57\xc1\x52\x86\x06\x0b\x5d\x52\xb7\x58\x94\x1c\x4b\x84\xa8\xad\xc6\xdd\x4b\xd7\x29\x10\x5d\x46\x37\x62\xc3\xb7\xd1\x1c\x3a\xd5\x2e\x9a\xc3\x8f\x8e\xd7\xe4\x81\x1a\x16\xa1\x69\xab\x1b\x08\x49\xf2\xf6\x72\x95\x72\xcb\xcd\xa0\x46\xfc\x86\x79\x05\xbc\xd3\x66\x84\xa7\x79\xb1\x3c\x1a\x96\xea\x7d\xf2\x2a\xe2\xea\x9c\x11\x1c\x57\xeb\xb9\x75\x3b\x01\x5d\x91\x47\x98\x41\xc1\x48\x5c\xbf\x2a\x1b\x7e\x1a\x59\x54\x57\xa1\x2f\x73\x69\xf6\x5b\xfa\x6a\x84\x2b\x8d\x15\xe2\xf8\x15\x28\x8f\x59\x88\x46\xd4\x85\xa8\xf3\x27\x6b\xec\x20\x40\x97\x40\x24\xeb\x5b\xa6\x45\x21\x75\x20\x55\x71\x10\xbe\x0c\xc2\xc9\xb0\xba\xad\x6b\x59\xdf\x8e\xc0\x7a\x11\x64\x8b\xe9\x4b\xc9\x5c\x29\x9f\x07\x67\x1a\x5e\x1c\x76\x3f\x03\x9c\x13\x4c\x87\x13\x46\x1c\xd6\x58\xd7\xb1\xfb\x6d\xe5\xcf\xc0\x60\x8d\xc2\x2c\xf2\xb8\x32\x32\xd3\x5e\xab\xe3\xc5\x86\x19\xa0\x17\xc6\x7d\x5b\x0a\x22\xc5\x97\xba\xdb\xba\x8e\x37\xfc\x66\xb8\x5e\x38\xf9\x4b\xdf\x34\x7f\x13\xfd\x63\x05\xbf\x64\xe3\x03\x07\xfe\x1f\x6c\xca\x59\x10\xb9\x3e\xae\xed\xdd\x82\x2e\x73\xed\x74\xb3\xec\x96\x1d\x4f\x06\xdb\xd9\xed\xdb\x2a\x30\xc9\xd8\xa7\x82\x99\x67\x3c\xa9\xb2\xe3\xae\x77\x9f\x06\xaa\x07\x26\xe4\x81\x5c\x32\x5b\x16\xda\xfd\x29\x6a\x2b\xf3\xc0\xf6\xe6\x52\x4b\x8b\xbf\xb7\xc2\xd8\xcb\x5c\x9b\xc8\x34\xa5\xba\x1d\x8f\x51\xf6\x99\x38\x35\x2a\x6f\xed\xfe\x54\x5a\xfe\x5b\xa2\x45\x9c\x2a\x91\x39\x78\x59\xaa\x88\x26\x33\xd2\xe8\xd4\xa8\xcc\x51\x8a\x1b\x3f\xdc\x6c\x7b\x52\x25\x9d\x1a\x91\x19\x82\x29\x01\xfb\x14\x90\xa9\x00\xfb\x5e\xe1\x52\x69\xe2\x9a\xee\xc0\x87\x20\xeb\xd6\x17\x0c\x80\xf6\x7f\x21\x87\x62\x7d\x59\x57\x6e\x20\x6d\xa1\x87\xec\xa4\xb1\x88\x3e\x7f\xcf\x8c\x2f\x5d\x03\xd0\x7b\x95\xcb\xa0\x42\x45\xc1\xb4\x55\xc5\xf5\x61\xfe\xe1\x8a\x41\xaf\x81\x25\xe0\x5f\x85\xb6\xea\x30\xcb\x70\x2e\x7b\xb1\x6a\x37\xad\x30\x1e\x34\xc2\xec\x1e\x99\xca\xe8\x3e\x5f\x00\x32\x5e\xe9\x25\x69\x1c\xfc\x21\x0b\xa1\xa0\xb6\xf6\xc2\x14\xc6\xee\x61\x7d\x7a\x02\xc8\xda\x3d\xf6\xa0\x41\x44\x00\x16\xcc\x7a\x6c\x8a\x71\x50\xbf\x4f\xe8\x8e\x26\xc8\x22\xbb\x96\x2a\x7f\x83\x54\xba\x17\xa4\xa9\xf3\x5d\x0e\x40\x53\xf4\x3c\x4e\x33\x45\x1c\x0d\x9a\x11\x21\x01\x11\xb2\xfe\x6d\x4d\xc6\xfb\xbb\x71\xe9\xa6\xb5\x38\xde\x3f\xeb\x4b\xe8\x55\x4e\xf1\x95\x35\x1d\xa0\x95\x06\x4a\x27\xb8\x0d\x92\xd1\x29\x1e\x84\xe4\x74\x9a\x33\x35\xad\xb9\xb3\xfe\x1a\x96\xf0\xda\x64\x5f\xc6\x56\xe9\x14\xcf\xda\xc2\x00\xad\xb6\xc3\xef\x04\x37\xa3\xa4\x77\x8a\xcf\x51\x12\x3c\xcd\x01\x53\xf8\x39\xdd\xd3\xea\x17\x4c\x81\x0e\x15\x0c\x48\xd6\xcc\x7e\xbc\x86\xff\x43\x36\xf7\x1f\xb4\x91\xff\xa0\x4d\xfb\x2a\x2c\x1f\xa7\x8a\x9a\xd7\x85\x3a\x4c\x36\xdf\xd1\xba\x78\x2d\x6c\xd5\xcd\x7b\xd9\xa1\x0f\x05\x30\x19\xd4\xfa\x29\x45\xfa\x26\xd8\x2e\x0d\x3f\x2b\x8c\xe3\xd1\xeb\x90\x12\x71\xdb\xa8\x3a\x97\xa0\x75\xac\x91\xca\xa4\x85\x5e\x43\x5a\xb0\x81\x1d\x6a\x5c\xb3\x39\x3e\xd2\x18\xe9\xb6\x0b\x3e\x7e\x62\x17\xc3\xc5\x6b\x90\x56\x91\x28\xa4\x55\xc7\xf9\x36\x6b\x16\xbd\x0a\x29\x8d\xe0\xfd\xd7\x6b\x12\x4e\x81\x8e\x42\xff\xaf\xcd\x30\x01\xb2\xfc\x44\xdf\x49\x85\x79\x01\x63\x30\x7d\x57\x15\x39\xab\x98\x9a\xd1\x17\x62\xd3\xf4\x86\x7d\x71\x31\xc0\x94\xce\xf0\x25\x1f\xdc\x58\xf8\x38\x75\x10\xa7\xaa\x6a\x9b\x89\x4a\x59\x99\xc3\x5a\x61\xa7\x70\x19\x14\x18\x95\xe1\x27\x0e\x4c\x56\xa1\x47\x98\xf7\x99\x38\x35\x12\x2a\x2e\x5c\xa7\x9a\x84\x8e\x82\xbb\xc9\x10\x8c\xef\xa5\xa9\xc0\xa1\xa8\x14\x2e\xe8\x4f\xdf\xc4\xac\x7d\x79\x8d\xcb\xa0\x41\x44\xc0\xad\xf4\xc3\xd1\x9d\x38\x11\x74\x3f\x54\x86\x83\xf7\x0a\x44\xf0\xc1\x4c\xe0\x25\xb8\x13\x27\x82\x0e\xe5\xa2\x2e\x91\x3b\x69\x1a\x60\x38\x26\x49\x88\x83\x0e\xbb\x28\x1e\x3a\x99\x17\x05\x6c\xcb\x04\x6f\x71\x0c\x93\xd1\xe1\xe5\x44\xf1\xbd\xfb\x15\x2f\x33\x2d\xf2\x56\x97\x90\xa9\xc0\x46\xf7\xd2\xeb\xa2\xa7\x27\x5b\x56\x0d\xff\x68\x40\xb3\xa5\x2d\x29\xaf\x7a\x02\x27\x7f\xfa\x20\x89\x93\x57\xa5\xaf\xbc\xfe\x40\x84\x69\xaf\x08\x5a\x9d\x3a\x7e\x86\xb9\x4d\x47\x73\xb3\x34\x77\xb4\xb7\x05\x75\x93\x7d\x82\xd1\x5c\x0d\x6b\xb1\x3f\x34\xdc\x42\x62\x49\x9f\x3a\x90\x2b\x6d\x58\xa3\xc5\x6b\x29\x6f\xf7\xdd\x24\xb8\xbf\xfd\xf3\xaf\xff\xeb\x6f\xff\xe7\x5f\xce\x22\xa0\x55\x6b\x65\x7d\x63\x42\x6b\xb5\x7b\xe0\x37\x0c\x5c\x09\xcb\x0b\x6e\x79\x26\x1e\xa1\xd4\xbb\x95\x28\x32\xae\x21\x80\xb1\xd9\x7e\xab\xf2\x42\x51\x75\x0d\x8f\x4b\x6e\x6f\x1a\x93\x7d\xbf\xaa\xef\xaa\x16\x3f\x67\x2f\x0f\x29\xde\x7f\x7f\x98\x58\xdf\x34\xe6\xd2\xcb\xe3\x40\x9b\x92\x7f\x18\x7f\xb5\xce\x5f\xc0\xc8\x73\x25\x1c\xbc\x3c\x5e\xb3\x71\x68\x12\xb1\x4a\xc3\x1b\x99\xc9\xba\x0f\x74\xbc\x2d\xe4\xb5\x14\xac\xe2\x37\x99\x33\x2d\x4c\xa3\xea\xd0\x63\xeb\x00\x7d\xec\x59\x8e\xcf\xa0\x88\x3e\xf7\x01\x00\x09\x9e\x06\x81\x10\xc5\x1e\xa6\x9e\x63\xf4\xd7\x8b\xc0\xad\x37\x28\x50\xd6\xe8\xab\x96\xa2\x2e\xcc\x5d\x36\xa6\x9b\x02\xf0\xfa\x16\xb8\xbd\xe1\x89\xf2\x65\x50\x3e\x81\x96\xa8\x0b\x56\x2b\x2b\x5f\x65\xce\x83\xc7\xa8\x9e\xf2\x5b\x97\x42\xe5\x6d\x3a\xbf\xcb\x47\xe7\x5e\xfd\xbf\xdc\xfa\x9d\xd0\x0f\xa1\x59\x29\x03\xd7\x4f\xec\x15\x74\x99\x29\x13\xb5\x5a\x72\x8a\xfd\x2d\x9a\x01\xa6\xf1\x4d\x62\x97\x69\xdb\xbc\x09\x71\x7c\x0f\xe0\x13\x92\x9d\x1e\x31\xb1\x07\x2f\x65\x11\xba\xa8\x6a\x97\xce\xa0\x49\x5c\xa7\x5a\x34\xa5\xcb\x0e\x8f\x08\x6e\x03\xa5\x49\x97\x98\x54\xce\xf3\x7b\x0a\x21\xaf\x47\x4c\xa6\x6d\x4a\xc5\x0b\xc0\x20\xfd\x99\x1b\xcd\xd4\xcf\xa1\x56\x8a\xfa\x76\x3c\x84\x3e\xa4\xe6\xd5\x89\xa9\x5d\xb5\xe2\x45\xce\x8d\x65\x39\x2f\xcb\x2b\xcf\xdf\xe2\xf9\x6d\xcb\x38\xc7\x7e\xaf\xb2\x96\x26\xc9\xe1\x56\x05\x50\xf7\x09\x7d\xf1\x8d\x56\xb9\x30\x06\x41\x70\x2c\x81\x9a\xa1\x3b\x52\x2e\x55\xcd\xde\xb9\x0e\x1d\x75\xdc\x67\xb8\x2e\x81\x9a\x61\x37\xe6\x37\xcc\xbd\x44\x95\xdc\x51\xcd\xca\x38\xb1\xa3\xf2\xdc\xa2\x43\x0c\xeb\xf5\xb0\x73\xb4\xb3\xe9\x51\x8e\x7d\x07\x82\xf1\x35\x4a\x39\x9b\x49\x26\x41\x3b\x5f\x19\x2b\x2b\x66\x82\x32\x8e\x16\x4f\x70\x9a\x14\x1e\x94\xde\x71\xe5\x75\xff\x22\x3d\x98\xc7\xa4\x42\x5b\x39\xd7\x92\xe7\x6f\xdd\x00\x57\x14\xac\x9b\x8c\xc4\xd8\x66\xa5\xfb\xe3\x12\xa3\x78\xaa\x60\x5e\xbe\x1b\xc6\x45\x31\x72\x1a\xf4\x3c\xf6\x72\x2b\xfc\xda\x2b\xcf\xbb\xfe\x14\xce\x6f\x91\x96\xd3\x6b\xd3\x34\xbb\x91\x64\x4a\x47\xb7\x4a\x03\xa0\xef\xe8\xa0\x79\x18\x47\xac\xc8\x98\xf8\x14\x85\x44\x3b\xf9\x84\x85\x13\xed\x04\x4a\xa0\xd8\x67\x45\x17\xc4\x71\x3c\x28\xeb\xcb\x67\x94\x6a\xd5\x08\x1d\x7c\xaf\x66\xad\x67\x2e\x93\x22\x8d\x5d\x56\xf9\xe1\xdd\xa4\xf7\xa6\x8e\x8f\x1c\xee\xb0\x1a\xd4\x88\x62\xf8\x8a\x14\x74\x33\x69\x87\x18\xc9\x86\xd2\xa1\xc1\x40\xe9\x9d\x7b\x26\x23\xc8\xf0\x3c\x34\x9a\xea\xe6\xe6\x4a\xf3\x9b\x60\x45\xab\xe3\x16\x08\x7b\xe3\xed\x14\x41\x63\x44\xc0\x59\xcb\x3d\x79\xca\x41\xae\xbb\xfa\xca\xbd\x75\x13\x31\xb9\x73\xb7\x60\xf5\x4a\x84\x34\xb4\xc8\x95\x2e\xa2\x89\x8c\x6a\x84\x54\x52\x3a\x11\x7f\x0b\xdb\x49\x1d\x88\x63\xf5\x2a\x6b\x5e\xca\x7f\x13\xac\x92\xb7\x48\x57\x76\xe4\xb6\xfa\x44\x8d\x2e\x78\x5f\xdb\x86\x0a\xe9\x60\x17\x74\x7f\xdb\x86\x02\x5d\xaf\x9a\x86\x4f\xd9\x9b\xa6\x31\xa0\x1e\x50\x97\xf2\x21\xb2\xe8\xf5\xc0\x4e\xeb\x72\xb4\x02\x98\xe0\x11\xc3\x95\x90\xe6\xce\xb5\xac\x6f\xd9\x8b\xfd\x68\xc4\x70\x10\xa1\x09\xde\xaa\x78\x50\xd4\x65\x28\x00\xc7\x34\xd7\xaa\x66\xbf\xa9\xab\xc9\x60\x1d\xfa\x28\x7f\x21\xe8\xc5\x57\x7d\x64\xc9\xeb\x5b\xcb\x03\x2f\x5a\x0f\x6a\x97\x41\x1a\xe5\xb8\x4f\x0e\xaa\xfa\xbb\x0f\x3a\x87\x08\x71\xe9\x24\xd9\x70\x50\xb5\x53\xa0\x34\xc8\x82\x4e\x14\x13\x7c\xcf\x7c\x68\x19\x40\x0b\x5f\xd0\x41\x87\x38\x52\x36\x04\x01\x8f\x94\x0f\x51\xf8\x43\x9c\x94\x77\x2d\xbb\x5f\x7b\xa0\x73\xa1\xf9\xee\x78\xf8\x0a\xdd\xa5\x02\x32\x75\x76\xf6\x41\xcb\x65\x95\x86\xbb\x1f\x29\x5d\x84\x13\x08\xbc\xec\xc5\xc9\x22\xa3\xec\x01\x15\xbf\x75\x02\xe4\xe2\x85\xcf\x23\x93\xb7\xc6\xba\x17\x6f\x02\xc7\x3b\x66\x94\xe6\x2a\x67\xd5\x17\x90\x0a\xde\x65\xf1\x1c\x28\x06\x94\x47\x35\x04\x08\x2e\xa3\xaf\xa0\xc3\x1c\x0d\x11\xa2\xf8\xb6\x38\x9d\xd7\xbf\x7c\x0f\x0c\x6a\x6e\xa1\xa6\x93\x27\x72\x0e\x59\x64\x7e\x6d\x15\xf0\x44\xd9\x9c\xc5\x5c\xe9\x07\xa7\x02\x4e\xaf\xdd\xd0\x71\xf7\xe9\x82\x79\x38\x69\x3a\x5b\xcc\x8f\x17\x7e\x9d\x73\x74\xd3\xee\x08\x1b\x78\xf1\x1f\x10\x3e\xdd\x09\xdc\xfb\x80\xf0\x65\xd5\xe9\xa4\xf5\x52\x8f\xce\x26\x8d\x56\xaf\xb2\x14\xec\xda\xfd\x0c\x6e\x9b\xa5\x1a\x55\x58\xf7\xcf\x78\xfb\x47\x14\xe7\xc9\x7e\x91\x6d\xf8\xa0\x8c\x53\x3a\xa0\xd9\x4b\xe4\xe1\xd0\xbf\x7c\x66\xfc\xd9\x0c\xe0\xab\xf8\x9c\xd8\x4d\xcf\x58\x05\xdf\xd2\xd8\x61\x86\x7a\x4c\x03\xc6\x2a\xf8\xfe\xd4\x0e\x2d\xdc\x3b\x54\x9f\xea\x53\x5f\x48\xe9\xbc\x31\x17\x82\x14\xf9\xf8\x6b\xb3\x4d\x5d\xf1\x9a\xdf\x84\xee\x9f\x7a\x2a\xb9\x15\x05\x0b\xdf\x25\xd1\x15\xba\xd0\xbf\x2c\x75\xe9\xeb\x76\xcb\xd6\xc7\x01\x76\x97\xb7\xbb\x3b\x69\x14\xc7\x77\xad\x7d\x42\x3c\xd9\x52\x16\xdf\x21\x29\x27\x4b\xa2\x5e\xe7\x6c\x7a\x71\x9c\x4e\xe8\x12\x96\xc6\x6a\xb8\xb1\x6c\x4c\xee\x8c\x74\xc5\x95\xf2\xd9\xbe\x38\xba\x50\x24\xcd\x49\xef\x6c\x86\x5a\x8c\xd6\x88\x6d\xd4\xa3\xe2\xe9\xed\xe3\x4d\x96\x25\x4b\x66\xba\xd6\xfe\xb1\xda\xcb\x49\xab\x1b\x08\x46\xa7\x0d\xa2\x96\x95\x0a\x18\x44\x2d\x79\x9d\x32\x84\xda\x09\xc4\x80\x61\xd4\x2a\x0c\x9f\x32\x88\xda\x30\xa3\x89\xc3\x5f\x4a\xea\xac\x81\x14\x92\xd6\x09\x4b\x59\xe0\xd9\x1e\xba\x9e\x8c\x15\xbc\x82\x40\x3a\x41\x3c\x9e\x5f\x57\xc8\x64\xfd\xaa\x42\x88\xf6\x5d\xda\xfc\xde\x6b\x5c\x3a\x0d\x0a\x64\xd0\x6c\x7a\x09\x8d\x5f\x9a\x3b\x01\x3b\x6a\x19\x66\x7c\xb7\x2f\x66\x59\xd0\x6d\xc3\x93\xad\x4e\x8e\x14\xdc\xe2\x44\xc1\xed\xe1\x55\x0d\x23\xfe\x28\x4d\x03\x5e\xb5\xdd\x54\xc2\xbd\xb2\x15\x1e\x54\xb9\x4c\xa2\x99\x02\xd1\xf7\xfb\xf9\x81\x7f\x3d\x15\x66\x83\xb9\x06\x2a\xfc\x9d\x4a\x02\xdc\xbd\x9f\xc9\x22\xa9\x59\x80\xa0\x09\x7a\x9f\x28\x3c\xa2\x6e\x05\xfa\xae\xf0\x52\x94\x60\x60\x69\x65\xfe\x26\xdc\xba\x6d\xd1\xe6\x76\x5c\x89\xaf\xa4\x65\xc3\x6d\x5f\xc1\x50\xb8\x2c\xe2\xb2\x52\xc7\x79\xe1\x01\x3f\x77\x1b\x58\x22\x39\xa7\x4b\xcf\x4c\x8b\x4a\x3d\x44\xb2\xe5\x56\xea\x58\xa7\xda\x61\x18\x6d\x2e\xec\x48\x82\x80\x03\x7d\xd2\x87\x47\x08\xb6\xb4\x5e\x8c\x2e\x25\x27\x7a\x8d\xcd\xe7\x4b\x11\xae\xad\x4d\x44\xdc\x6b\x5b\xac\x3f\x33\xae\x82\xd3\xc7\x3e\x73\x6b\xa9\x44\x44\x65\x78\x09\x25\xbb\x2b\x63\x01\xc9\xbb\xab\xfb\x8e\x45\xc1\x7a\x45\x1a\x3e\x30\x53\x10\x79\x25\x0c\x0c\xef\x81\xd3\x2b\x31\x29\xcb\xbc\xa4\x3e\x08\x7b\xb0\x66\x86\x8d\x0e\x42\xc3\xcb\x46\x0c\x94\x8e\xb7\x94\x26\xb0\xbd\xd2\x57\x69\x62\x1e\x0a\x1a\x95\x18\xd5\x5b\x41\xe7\xd3\x88\x1a\xd2\x2d\xa8\x80\x2a\x65\xc1\x03\x77\x2d\xe5\x99\x04\x70\x56\xc8\x5e\x4c\x2e\x98\x95\xb6\x14\x2c\xdc\x3a\x36\x8c\x68\x2d\x72\x02\x99\x74\xeb\x04\x5e\xf5\xda\x30\xc0\x3c\xec\x75\x16\x78\xfa\xd7\x87\xaf\xf3\xdc\x70\xf0\x2a\x74\x36\x20\xa5\x90\x6c\x89\x28\x7c\xe2\xc0\x0d\xe8\xaf\x96\x9f\x8f\xed\xb5\x50\xe8\x04\xc3\x93\x19\x7e\xd2\xc7\xfb\x7f\x13\x98\xc0\xa7\xce\xc6\x55\x3e\xc5\x06\x87\x47\x07\x5c\x99\x3e\x0a\x5f\xaa\x0f\xd6\xcb\x13\x7c\x37\x21\x72\x42\x8b\xeb\x4b\x1b\xd7\xe0\x61\x34\xc8\xbf\x9e\x0e\x3f\xc1\x06\xc3\x25\x97\xc0\x2a\xe8\xa5\x09\x5a\x1d\x1d\x70\xc2\x57\x03\x6e\xea\x9e\xb0\xb1\xb7\x74\xd3\xc3\xa6\x7c\x31\xbc\x77\xa3\xeb\x59\x69\x40\x53\x5a\xb6\xaa\x5f\xe5\x0d\x78\x94\xb9\x6f\x56\x73\x15\x8a\xc6\x7d\x02\x85\x74\x4f\x8f\x98\x01\x90\xcd\x3d\x28\xa1\x11\x5f\x1e\x35\x0f\xa4\x9c\x87\xd2\x13\x40\x58\x21\xae\x8f\x21\x0f\x79\x74\xf8\x09\x36\x00\x5e\x21\xe0\xa1\x7b\x61\x82\x4f\xa7\x82\x4d\xf8\x62\xd8\xcd\x4f\x1e\xd9\xcb\x52\x8c\x23\x69\x50\x13\x3e\x77\x78\xf4\x3e\xb8\x57\xe2\xb1\x47\x71\x82\x4a\xe6\xaf\x56\x68\x16\x4b\x60\xa9\x44\xd1\xdb\x0c\xd7\xe9\x03\x7b\x9a\x41\x9c\xc2\x02\xb9\xbb\xc2\x81\x41\x52\x29\xfa\xcf\x9f\x69\xe0\x09\x38\x3b\x3a\x17\x10\xb5\x75\x57\xb1\xc2\xa6\x51\x9d\xc6\x65\xae\x46\x45\xc5\x6d\x21\x44\x70\x70\xf2\x04\xed\x6f\x32\x04\xdc\x15\x27\x2b\xe0\x3d\xb1\x3f\x60\xdc\xfd\x05\x39\x62\x4c\xb0\x7e\xf0\xfd\xaa\xbe\xc7\x0d\xb4\x3a\x0d\xc2\xa1\x9e\x23\x00\x9d\xc9\x38\xec\xc3\x19\x14\xb8\xbe\x1d\xae\xef\x24\xc1\x3d\xab\x83\xf7\x3a\xf8\x6f\x36\x26\xd8\xd6\x3d\x9e\xd9\x6d\xe1\x91\x5f\xda\x68\xf9\x90\xa5\x08\xef\x85\x3b\xcc\x51\x9a\x00\xb9\x90\x26\x57\x75\x2d\xc2\xa7\x39\x1d\xf4\x24\x4e\x80\x0d\xeb\x4e\x1d\x2e\x45\x1f\x5e\x28\xcb\x7f\xd9\x26\x26\x66\x15\xb7\xf9\x1d\x94\x28\xe5\x4a\xb8\x4c\xf2\x28\x37\xcb\xc3\xe7\xf2\x48\x0e\x55\x9b\xac\xe2\x0d\x04\xab\x13\xc3\x42\x45\x36\xd9\xdc\x50\x34\x58\xb7\x50\x28\x1f\x22\xb3\xfc\x06\xb8\x43\xc5\x0b\x5f\x3a\x61\x74\x9c\xf8\xf3\x3f\xfd\x29\xe3\x05\xd3\xa2\x90\x1a\xd8\x86\xfe\xfc\x4f\x7f\xba\xcc\x54\xa8\x29\xb0\x5f\x12\x48\xb0\x5f\x48\x68\x44\xf7\x54\x1d\x0d\xba\xce\xaa\x52\x57\x59\x8a\x38\x16\x5e\x87\x90\xc4\x9d\x97\x2a\x8e\x42\x53\x72\xdb\x09\x10\x92\x18\x8a\xec\x2f\x3b\xfa\x81\xc8\xdc\x44\x2d\x34\x60\x08\x3b\xf2\x18\x14\x70\xb1\x7f\xc1\x21\x66\x28\x3d\xf2\x08\x0d\xa4\x13\xb9\xc0\xfb\xdf\x91\x09\x55\x1f\xac\xd5\x5b\xfb\xe5\xce\xe1\x48\x7c\x91\x53\x38\xec\x2f\x76\x06\xc7\xe1\x0b\x9d\x20\x3c\x95\x71\x19\x77\xdd\x68\x87\x20\x93\xb0\x3f\x02\x31\x20\xee\x03\x1e\x9e\x7f\x88\x03\xca\x5e\x78\xde\xb9\x28\x00\xf0\xa5\xad\xdf\x6a\xf5\xbe\xeb\xcd\x11\x49\x51\xac\x29\xf9\x87\xd0\x59\x23\xb4\xbb\x1b\x53\xd5\xe6\x18\x7c\xae\x75\x99\x69\xa5\xf3\xf0\x8f\xe3\x6a\xa5\xaa\xfe\x6d\xde\x63\x02\x81\x67\x79\x81\x31\x6d\x22\xee\xde\x63\x2b\xa5\xb1\xb3\x21\x76\xd4\x25\x29\x5c\xdb\x8a\xd7\xfe\x0c\xc7\xb8\x86\xe4\x22\xcd\xc5\x34\x22\xb7\x1a\x37\x8b\x9f\xe8\xed\x9d\x51\x0a\x9e\xce\xf1\x0c\xb2\x46\xab\xef\x1f\x7e\x8f\x9c\x62\xbf\x94\x92\x54\x7f\xfb\xe8\x01\x2d\xf0\x4e\xe6\x31\xad\x79\x4d\x0f\xff\x4c\x33\xe1\xa0\x7d\xa2\x0d\xa7\x5f\xc7\xf1\xeb\x0f\x42\x1c\x31\x8c\xea\xfa\xcf\xb6\x67\x5f\xfb\x87\x7c\x7f\xa0\xea\xef\x0f\x5f\x1c\xf2\x8d\x49\x98\x9f\x38\x05\x9f\x1c\xdd\xa9\x6b\xba\x77\x4f\x45\x75\x15\x45\xa6\xba\xf0\xc5\x4c\x1b\x7c\x48\xc0\x89\x5f\x16\xe2\xc9\x6d\xc1\x95\x15\x06\xc3\x2d\x2d\x34\x87\xf9\x74\x4d\x83\x2c\xde\xf0\x57\x61\x3f\x98\x95\xc7\x2b\x17\x0d\xbf\x09\xdc\xb0\x24\x57\x55\xd5\xd6\xd2\x7e\xb0\x5b\x2b\x0b\x51\xca\xfa\x78\x2b\x17\x8f\x78\x17\x65\xc3\xb4\x30\xaa\xd5\xf9\xd9\x58\xbc\x78\x08\x6d\xa5\x39\x1c\xe4\xe1\x61\xfc\xd9\xd6\xce\x79\x8f\x70\xfc\xc1\xd6\x4e\x0a\x09\x04\x1b\x2e\x7b\x38\x8a\x71\xb2\x47\x85\x5c\x69\xec\x31\xd1\x0f\x99\x59\x21\x4c\xe3\xae\x2c\x0e\xd9\x74\x94\xc4\xd9\x75\x02\x84\xd9\x76\x82\xa5\xb0\xef\x84\x5e\xf2\xb6\x0e\xbd\x0a\x38\x61\x0f\xd2\xc9\x9f\xed\xae\x5e\x6e\x94\x91\xa1\xc9\xaf\xbb\x73\x79\x10\x4c\x1b\x25\x77\x45\x9c\xdb\x0a\x2b\x51\xc8\xc3\x25\x6c\x3c\x84\xab\xed\x87\xd0\x1f\xfe\x2e\xed\x43\x30\xd7\xa3\xfa\x89\x7a\xc9\x46\xc5\xc3\x75\x4f\x40\x40\x1b\x36\xf2\x98\x11\x79\xab\x0f\x19\xfc\xd7\x46\xbe\xbc\xfc\x77\x3f\x5c\xb9\x08\x53\x3e\x3f\x5b\x1d\xc6\xbd\xb6\xb7\xfe\xe9\xa8\xc3\x4a\x9c\x89\xa1\xd3\x57\x67\x65\x85\x2e\xe1\x98\xc3\x62\xae\xdf\x98\x43\x06\xd2\x85\xe7\x90\x28\x97\xb2\xfc\x3b\x73\xd7\xac\x3f\xa4\x78\x0f\x7d\xe8\x42\x18\xf5\xa9\xb9\xaa\x2d\x3f\x0e\x72\x54\x56\xbd\x71\xe6\x1e\x58\x67\xaf\x3a\xb4\x73\x5c\xf3\xf2\xc3\xca\xdc\x5c\x96\x3a\x69\x3e\xeb\xdb\x59\xe0\x01\x1b\x77\x03\x28\xf2\x1e\xd0\x11\xa8\xcf\x04\x0b\x9c\xff\x3b\x09\x32\xfb\x03\x2f\x0f\x37\x9c\x68\x71\x3f\x1b\x2c\x6b\xcc\x5f\x3e\x17\xf0\xfb\xf5\xbf\x7c\x2e\xe0\xe7\x56\xa0\xe6\x75\xa1\xaa\xcf\xc3\x0b\x1f\x7f\x39\x03\xef\x93\x8d\xea\x4f\x9d\x85\x32\x64\x28\x30\x3f\x2c\x68\x97\x99\x02\x6a\x7e\xad\xf1\xe9\x15\x68\xac\x3a\x1e\xd6\x38\x01\xe4\xf4\xfa\x43\x70\xfd\x73\xf6\xd2\xfd\xf5\xfb\xc3\xfe\xd6\x5d\x91\xc3\xb4\xb0\x5a\xb9\xa5\x12\xf9\xc0\x42\x37\x6e\x02\x1c\x1c\xa6\xf6\xb3\x64\xe4\x1e\x79\x93\xbd\xd4\x01\x5f\x3c\x1c\x14\x03\x86\x4c\x90\xcb\xee\x02\x7e\x11\x81\x92\xbd\x56\xa5\xf8\xf3\xe1\xa8\x65\x10\xbd\x38\x51\x12\x3c\xe6\xf7\xfb\x22\x60\x7b\x0d\x2c\xfa\x4d\x58\xe6\x13\x44\xd8\x9b\x38\x1c\xc7\x4c\xf8\x4b\x1d\x2c\x03\x2d\x4c\x02\x87\xb5\x16\x96\x45\x57\xda\x6b\x6b\x5b\x2d\x82\x59\xa8\x13\x89\x95\x12\x45\x5d\xb8\xa3\xc4\xf0\x6a\x70\xe2\x58\xdc\x82\x9b\xfb\x55\x71\x7d\x7c\x7a\x70\x92\xba\xe0\x66\x98\x7b\xc0\xa0\x9e\x26\x5e\x93\x8c\x56\xf6\x12\x5a\xeb\x4e\xd5\x47\x52\xfc\xaa\x1a\x0b\x1b\xe4\x04\x74\x63\x03\x2f\xa7\x3b\x01\x64\xf7\xb9\x82\xeb\x5a\x65\x18\xb2\xfb\x33\xed\xeb\xfc\x63\x6e\x77\x6e\x59\x25\xea\x96\xf9\xcd\xa5\x23\x40\xff\x8e\xdb\x4a\x01\x81\x0d\x8b\xbc\x0e\x15\x1b\x6e\x1d\x9e\xe6\xb2\x34\x80\xf7\x55\x1d\xe2\x5c\x18\x67\x5f\xb7\xa5\xd6\xa8\x46\xb5\x87\xd5\x39\x58\x77\x26\x9e\x88\xab\x6e\x01\xa8\xd6\x08\x7d\xf1\x62\xe9\x6b\x58\x61\x98\x21\xed\xe2\x00\x0a\x36\x6c\x0e\x9e\xc4\xf4\x12\x07\xc7\x30\xc1\x8b\x46\x7d\xce\x86\xd0\x5a\x69\xc0\x1b\xf4\xbd\xd6\x65\xab\x95\xc6\xc2\x08\x6b\x65\x7d\x33\x3f\x67\x2f\x46\xb8\xf4\x96\xc3\x31\xbc\xab\x48\xd4\xdd\xb7\x23\x60\x08\xe5\xe0\xc6\x02\xd8\x46\x4b\x0f\x94\xd9\x56\x5f\x55\x96\xab\xf2\xf8\x56\xab\x5f\x3b\xb1\x7f\x9d\x90\x99\xd3\xd8\xc5\x87\x6c\x79\xaf\xe0\x83\x97\xd3\x6d\xe0\x9f\x5f\x49\x97\x00\x2f\x2a\x65\x05\x33\xc2\x86\x96\x62\x27\x1a\xbc\x28\xd8\xa8\x46\xcb\xe3\xa6\x55\xdb\x64\x2f\xee\x2f\x16\x9a\x53\x4d\x8c\x66\xd7\xe1\xf5\x65\xec\xd1\x82\x6e\xf0\x0f\x91\x6f\x5c\x27\x1d\xf2\xbb\x0e\x9b\xdf\x5a\x09\x9b\xea\xd5\xcd\x82\x03\xbd\xa0\x31\xea\xd2\xfd\x32\xb9\xc9\x41\x41\x06\x39\xc4\xe6\x9b\xab\xe4\x86\x7f\x17\x81\x49\x6c\x58\x32\x76\xe5\xbf\x2b\x0f\xd4\x37\x38\x49\x1c\x4e\xf6\xe2\xb6\xa0\xda\xda\xb2\x5c\x15\x87\x76\x05\x2b\x44\xf2\x90\xf5\x55\x7d\x07\x7d\xaf\x93\x4c\xc6\x51\xad\x85\x02\x79\x51\xc4\x8e\xa3\x31\xfc\x26\x4c\xf8\xd3\x7a\xc9\x0b\x2a\xc9\x6b\x84\x0b\x7f\x21\x31\x9e\xbd\x1f\x5f\xf3\x47\x09\x97\x99\xbb\x7a\x0f\xc5\xfc\x01\x10\xb9\x61\xec\x01\x3b\xd6\x9f\xf6\x75\xb9\xaa\x1a\x75\x9c\x90\x32\xe0\x61\x36\xdd\x12\xe0\xb0\x1b\xb6\x03\xe4\x95\xdb\xe3\x91\xe8\x00\xe8\x04\xf1\x78\x85\x28\x85\x15\x50\x8f\xf1\xd2\x69\x5d\xdf\xf8\x85\xa5\xca\xdf\xa0\x80\x4e\x38\x79\x30\x32\x40\xb6\x75\x14\x68\x2f\x8e\x19\x6c\xb8\x64\xbc\x4c\x8b\xbf\xb7\xc2\xd8\x70\xea\xb2\x13\xbf\x2c\xc4\xd3\x8c\xec\x71\xa1\x19\xd3\x1e\x36\x74\x79\x3c\x14\xd5\x76\xdc\xfb\x6f\x08\xa3\xce\xa5\x51\xdf\x0a\x39\xd1\xad\xc2\x07\xb9\x23\xd2\x47\x8a\xd9\xe2\xec\x70\xa5\xaa\x11\xf5\x71\xf2\xea\xae\xf2\xc5\x2b\xa6\x37\xe3\xfd\x62\x13\x88\x20\xcf\x8a\x52\xd1\x40\x5f\xdb\xb6\x5f\x47\xa1\x77\x68\xf6\xc9\xa0\x1e\xa3\x79\xee\x2c\xc1\xc7\x67\xf6\xd9\xe0\x5e\xa0\x79\x4a\x27\x81\x09\x2e\xab\x94\x92\x09\xf6\x96\x43\x4a\x2e\x04\x2f\x01\xbc\xb8\xcb\x2e\xf0\x03\x62\x30\x12\x7e\x2c\x0c\x86\xe2\x45\x25\xeb\xa0\xef\xe7\x43\xc6\xdd\x13\x67\x8f\x84\x0b\x2f\x39\x0f\x80\x98\xb5\x66\x9f\x4d\xd8\xdf\xa8\x1e\xda\x62\xcb\x4b\xc1\x6b\x2f\x7b\x99\x34\x30\xcb\x5e\x13\x78\x14\x2e\x1a\xd2\xc8\x5b\xdd\x1e\x6e\xc6\x7b\x4c\x2f\x77\xf1\x7f\xa1\x51\x5f\x79\x2e\xae\x4a\xbd\x65\x80\x4c\x63\x8f\x3f\x68\x5c\xf0\xb9\xdc\x9e\x42\xc3\x8d\x79\x57\xda\x77\xfb\x00\x02\x83\xbc\xdf\xd9\xa5\x83\xef\x7c\xf7\x78\x91\x71\x85\xef\x15\xd2\x09\x74\x05\x35\x4a\xdb\xb0\xb7\x0d\x92\xcf\x5d\x0d\x96\x82\x31\x00\x86\x7d\x6d\x44\x7c\xee\x67\x71\x90\x90\x94\xfd\x11\x14\x9d\xb5\x3f\xc2\x86\x1e\x05\x58\x08\xa2\xc7\x4b\x8b\xd2\x42\x1d\xdf\x12\x1a\x35\x0a\x40\xe0\x22\xfb\xfc\xb1\xb0\x31\x90\x80\x2d\x3e\x06\x92\x4e\x03\xff\xe9\x31\x91\x6c\xcb\xa1\x57\x62\xc8\x84\x2a\x52\x32\x88\x85\xe4\xe1\xcc\x75\x68\x80\xd0\x09\x22\xc7\xc2\x90\xb7\xf4\x3c\x0c\xd2\xd5\xc6\x8f\xf2\x17\x58\x33\x59\xf1\x9b\xdb\x5d\x09\x6e\x88\x0d\xf0\x3b\x6a\x69\x43\x94\x91\x0a\x2f\x0a\x26\xad\xe8\xfe\xc7\x8a\x8a\x85\x0e\x62\x78\x22\x83\x12\x12\xbb\xdf\xcf\x59\xc1\xf7\xff\x84\xd4\xc7\xac\x00\x24\x95\x43\x22\xd9\x4b\x21\x0f\x23\x82\x67\x43\xc2\xa5\x72\x89\x7d\x26\x9c\xff\xd1\x89\xb3\x40\x12\x08\x14\xd4\xfd\xe9\x53\x40\xba\x28\x0e\x84\x4d\xcf\x73\x9c\xa1\x8e\x1b\x69\x40\x50\x2d\x1e\xa2\x6e\x13\x07\xe6\xf0\x96\x8e\xea\xcc\xdc\x61\x8b\x4f\xc0\xf1\xd5\xe6\xb3\x6a\x4b\xf9\x10\xc3\x75\x11\x90\x04\xb3\x1e\x7e\xa3\x8c\xfc\xe8\x1f\x85\xcd\xd8\xb0\x5d\x61\xbe\x51\xb1\xd0\xd6\x84\x67\xb1\xd6\xc0\xbb\xc1\x57\x92\x18\xba\x64\x66\xee\xdc\x9d\x8a\x1c\xc6\x09\x85\xe4\xa5\x3a\xcc\xc2\x5d\xab\x5e\x96\xaa\xe9\x9d\xfb\x79\x9c\x18\x6a\x9f\x7c\xc3\x2b\x74\x60\x76\xc3\x06\x75\x6e\x76\x17\x9e\x41\xa6\x1d\xbb\x3c\x18\x7a\x0e\xf2\xac\x9e\x52\x2a\x88\xde\x81\x93\x0c\xb3\x56\xa6\xa3\x55\x48\xc3\xaf\xc7\xf9\xcc\x1b\x36\xbd\x0e\x61\x4b\xf2\x69\x7c\x2c\x2f\x03\xdb\x94\x1b\x2a\x73\xc5\x64\xa3\x7c\xa8\xd6\xb6\x57\x01\x6e\x3f\x2b\xf9\xa7\xcd\x27\x0d\x19\xe4\x21\x7b\x14\x0e\xbd\x23\x9e\x0b\xec\x14\xfc\x9a\x08\xc9\x59\xf8\x77\xd9\xfd\x0f\xb8\x3e\x56\xf2\x88\xfa\xd8\x43\x06\xd5\xc7\x1e\x05\x64\x7d\xac\xb9\x00\x6f\x25\x58\x11\x21\xb9\x23\xad\xb5\xf7\xec\x5a\x0b\xd8\x62\xd2\x95\x5b\x5b\x8a\x5a\x58\xe2\xb0\x3e\xb1\x78\xe5\xb2\x0c\x9c\x7b\x7f\x42\xa2\xd7\x4c\xe6\xb0\x29\x16\xee\x21\x67\x99\x65\x4b\x09\xe6\x28\x5b\x3e\x14\xae\x52\x54\x39\x0f\x2f\xab\x76\x52\xe3\xae\x01\x66\xdd\x27\x16\x0e\xf9\x61\x96\xbf\x89\x42\xbd\x87\xc1\x06\x41\x8a\xcf\x8b\x06\xc5\xd7\x5e\x20\x5f\x7d\xb0\x27\x26\x57\xdd\x41\x19\x51\x87\x81\x3a\x21\x1c\xcc\xb0\x71\xc0\x82\x1b\x1d\x3b\xe2\xf8\xcd\xfc\x9d\x42\x43\x3b\xf9\xbb\x3c\x30\xfb\xf8\x7b\x1c\x42\x6b\x94\xbb\x24\x50\x4b\x96\x14\xb5\x41\xb0\x98\xc9\x64\xfd\x90\xd6\xdd\xa6\xe8\x72\x8c\x1a\xd0\xaa\xc7\x4c\xeb\xe2\xb5\x66\x3f\x41\xcd\xf8\xe7\x7c\x0a\x91\x97\xb2\x0e\x66\xb2\xad\x09\xf5\x6a\x64\x8c\xa6\xbb\x2c\xfd\x53\xf5\xc2\xb2\x7e\x09\x2b\x7b\x79\xf0\xb2\x0d\xae\xb6\xce\x4a\xb8\xcc\xb4\x67\x3f\x4e\x5f\x0b\xdb\x63\xe7\x97\x01\xd3\xb8\x39\xdd\xd3\x98\x35\x5a\x56\x5c\x7f\xb0\xee\xf7\xb1\xcc\xe6\xba\x74\xac\xfa\xf5\xe7\x7e\xcd\xf6\x2e\x0f\x37\x24\xd7\xb4\x36\xca\x98\x5d\x3b\x6d\x6b\xa1\x41\xbb\xa2\x73\x49\x7c\x48\x5e\x96\x17\x8a\xc6\x6b\x74\x4c\x20\x5e\x21\x87\x62\xf0\x1a\x1a\x15\x7e\xd3\xed\x8d\xdc\x24\x4d\x85\x45\xef\x91\xa6\x02\x13\x24\x41\x0d\x45\xfa\x37\xbf\x20\xe0\xfd\xeb\x60\x64\xce\xed\xcb\x83\x3a\xf7\x80\x4e\xe1\xdc\x3d\x32\xd4\xb9\x07\x68\x12\xe7\x8e\xb7\x37\x89\x73\xc7\xc3\x12\x39\x77\x3c\x30\x81\x73\xbb\x74\x87\xf0\xa9\xcf\xd6\x1f\x7f\xc3\x3d\x5b\xe3\xb0\x8c\xa8\x0b\xf6\x10\x5a\xbe\xca\x3c\x78\x4d\xbf\xcf\xeb\x58\x6b\x20\x19\x04\x67\x99\xf3\x53\xbc\x88\x5c\x21\xff\xb9\xc1\x88\x35\xa2\x21\xf3\x84\x60\xdf\x36\x1c\x84\xc6\xcc\xa0\x81\x1f\xe6\x2b\x0f\x99\x64\xe7\xb0\xfc\x29\x0f\xd6\x3f\x44\x17\xc4\x5c\x8a\xe3\xb6\x64\xf0\xf8\xc8\x6f\x1f\xbe\xc2\x17\x7a\x38\x95\x70\xe0\x2b\x79\xdc\x87\xfb\x9b\x5f\x86\x89\x1b\x20\x40\xcc\xc5\x29\xa1\x5d\x25\x46\xe2\x13\x54\xfc\x89\x24\x22\x5c\x20\xb2\x16\x5c\xbc\x5c\x4e\xb6\x99\xa8\xb8\xdc\xbf\x3c\x3f\xa2\x15\xfa\xcd\x22\x78\x33\x58\xca\xe3\x6a\xc2\x67\x8a\xc2\x8d\xb0\x92\xc7\xba\x01\x2f\xcb\x0f\x16\x6b\x80\x7d\x35\xaa\x78\xe0\x4b\x8d\x08\x08\xbd\x02\xce\x14\xbc\xb5\x8a\xf5\x79\x60\x8d\x56\xaf\xb2\x14\xac\x91\xb9\x0d\xac\xe2\x7b\x26\xcf\x75\xd3\xa6\xc4\xbe\xcb\x13\x37\x7e\x98\xdb\xe1\xbb\xbc\x4e\x0a\x81\x52\x54\xf9\xe1\x6d\xc4\xde\xe3\xab\x7c\xf7\x15\xbd\x98\xce\x9b\x35\xaa\x69\x1b\x66\xaa\xc0\x4d\x87\x53\x47\x3e\xd7\x40\xa0\x8f\xcb\x01\x00\xbf\xee\x25\x11\x68\x7e\x5c\xe0\xa9\x03\x07\x11\x5e\x18\x81\xf9\xaa\xf4\x4d\x59\xd6\xfd\xbb\x0e\xdc\xf9\xe0\x60\x57\xf2\x34\x35\x1b\x53\xa7\x08\xc4\xe1\xe1\x0c\x68\xbc\x5c\xc9\x23\x90\xdd\x48\xfd\xc3\xf7\x38\x41\xd8\xb9\x30\x02\xb3\xb9\xab\x5a\xb0\xba\xad\xae\x23\x81\x10\xf4\x42\xc7\xf4\x44\x90\xb1\x79\x5e\x64\x24\x3e\x6a\xea\x8a\x05\x47\x4e\x60\x5d\x89\xee\xb4\x2e\xd4\xf6\x4e\x98\xc8\xe8\x1e\xd8\x54\xc1\x0b\x7d\x06\x54\xb3\xff\x52\x7d\x34\xa4\x16\x37\x69\x2c\xc0\xd8\x3d\xee\x20\x4f\x01\x0e\xfe\x56\xb4\x5b\xd9\x77\xc5\x5e\x79\x6e\x95\x8e\xf8\xe0\x51\x67\xfc\x68\x82\xc1\x38\x11\x13\xac\xf9\x27\x16\xa2\x0e\x25\x5c\xad\x39\x78\x0d\x5a\x5b\xa4\xb2\xa0\xb6\x43\xb0\x8f\xd9\x52\x40\x8e\x45\x67\x14\x00\xc9\x6f\x6b\x0a\xc3\xb0\x9c\xb4\x32\xd2\x79\xd0\x55\x07\x74\x66\xb0\x43\x82\xae\x42\xdc\x24\x14\x18\xaa\x26\x1a\x93\x56\xba\x39\x22\x96\xc0\x90\x49\x1d\x51\x4b\x60\xd8\x04\x12\xc8\x25\xa4\xe3\x52\xe2\x28\x9d\x8c\x57\xf1\x9a\xdf\xc2\x01\xf6\xd2\xcb\x11\x5c\x6e\xed\x27\x84\x41\xc0\x61\xe2\x88\x06\x0c\xdf\x60\x4f\x8b\x07\x7a\x4d\x62\xac\xc1\x51\x1a\x8f\xc7\x8c\xd0\x0f\x99\x8b\x2d\xda\x91\x4c\xcc\x18\xfc\xc6\xab\x2e\x8e\x6e\x18\x8f\x38\xcf\x04\x62\x07\xfa\xcc\xdd\x83\xb3\x8f\xf1\xe4\xf7\xb1\x10\xe6\x49\xd1\x89\xe7\xdc\xf2\xd6\x58\x55\xb1\x86\xd7\xa2\xdc\x2b\xfa\xc9\xef\x63\x20\xfe\xde\xd6\x72\xe7\x35\xd4\xf5\xcf\xa3\x58\xdf\xb9\x0d\xbf\xbc\xe7\xde\x5a\x75\x52\x69\x28\x04\x2f\x1e\xc0\x41\xb2\xf0\x7d\xb4\xc3\xd5\x0b\xcf\xaf\xa2\x05\x35\xbc\x11\x11\xf4\x74\xa1\x7e\x6e\xc1\x38\xb4\xae\x36\xc2\x60\x9d\x14\x1e\xcb\xbf\x33\x1f\x46\xf3\x72\x78\xbc\xc0\xce\xf7\x18\x35\x31\x5b\xde\x23\x98\x2a\x61\x9d\xac\x2a\x09\x6a\x2d\xb4\xb3\x3e\xa2\x21\x2e\x20\x19\xb0\xe0\x97\x8f\x0c\xb7\x8c\x56\xc2\x72\xf6\x0c\x19\x36\x1c\x9b\xda\x5f\xb8\x83\xa7\x78\x71\x64\x8d\x97\x35\xdc\xd8\xff\x36\xdc\x33\x7e\xd8\xdf\x8f\xb6\x5e\xaa\xd0\x52\x61\x57\x10\x97\x53\x4c\x71\x97\xb7\xbb\x7b\x0c\xf6\xf3\xa1\x3f\xed\x2d\xad\x27\xc8\x42\x7f\xde\x37\xc7\x3e\x18\x80\x5c\x7e\x3b\x03\x37\xae\x69\xc7\x02\xa7\x1f\xdc\xde\x42\xba\x37\x6f\x85\xce\xe5\xf1\x26\xd0\x0c\x7d\x52\xa0\xfc\xf4\xac\x10\x25\x3f\x5c\xf9\x9c\x51\x70\xb2\xa4\xe8\x6e\x05\x3d\xbc\xc3\x30\xe3\x30\xd3\x20\x74\xf9\x9e\x48\xff\xc8\xd4\x35\xd0\xec\x36\x74\x66\x7a\xa4\xe6\xf1\x17\x6b\xb3\xc0\xe1\xde\x19\x9d\x49\x81\xd2\x38\x53\xa9\x59\x5b\x17\x6a\xb8\xf0\x3b\x70\xd7\xc4\xbc\xc9\xd6\x85\x62\x5e\x89\x92\x57\xf0\xb2\x87\x79\xe3\xed\x64\x29\xc1\xa7\x94\xe4\xe3\x27\x65\x27\x31\xe4\xe5\x90\x34\x1c\xb0\xc9\x9d\x34\x2c\x28\x2e\xf9\xdb\x21\xe2\x13\x0d\x43\x19\xe5\x33\xaf\x98\x69\x90\x3a\xe6\xec\xb1\xba\xcf\xef\xbf\x17\xf0\x59\xc3\x3f\x2a\x51\x7f\xe2\xd8\xe9\x09\x8f\xcf\x78\x03\x31\xc4\x61\x7c\xb6\xfa\x0b\x88\x34\x5a\x15\xed\xf1\x91\xc8\xb9\x63\x7a\x69\xda\x68\xa9\x05\xaf\x02\x8f\xf8\x2c\x22\x66\x2f\x7f\x0a\x09\x56\xa9\x02\x3c\xf6\x59\x69\x51\x12\xb2\xf2\x1f\x81\x24\xac\xfc\x47\x4a\x60\x77\x55\x49\xa1\x2c\xff\x85\xdd\x78\x25\xa0\xfd\xd8\x5a\x8d\xb4\x72\xf8\x43\xb0\x8a\xdb\xfc\xce\x0a\x6e\x0f\x13\x87\xe6\x95\xc3\x47\x46\x93\x2e\x69\x07\x93\xb7\x5a\x8b\xda\x6e\x40\xa0\x23\xe7\x27\xea\x04\x0b\x4a\xe1\xed\x06\x90\x70\xd2\x5c\xa2\x2f\xef\xcb\xa6\xe7\x4f\xf0\x33\xf1\xbd\x91\x9f\x1a\x63\x07\x22\x5f\xb0\x4e\xb0\x81\x3e\x76\x86\x53\xb0\x5f\xfc\x9b\x56\xb2\x98\x58\x7c\x1a\x87\xf0\x6e\xd4\xb8\x3a\xe5\x45\xf1\x90\xaf\xe5\xe3\xf8\x46\x74\x9d\xdf\xe5\x43\x5c\x1a\x2d\x1f\xa8\x2b\xa0\xa6\x8f\x0c\x1d\x86\x25\x35\xe9\x15\x89\x16\x0b\x05\xf3\x9a\xb1\x1a\x47\x69\xa2\x2f\xf5\x0f\x1b\x86\xa2\x79\x5f\xa9\x4e\xee\x32\x6a\x50\x51\x78\x48\xf1\x2e\x74\x1c\x89\x99\x0e\x15\x0d\x7f\xf6\x01\xe2\xdb\xcf\xdf\x0f\x39\x1b\xf7\xe9\xb4\x2d\xb2\x73\xbf\xc2\xae\xf0\xef\x71\x89\xd6\xf2\x3d\xa8\x1b\xaf\xbc\x2a\x2d\x1e\xc7\xc1\x7a\x00\x9f\xcb\x13\x90\xc8\x3f\xaf\x7d\xe7\xc0\xea\xcd\xef\xbc\xb1\xe3\x09\x20\x82\x3d\xbd\x68\x5c\x2a\xb7\xca\x41\x6e\x35\xe0\x12\xb9\x95\x16\x25\x0f\x9c\x71\x1a\x76\xa8\x7a\x51\xd6\xff\x3f\x41\x77\x58\xf1\xd0\x21\x86\x01\xdb\x4b\xe2\x11\xfd\x79\xca\xe0\xa9\xa2\xe9\x93\x47\x71\xa4\x3b\x7f\xfa\x9b\x9b\x5b\x64\x58\x3e\x3a\x81\x4f\xdd\xcb\xf0\xcb\xb7\xf7\xd4\xd4\x8b\xe9\xbb\x86\x75\xeb\xec\xa5\x5f\x70\x08\xdd\x1f\x2c\xf3\x37\x81\x3d\xb2\xbc\x85\x07\xf8\x11\x9b\x2f\xe4\x5c\x78\x9d\xbe\x2a\x31\xc6\x0a\x58\x5a\x45\x9e\xfa\xbc\x6f\x6f\x51\x33\xb7\x6d\x36\xbc\x67\x18\x7c\x1d\x65\x14\x44\x1e\x0f\xdf\x23\xe1\x6b\x31\x93\xb5\xb4\x92\xdb\xae\xf2\xfd\x1a\x21\x6b\xb4\xea\x86\xe9\xc7\x97\x36\xf7\x2e\x30\x68\x9f\x42\x2d\x57\x55\xe3\x1f\x54\x4b\xa1\x36\x68\xff\x27\xa3\x06\xbc\x5d\xe1\x80\x5b\x20\xe1\x64\x20\x81\xba\x62\xe1\x00\x3e\x78\xe9\x7c\x8f\x8f\xbb\x67\xe1\x39\x81\xd3\x23\x17\x12\x1b\x7b\xe3\xc2\x88\x1e\x78\xe7\xa1\x97\x43\x3e\x30\xe5\x87\xbf\xd3\xf4\x10\x74\xcb\xe0\x30\x68\xde\x6a\xa5\x05\xd1\x81\x45\x3f\x44\x44\x4e\x52\xe0\x78\xfd\x79\xcf\xf0\x1b\xf4\x03\xea\x42\x01\xfb\xad\xa5\x70\xfb\xab\xef\x5c\xd7\xb2\xbe\x45\x19\xfe\xa9\x32\x85\x3d\xe0\x86\x20\xb1\x7e\xa3\x55\x2e\x8c\x39\x1e\x5a\xaf\x2a\x60\xd4\x49\x63\xd0\x0d\xac\xb2\xa6\xe4\x1f\xd3\x28\xe5\x65\x5c\xdb\x74\x6f\x1a\x4c\xff\xd7\xf0\xe3\xdb\x47\xdc\x20\xad\x79\x92\x32\x01\xc9\x65\x97\x65\x7e\x97\x55\x03\xba\xf5\x74\x94\x3e\x7c\x43\x07\x90\x7f\xdd\x6b\x67\x95\xb0\x7c\x34\xc2\x1f\xbf\x57\x87\x7b\x35\xee\x53\x3b\x8d\x74\xab\xe7\x77\x91\xbf\x81\x92\x6b\x1d\xd8\xa8\x92\xe8\x69\xad\xbd\x67\x65\xc1\x61\xc6\x75\xaf\xa0\xbd\xbc\x74\x4a\xa2\xb6\xfd\x7d\x2e\x87\x86\x8e\xb8\xd8\x16\x70\x9b\xec\x3e\x3e\xf6\x32\x59\xff\xb6\xdb\xb2\xd0\xcc\xd8\x80\x57\xef\x73\x71\x6a\x48\x26\x2e\x3d\xe2\x70\x2f\x25\x20\x17\x8b\x9a\x5b\xf9\x10\xcc\x15\xfa\xb3\xdb\x9f\x3e\x9c\x4f\x42\xe5\x93\xbe\xfd\x37\x75\x3d\xee\x66\x46\x29\xec\x13\xa3\x63\x41\xc1\xf7\x19\x27\x48\xdc\x40\x22\x05\x11\xfb\x22\xa5\x2b\xe9\x56\xaa\x2b\x2f\xd9\xb5\x8b\x28\x05\x7b\x57\xba\x00\xd8\x78\x47\x89\xc4\xe4\x64\x64\xd0\x6f\xbb\x3e\x2b\x19\x56\x3d\x7b\x94\x08\xd2\x79\xfc\x32\x91\xc9\x84\x29\xdd\x4b\x26\x3a\x70\x0e\x9f\x17\x97\xb9\x28\xc3\xde\xf2\x35\xe0\x03\xb1\xc9\x71\xed\xf4\x88\x0b\x00\x7e\x25\x8d\x66\xc1\x8b\x4c\xbe\x6a\x5e\x09\x67\x7f\x2d\x72\xcb\xeb\xdb\x71\xd6\x7b\x5f\x01\xa3\x6c\x72\xf3\x28\x84\x79\xcb\xaa\xb6\xb4\xb2\xe1\xe6\x38\x0d\x42\x98\xb7\xcb\x28\x99\x0c\xa8\xb3\x32\x7b\xe9\x5f\x99\x69\xb4\x6a\x84\xb6\x52\x98\xec\xe5\x5e\xf1\xfc\x0f\x0d\x0f\xdc\xf5\xaf\xb9\x3b\xaa\x75\x29\x65\xfd\x76\x78\xbc\x0e\x42\xe4\xc5\x3f\x98\x35\x67\xe1\x0e\x84\x75\x03\xcd\x38\x3a\x4e\x0d\x47\x27\x08\x26\xb4\x56\xda\x5c\xee\xbc\x2e\x4a\xf1\x97\x3f\xfd\x25\x0d\xe6\x84\x83\x5f\x5d\x1b\x30\x99\xac\x5f\x55\x36\x99\xf2\xe8\x4b\x26\x85\xcb\xa4\x70\x80\xfd\xbb\x6f\xdf\xfe\xdf\xef\xfe\xe3\xff\x07\x00\x00\xff\xff\x9f\x42\x4d\x5d\x0d\xe8\x01\x00")

func dataRailsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataRailsJson,
		"data/rails.json",
	)
}

func dataRailsJson() (*asset, error) {
	bytes, err := dataRailsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/rails.json", size: 124941, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataSimilarChannelsJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\xcd\xc1\x6a\xc4\x20\x10\xc6\xf1\xbb\x4f\x31\x78\x4e\xe3\x3d\xf7\xd2\x17\xe8\xad\x94\x60\x75\x48\x2c\x71\x2c\xce\x18\x5a\x42\xde\xbd\xe8\xee\x1e\x96\xe4\xb2\xb0\x17\x0f\xc3\xdf\xef\xb7\x29\x00\xcd\xab\xd3\x03\x68\x97\x3c\xf6\xdf\x85\x25\x50\x2f\xab\xf1\x81\x5d\x5a\x31\xff\x19\x0e\x31\x2c\x36\xbf\xb8\xd9\x12\xe1\xc2\xc6\x45\x7f\x38\xea\xae\x4e\xe5\x54\x04\x59\x0f\xf0\xa1\x00\x00\xb6\xf6\x02\xe8\x1f\x2b\x82\x99\x2a\x63\x58\x32\xda\xc8\xb7\x05\x33\x14\xc6\x6c\xf0\x37\xb0\x5c\x56\xda\x0f\xb2\x11\x6b\x3e\x5b\x1e\xaf\xe5\x78\x67\xb5\x2a\xa2\xcc\xc9\xd7\xee\xed\xf5\x5d\xb7\xeb\xde\x3d\x48\x1f\xcd\x09\xe5\x79\xa6\xc7\xaf\x32\x99\x5c\x88\x02\x4d\xe7\x56\x4b\xc6\x43\x72\x06\x29\x80\x4f\xb5\xab\xff\x00\x00\x00\xff\xff\x5b\x56\x0d\x7f\xb8\x01\x00\x00")

func dataSimilarChannelsJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataSimilarChannelsJson,
		"data/similar-channels.json",
	)
}

func dataSimilarChannelsJson() (*asset, error) {
	bytes, err := dataSimilarChannelsJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/similar-channels.json", size: 440, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataSkadiJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xcc\x56\xcb\x6e\xdb\x30\x10\xbc\xeb\x2b\x08\x9d\x83\x10\xb9\xea\xdc\xa2\xc8\xa5\x0e\x90\xdc\x8a\x22\xa0\xc9\xb5\xcd\x86\x22\x05\x3e\x14\x34\x82\xfe\xbd\x90\x5a\xb4\xb5\x4d\xca\x5d\xd2\x76\x73\x31\x20\xef\xec\xcc\xce\x0e\x45\x68\xa8\x08\xa9\x5d\xcf\xeb\x86\xd4\xdc\x08\xb8\xfd\x16\x9c\x97\xfa\xd6\xf7\xd4\x82\x02\xe6\x80\xba\x17\x26\x64\x7d\x33\x01\xad\x09\x1e\x5c\xdd\x90\x2f\x15\x21\x84\x0c\xf3\x2f\x21\x75\xc7\xbc\x07\xab\x27\x12\xda\xdf\xd1\x57\x58\xef\x8c\x79\x99\x7b\xe6\xba\x66\x2d\x24\x8b\x2d\xf8\x9d\x11\x53\xf9\xd3\xc7\xa7\x7a\xfe\x77\xbc\x49\xf3\xdb\xa0\xb5\xd4\xdb\x08\xf9\x51\x05\xc9\xdc\xdf\xd1\x75\x90\x4a\xc4\xe7\x3e\x28\xe1\xb9\x39\xd3\x42\x0a\xe6\x81\xf2\x60\x2d\x68\x1f\xd7\x59\x80\xfd\x5f\xcd\xd5\xc3\xd3\xfd\xea\xf3\x23\x52\xb7\xb3\xd0\x4b\x13\xdc\x29\xe1\x63\x5c\x89\xdb\x73\xa8\x62\xfc\x0a\xe8\x94\xf9\xde\x82\xf6\x09\xc9\x28\xe0\x8f\xd6\xc3\xea\xf1\xdf\x2c\x96\x0a\x65\x9a\xa2\x8d\x14\xd4\x79\xe6\x53\x2b\xfd\x1b\x3b\xdc\x7f\x18\x8f\xc0\xf8\x34\x2f\x24\x7f\xcd\x58\x33\xac\x5e\x3d\x55\x65\x62\x77\x69\x6c\xa7\x7b\xc8\xf2\x3c\x8b\x85\x31\xae\x37\x16\xe0\x0d\x28\xb7\xc0\x3c\xc4\x65\x13\x90\x8c\x97\xf4\x1c\x62\x19\xe6\xb6\x90\xb8\xde\x63\x75\x7c\x7e\x65\x2a\x19\x7e\x04\x28\x38\xb1\xbf\x43\x48\x7e\x58\x45\x62\x19\xe6\x94\x74\xcb\x7b\xdc\x07\x20\xe3\x62\xc1\xef\x8c\x95\x6f\x31\x43\x91\x1a\x92\x7d\x2b\xfd\x2e\xac\x9f\xcd\xc4\xf4\xcc\x99\x52\x6b\xc6\x63\x5f\x7b\x27\x70\x48\x55\x6e\xf4\x46\xc6\xae\x8c\xc3\x02\xfe\x68\x5b\xe8\x8c\xa3\x8d\x79\xd5\x60\x69\x33\x11\x53\x07\xde\x4b\xbd\x4d\xdc\xc7\x3f\x1b\x86\xb9\x61\xa4\xc3\x54\x1a\x23\x2d\xef\x71\x12\xcc\x59\x5d\x98\x86\x0a\xd8\xb0\xa0\x12\x67\x78\x71\xaa\xe3\xd6\xb3\xee\xe9\x42\x93\xa1\xf7\xb6\xa0\x5f\xec\x1c\xc9\x9d\x9f\xf9\xf4\x44\xb9\x69\x3b\x66\x81\x36\xdc\xb4\xad\x4c\x7d\xa3\x1c\x6c\x76\x7a\x1c\x7f\xb7\x0e\xbf\x5a\xc7\xf3\x85\x7e\x95\xd1\x30\x9b\x0b\x0e\xec\x52\x3c\xb1\x3a\x7e\x09\x65\x2a\x58\x3f\x69\x8d\x52\x0f\x38\xe6\xfd\xb9\x2b\x42\xbe\x56\x63\xf5\x23\x00\x00\xff\xff\x09\xc4\x4e\x61\xbd\x10\x00\x00")

func dataSkadiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataSkadiJson,
		"data/skadi.json",
	)
}

func dataSkadiJson() (*asset, error) {
	bytes, err := dataSkadiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/skadi.json", size: 4285, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataStreamsApiJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x8d\xb1\x0e\x82\x30\x14\x45\xf7\x7e\xc5\xcd\x9b\x91\xee\xec\xc6\x1f\x70\x33\x0e\x15\x9e\x01\xa1\x2d\x69\x1f\x30\x10\xfe\xdd\xb4\xc6\x89\x68\x1c\x5c\x3a\xf4\x9e\x77\xce\xaa\x00\x8a\x73\x4d\x15\xa8\xf6\x0d\x97\x8f\x29\x4a\xe7\x4a\x99\xf5\xc2\x37\x1d\x25\xb0\xb1\xf1\x60\xc6\x8e\x8a\x84\x06\x3f\x09\x47\xaa\x70\x51\x00\xb0\xe6\x17\xa0\xd1\x88\x70\x70\x49\xa3\xfb\x60\x7a\x76\xef\x5b\x7d\xf7\xc3\xe0\x17\x6e\xb2\x20\xc3\xce\x58\x4e\xe4\x7e\xb1\x2c\xad\x6f\xd2\x76\x3a\x9e\x29\xff\x6e\xc5\xcf\xa5\xaa\x6e\x8d\x73\x3c\xec\x4b\x2f\xe2\x4f\x9d\x4f\xfa\xf8\xdd\xaf\x80\xab\xda\x9e\x01\x00\x00\xff\xff\xd3\x42\xaa\x24\x71\x01\x00\x00")

func dataStreamsApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataStreamsApiJson,
		"data/streams-api.json",
	)
}

func dataStreamsApiJson() (*asset, error) {
	bytes, err := dataStreamsApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/streams-api.json", size: 369, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiApiJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x90\x41\x6a\xc6\x20\x10\x85\xf7\x9e\x62\x70\x1d\xe2\x3e\x27\xe8\xa6\x27\x28\xa5\x4c\x75\x9a\xa4\xc4\x51\x74\x94\x42\xc8\xdd\x8b\x76\xd1\x85\x6d\xa1\x3f\xff\xc6\xc5\x7c\xcf\xef\xc1\x3b\x15\x80\xce\xd5\xea\x05\xb4\x0d\x8e\xe6\xf7\x92\x65\xe7\x59\xaa\xb1\x1b\x8a\x11\xbf\x1b\x8c\xbb\x9e\x5a\x2e\x85\x22\x94\xf5\x02\x4f\x0a\x00\xe0\xec\x2f\x80\x8e\x28\x42\x89\x9b\xc3\x38\x7a\x2d\xab\xa9\x98\x72\xff\xd3\x39\xa3\xa7\x06\xe9\x23\x56\x4c\xdf\x77\x4f\xb2\x05\xd7\x88\xee\xa7\x6b\xfa\xdd\x3b\xda\x38\xc8\x5b\x28\xec\x6e\xf3\xad\x29\x94\x68\x4a\xa6\x64\x16\xbb\x21\x33\x1d\x63\x45\x0f\xdd\xcd\xdf\x17\x15\xfa\x69\x99\x9e\x7e\x19\xf9\x7f\x1a\x3d\xe5\x8c\x2b\x8d\xf2\xc7\x2f\xf0\x80\xec\x0e\xfa\x6b\x7e\x05\xf0\xac\x2e\xf5\x19\x00\x00\xff\xff\x55\x31\x1b\x6c\x14\x02\x00\x00")

func dataTmiApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiApiJson,
		"data/tmi-api.json",
	)
}

func dataTmiApiJson() (*asset, error) {
	bytes, err := dataTmiApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-api.json", size: 532, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiClueJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x56\xcd\x6e\xdb\x3c\x10\x3c\x53\x4f\x11\xe8\x1c\x84\x77\xdd\x3e\x7c\x35\xda\x43\x81\x06\x68\x7a\x2a\x0a\x81\x26\xb7\x16\x53\x89\x24\xb8\x2b\x1b\x41\x90\x77\x2f\x28\x0b\x72\x4c\x53\x12\x63\xf7\x24\x81\x43\xcd\xec\xcf\x90\xda\xd7\x82\x95\xb8\x97\x65\x75\x57\x4a\xab\xe0\xe1\xb9\x47\xd2\xe6\x81\xf6\x5c\x36\x82\x38\x75\x9a\xcb\xb6\x87\xf2\xbe\x60\xa5\xb7\x3d\x01\x96\xd5\xdd\xcf\x82\xb1\xd7\x82\x31\x56\x3a\x41\x04\xde\x84\xcf\xb9\x82\x6d\xbf\xe3\xbe\x37\x46\x9b\x5d\xf8\x80\xb1\xd2\x88\x0e\x02\xd8\x80\x68\xa9\x91\x0d\xc8\x3f\x23\xd2\x01\x35\x56\x05\xec\xf3\xe6\xa9\x2c\x18\x7b\xbb\x4f\xb2\x8a\x9e\x1a\x30\xa4\xa5\x20\x88\x48\x13\xd0\x89\xf5\xf1\xdb\xf7\x25\x5a\x69\x8d\xa9\x45\xdb\xda\x03\xa8\x88\x36\x01\x65\xd3\x3e\x5b\x6d\x6a\x07\xbe\xd3\x88\xda\x9a\x88\x39\x8d\x66\x93\xa3\x03\xa9\x45\x5b\xf7\x08\xbe\x6e\x35\x52\x44\x3f\xe2\x01\xc6\x8f\x72\x3b\xaf\xf7\x1d\xc6\x6d\x3b\x5f\xcd\x26\xdb\xb5\x76\x2b\x5a\xbe\x15\xc6\x80\xaa\x0f\xd6\x2b\x8c\x88\x77\x40\xf5\x71\x57\x9d\xd8\x95\xeb\x8d\x84\x0e\xaf\xc2\x23\x36\x8a\x52\x09\xb5\xcb\xac\x7e\xfc\x0b\x31\x05\x2d\x10\xe4\xe8\x7d\xda\x7c\xdd\x3c\x6d\x16\x24\xbd\xb5\x1d\xf2\x6a\xe8\xb7\x56\x6b\xf5\x94\x4d\xc0\x6f\x2a\x68\xbe\x20\xe6\x0a\x2e\x17\x75\x14\x0c\x8f\xa0\x96\x91\x56\xda\xdd\x59\x69\x4d\x2a\xc7\x0c\x17\xb4\x86\x02\x8c\x82\x48\x82\xfa\x5b\x15\xe3\x2b\xe6\x94\x53\xfd\x2e\x94\x6b\xab\x96\xcc\x67\xca\xc5\xcc\xaa\xe4\x1a\x70\x2d\x8d\x83\x76\xb0\xdc\x9f\x55\xa5\xe1\xb3\xc9\x79\x89\xd6\x0c\x88\xf3\xd6\x81\x27\x0d\x1f\xed\xc7\x22\x7d\x67\x95\xfe\xfd\xb2\xaa\xb0\xdc\x93\x73\x05\xae\x77\xc6\x7a\x40\x5e\x91\xf0\x53\xf8\x17\xca\xe3\x5d\x31\x6e\xbe\xb5\x6a\x99\xa2\xae\xa7\x59\xc5\x7c\xdf\x75\x56\xcd\x9f\xa3\xce\x5e\x79\x6e\x16\xfb\xe4\x04\xc9\x66\xc6\x60\x8f\xff\x3d\xfd\xff\x25\x2f\xf4\x44\xbc\x61\xf9\x7a\x73\xcd\x73\x8f\xce\x5a\xa3\x5f\xae\xba\x36\xe1\x55\xb4\x1c\x5f\x90\xa0\xe3\x7b\xad\xc0\x72\x24\x0f\xa2\xab\x95\x3d\xc4\x53\xc6\x25\x92\xfd\xe3\x9e\xa4\x8e\xb3\x9c\x36\x7b\xd1\x6a\x25\x08\x6a\x29\x64\x13\xcf\x5f\x33\xf0\xc7\xd5\x22\x1b\x2b\x8d\x61\x06\x03\x19\x0f\x38\x27\x60\xe6\xd6\xcc\xd4\x13\xdb\x1e\x81\x6b\xc7\x2b\xed\xf8\x99\x4f\xa7\xd4\x5c\x3d\x6c\xba\xce\xc5\xc2\x69\x3e\xde\x8d\xc8\xab\xf1\x2d\x52\xe8\xdd\xb1\x70\x67\x60\xae\x25\x1a\x8b\x94\xfa\x57\xbe\x5f\xcf\x0d\x36\xc5\xe5\x2c\xce\x91\xad\xcd\xa8\xe0\xf7\xa7\xf3\x79\x9a\x16\x86\xd5\xf7\x43\xeb\x65\x78\x05\xfb\x55\xbc\x15\x7f\x03\x00\x00\xff\xff\x3f\x57\xa9\xf1\x91\x0c\x00\x00")

func dataTmiClueJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiClueJson,
		"data/tmi-clue.json",
	)
}

func dataTmiClueJson() (*asset, error) {
	bytes, err := dataTmiClueJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-clue.json", size: 3217, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiPubsubJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x9c\xcf\xbb\xaa\xc3\x30\x0c\x06\xe0\xdd\x4f\x21\x34\x87\x78\xcf\xab\x1c\xce\xe0\xc4\xa2\x71\xc1\x17\x2c\xd9\x04\x42\xde\xbd\xd8\x14\x4a\xe8\x05\xda\x45\xc3\xff\x4b\x1f\x68\x57\x00\xc8\x75\xc1\x09\x70\x89\x96\xc6\x6b\x61\x71\x61\x94\xaa\x97\xd5\x88\x16\xef\x74\x2a\x33\x97\x19\x87\xb6\x9a\x63\x11\x62\x9c\xe0\x4f\x01\x00\xec\x7d\x02\x60\x32\x22\x94\x43\x63\xb4\xa5\xb9\x5c\x74\x35\x99\xfb\x4d\xef\x83\xf1\xd4\x4a\xda\x52\x35\xf9\x91\x7b\x92\x35\xda\xd6\x60\x8f\x8e\xe1\xbd\xfb\xac\xb9\x60\x69\xfb\x0d\x4b\xf7\x8f\x4e\xde\x29\xfc\x46\xe3\x57\x1a\x7f\xd4\x14\xc0\xbf\x3a\xd4\x2d\x00\x00\xff\xff\x79\x7b\xdb\xef\x81\x01\x00\x00")

func dataTmiPubsubJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiPubsubJson,
		"data/tmi-pubsub.json",
	)
}

func dataTmiPubsubJson() (*asset, error) {
	bytes, err := dataTmiPubsubJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-pubsub.json", size: 385, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataTmiRoomJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x9c\x8d\x3d\x0a\xc3\x30\x0c\x85\x77\x9f\x42\x68\x0e\xf1\x9e\xab\x94\x52\x9c\x58\x34\x2e\xf5\x0f\x96\x6c\x0a\x21\x77\x2f\xf6\x52\x4a\x68\x86\x2e\x1a\xde\x7b\xfa\xbe\x4d\x01\x20\xd7\x05\x27\xc0\x25\x5a\x1a\x1f\x85\xc5\x85\x51\xaa\x5e\x56\x23\x5a\xbc\xd3\x39\x46\x8f\x43\x1b\xe6\x58\x84\x18\x27\xb8\x28\x00\x80\xad\x5f\x00\x4c\x46\x84\x72\x68\x10\x6d\x69\x2e\x77\x5d\x4d\xe6\xfe\xd3\xfb\x60\x3c\xb5\x92\x5e\xa9\x9a\xfc\xc9\x3d\xc9\x1a\x6d\x6b\xb0\x47\xfb\xf0\x9b\xeb\xc9\xcf\x94\x79\x75\xe9\x56\x92\x35\x42\x47\xfc\xc9\xe4\x4f\xd3\xd3\xb1\x9c\x7a\xbe\x07\x07\x8b\x02\xb8\xaa\x5d\xbd\x03\x00\x00\xff\xff\x5a\xf3\xeb\xac\x66\x01\x00\x00")

func dataTmiRoomJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataTmiRoomJson,
		"data/tmi-room.json",
	)
}

func dataTmiRoomJson() (*asset, error) {
	bytes, err := dataTmiRoomJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/tmi-room.json", size: 358, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataUsersServiceJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xa4\x90\x31\x4f\x04\x21\x10\x85\x7b\x7e\xc5\x84\xfa\x3c\xfa\xad\x25\x36\x16\x16\x67\x65\x0c\x81\x65\xb2\xa2\xde\xb0\x81\x61\x8d\xb9\xec\x7f\x37\x60\xb3\x71\x89\x1a\x6d\x28\xde\xfb\xe0\x0b\xef\x22\x00\x64\x5e\x46\x39\x80\x1c\xa3\xc7\xe3\x73\xc9\x1c\xe8\xc8\x8b\x7a\x43\xa7\x4a\xc6\x94\xaf\x32\xa6\x25\x8c\x28\x0f\x15\x4e\xb1\x30\x66\x39\xc0\x83\x00\x00\xb8\xb4\x13\x40\xce\x96\x19\x13\xd5\x87\x3e\xaf\x35\xbc\x55\x64\xcf\x58\xf3\x09\xd9\xb8\xf2\xfa\x62\x6a\x6f\xe6\x14\x67\x4c\x1c\x70\x43\x9e\x91\x9f\xa2\xaf\xec\x8d\x3e\xc9\x96\xae\x87\x1f\x3c\x6a\x08\xbe\xef\xfa\xa2\x31\xee\xdd\x6c\xd1\xbf\xca\x94\xb3\xb4\x17\x16\x72\x96\x9a\xb2\x67\xb8\xd6\xb7\xfa\xa4\xff\x2d\xf9\x4e\x71\x77\xff\x8b\x4f\x78\x74\x65\x52\xa9\x10\x05\x9a\xfa\xab\x35\xc4\xec\x90\xde\x5a\x02\xe0\x51\xac\xe2\x23\x00\x00\xff\xff\xec\xbd\x25\x32\x45\x02\x00\x00")

func dataUsersServiceJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataUsersServiceJson,
		"data/users-service.json",
	)
}

func dataUsersServiceJson() (*asset, error) {
	bytes, err := dataUsersServiceJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/users-service.json", size: 581, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiFindJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xa4\xd0\xb1\x4a\x04\x31\x10\xc6\xf1\x7a\xe6\x29\x8e\xa9\x14\x8e\x9d\x3e\x9d\xe0\xa1\x0f\x60\x27\xb2\xc4\xcd\x2c\x89\x5e\x92\x25\x99\xac\xc5\x71\xef\x2e\xb9\x3b\x0b\xbb\x15\xfb\xff\xcc\x0f\xbe\x13\x02\xd5\x75\x22\xb3\xa3\x29\x3b\x19\x3e\x5a\xd5\x90\x06\x5d\x79\x0d\x4e\x32\xb7\xea\xa5\xb0\x5d\x02\xcf\x21\x39\xda\x23\x50\xc9\x4d\xa5\x92\xd9\xbd\x22\xc0\x09\x01\x80\x16\xab\x2a\x25\xf5\x2f\x5c\xb5\x88\x8d\x3c\x1f\xf3\x57\x65\x2f\xf6\xa8\xfe\x6e\x30\x73\x2e\xd1\xea\x7d\x7f\x00\x40\xc9\x46\xe9\xf1\xb5\x1d\x2f\xed\x78\x6d\x6f\x45\x14\xf5\xd9\xf5\xe6\xf9\xf0\xf0\x48\x08\x70\xde\x6f\xe5\xc6\x77\x3b\x7d\xb6\xe5\x2f\xea\xed\xe4\x5f\x78\x1f\x88\x4d\x70\xdb\xdc\x9f\x39\x7f\x71\x4f\x87\x97\x8b\x86\xf0\x86\x67\xfc\x0e\x00\x00\xff\xff\x87\xb0\x08\x17\x9c\x01\x00\x00")

func dataVideoUsherApiFindJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiFindJson,
		"data/video-usher-api-find.json",
	)
}

func dataVideoUsherApiFindJson() (*asset, error) {
	bytes, err := dataVideoUsherApiFindJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-find.json", size: 412, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiUsherJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xac\x97\xcf\x8f\xdb\x2a\x10\xc7\xcf\xf6\x5f\xb1\xf2\xe9\x3d\x69\x15\xdf\x73\x7b\xd2\x5b\xb5\xb7\x56\x6a\x6f\x55\x85\x08\x9e\xc4\x6c\x30\x20\x18\x3b\x1b\xad\xf6\x7f\xaf\xb0\x61\xf3\x9b\x18\xd2\x9b\x15\xbe\xdf\xf9\x30\x30\x30\xe4\xbd\x2c\x2a\x3b\xb0\x6a\xf9\x54\x31\xd5\xc0\xe2\xb5\xb7\xc8\xe5\x02\x87\x7a\xe0\x0d\xa8\xba\xb7\x2d\x98\x9a\x6a\x3e\x7d\x55\xcf\x65\x51\x19\xd5\x23\xd8\x6a\xf9\xf4\xab\x2c\x8a\xf7\xb2\x28\x8a\x4a\x53\x44\x30\xd2\x85\xa9\x4d\x2f\x25\x97\x9b\x7f\x16\xcb\xb5\x32\x1d\xc5\x7f\x9d\xa9\x28\x2a\x49\x3b\x70\x02\x3f\xee\x7f\xed\x00\x5b\xd5\xb8\xdf\xbf\xbe\xfc\xf7\x7f\x55\x16\xc5\xc7\xf3\xf5\xb0\x6a\xa5\xd0\x2e\xf0\x0d\xcf\xe3\x8d\x03\xe4\x30\x70\x08\xf9\xe5\xe5\xa7\x8f\x78\x35\xa4\x4b\x8b\xb5\x54\x4a\x10\x75\x2b\x6c\xbd\xe4\xcd\xcd\x59\x53\xcd\x89\xd7\x92\x56\xd8\x08\xea\x1a\x89\x51\x4d\x19\xc7\x7d\xcd\x5a\x60\xdb\x9b\x90\x20\x23\xa3\x2c\x95\xe1\x33\xd9\x72\x21\x88\x45\x03\xb4\x8b\xa7\x14\xd2\x39\x36\x5c\x30\xbf\x7f\xfb\x31\x07\xaa\x8d\xd2\x60\x70\x4f\x7a\xdd\x50\x84\x59\xdc\x33\x4f\x2e\xda\x82\x6c\x08\x53\x5d\x07\x86\x71\x2a\xc8\xca\x00\xdd\xce\x9a\xc0\x55\x67\xe6\xaa\xa3\xb2\x64\xe0\x4a\x50\xe4\x4a\xce\xa2\x9f\x38\x32\x93\x0f\x6b\xc8\xc1\xba\x0a\x76\xc9\x68\x8a\x7c\xc5\x85\x2b\xb6\x84\x4d\xe0\x60\xc9\x45\x80\xbc\xa5\x38\x9e\x93\xe0\x03\x4c\x71\xa7\x31\x9b\x32\x9f\x0b\x73\xea\x7c\x44\x6f\x11\x4c\x2d\xb8\xc5\xdb\xdc\x49\x44\x9c\x28\x33\xbe\x54\x0d\xdc\x39\x69\x1e\x32\x2a\x33\x29\xb6\x55\xbb\x59\x10\x27\xcc\x64\xcc\x39\xbc\x9e\x92\x79\x66\x8d\xb2\xb6\x51\x1d\xe5\x72\xf1\xd6\x89\xf3\xd8\x87\x51\x72\x18\x9d\x9b\x44\xb3\x52\x7a\x3c\x7c\x54\x88\x68\x0a\x41\x48\xa8\xc8\x66\x6c\x00\xe7\x31\x36\x90\x5a\x56\xae\xe2\xd1\x50\x69\x5d\x43\xae\x99\x81\x7b\x5b\x72\x62\x20\x93\x21\x75\x63\x4e\xa1\xee\x30\x10\x19\x7a\xc2\x4c\xf0\xa9\xe9\xa1\xa4\x3b\x2a\xf9\x1a\x6c\x7c\x89\x4f\xe9\xc1\xf2\x57\xb8\x64\x0b\xfb\xb9\x69\x9f\x78\x1e\xa2\x6b\xba\x17\x8a\x36\x29\xf0\x63\xcb\x43\x6c\x77\x69\x84\x7b\x36\x61\xd5\x8f\x6d\x89\x7c\x2e\xdd\x27\x15\x35\x97\x1b\xb7\x7c\x9d\x92\x1c\x95\x71\xa9\x44\x27\x10\x7c\xe4\xd2\x97\x38\x83\x57\xb5\x1a\x1f\x0f\x51\xdc\xab\x5a\x8d\xef\x84\xd4\x03\xe5\xae\xfa\x7a\x2d\xd4\x2e\xde\x19\x9c\x8c\x8c\xb2\xc4\xc9\xcb\x70\x4e\xe3\xa1\x33\xda\xda\x18\x59\x72\x46\x3a\xfa\x06\xb7\x0b\x71\x0c\xff\x29\xcb\x5a\x9e\x5e\x5b\x30\x48\x58\x23\xe3\x94\x83\x2e\x0b\x73\xb7\x73\xca\x50\xca\x39\x2b\x35\xe7\xa5\x3d\x01\xb2\x2e\x46\xab\x81\xa1\x81\x5a\x2a\x49\xfc\xf7\xfd\xc7\x54\x10\x5e\x33\x65\xf2\x0d\xac\x0d\xd8\xd6\x67\x11\xcd\x36\x10\x4f\x2d\xa9\x5b\x77\x0e\x1e\x38\xec\x98\xea\x65\xbc\x29\x9c\xb3\x3f\x5d\xb9\xf8\x69\xf2\xa4\xd7\xb3\xb0\x9f\xea\x5c\xdc\x8c\x17\xd8\xe3\xac\x69\x0b\xc3\x8b\xbb\xa3\x5a\x73\xb9\x89\x54\xd3\x04\x3a\xd7\xa7\x16\xd2\x44\x5d\x2b\xc3\xdc\xf6\x68\xc1\xd9\xfd\xff\x4a\x1e\x7d\x61\xca\x4c\x39\x7a\x5f\x7a\x56\xc6\x8d\xe9\xa3\xdb\xbe\xeb\xa8\xd9\xdf\x03\x78\x59\x1e\x63\x47\x39\x72\xb9\x19\xeb\x1a\x4c\xfc\xd6\xf1\xbc\x33\x4b\x22\x17\xc1\xa2\x67\x6f\x40\x82\xa1\x08\x77\x5b\xf4\xc1\x43\x8e\x3d\xa9\x9b\x36\xa8\x78\x6b\x1e\xd4\x65\x57\x0e\xc9\x94\xc5\xef\xf2\xa3\xfc\x13\x00\x00\xff\xff\x80\x00\xd7\xf2\xde\x12\x00\x00")

func dataVideoUsherApiUsherJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiUsherJson,
		"data/video-usher-api-usher.json",
	)
}

func dataVideoUsherApiUsherJson() (*asset, error) {
	bytes, err := dataVideoUsherApiUsherJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-usher.json", size: 4830, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiVideoJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x9c\xd0\xc1\x4a\xc4\x30\x10\x80\xe1\xf3\xe4\x29\x96\x39\x29\x2c\xcd\xbd\x77\xf1\xa8\xa0\x37\x91\x92\x6e\xc6\x6d\x64\x93\x09\xc9\xa4\x82\xcb\xbe\xbb\xc4\x56\x0f\xea\xd6\xa5\xc7\x32\x7f\xf3\x31\x73\x54\x80\x79\xdc\x61\xbb\xc1\x1d\x5b\x6a\x5e\x4b\x16\x17\x1a\x19\xf5\xe8\x2c\xb1\x2e\x79\xa0\xa4\x4d\x74\xd3\x37\x6e\x15\x60\xe2\x22\x94\xb1\xdd\x3c\x29\x80\xa3\x02\x00\x8c\x46\x84\x52\xa8\xcf\x68\xdb\x73\x14\xc7\x41\xef\x49\x74\xeb\xec\x55\xd3\xbe\x70\xf2\x46\xae\xeb\xdf\x00\x18\x8c\xa7\x5a\x7e\x85\xdd\x9e\x64\x1e\x79\x92\x81\x6d\x1d\xde\xde\x3c\xa2\x02\x38\x6d\xff\x34\x02\x5b\xd2\xb1\xf4\x07\x97\x87\x8e\x82\xe9\x0f\x74\xde\xa9\x71\xf7\x23\x5e\xe3\x95\x68\x8d\xd0\xe2\x4a\x9f\xd4\xd4\xfd\x12\xee\xef\x1e\x96\x88\x2c\x89\x8c\xd7\xa6\xc8\xc0\xc9\xbd\xd3\x59\x63\x0a\xbb\xef\x70\x25\x64\xf9\x2d\x2c\xee\x32\x3b\xb5\x5b\x49\x5c\x70\xb0\x19\xf9\xef\x64\x0a\x9e\xd5\x49\x7d\x04\x00\x00\xff\xff\x3d\x9c\xc2\x2d\xad\x02\x00\x00")

func dataVideoUsherApiVideoJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiVideoJson,
		"data/video-usher-api-video.json",
	)
}

func dataVideoUsherApiVideoJson() (*asset, error) {
	bytes, err := dataVideoUsherApiVideoJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-video.json", size: 685, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiVideoapiJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xa4\x94\x41\x8f\xdb\x20\x10\x85\xcf\xf0\x2b\x56\x9c\xb6\xd2\x2a\xdc\x73\xab\xd4\x55\x7b\x6b\xa5\xf6\x56\x55\x88\x98\x71\x4c\xd6\x61\x10\x0c\x8e\xda\xd5\xfe\xf7\x0a\xdb\x55\xeb\x26\x61\x17\xe7\x68\xfb\xbd\xf7\xc1\xf0\xcc\x33\x67\x22\x0e\x8d\xd8\xde\x89\x06\x0d\x6c\x0e\x29\x92\x75\x1b\x1a\xe4\x60\x0d\xa0\x4c\xb1\x83\x20\xb5\xb7\xd3\xb3\xf6\x56\x3c\x70\x26\x02\x26\x82\x28\xb6\x77\xdf\x39\x63\xcf\x9c\x31\x26\xbc\x26\x82\xe0\x72\x92\x0c\xc9\x39\xeb\xf6\xf7\x9b\x6d\x8b\xe1\xa8\xe9\x5d\x36\x31\x26\x9c\x3e\x42\x16\xcc\xdf\xe7\xb7\x47\xa0\x0e\x4d\x7e\xff\xe9\xf1\xfd\x07\xc1\x19\x7b\x79\xe0\x17\x73\x75\xa2\x0e\x83\xfd\xa5\xc9\xa2\x93\x01\x3c\x06\x52\xba\x21\x3b\xc0\x55\xd6\xc2\xa3\x16\x9e\x33\xfe\x97\xcf\x5f\xbf\xcd\xfc\x4b\xf8\xa6\xd3\xce\x41\xaf\x7c\x40\x0f\x81\x2c\x44\xd9\xdb\x48\x9b\xfb\x2b\xe8\x73\xbd\xca\xfa\x33\xec\xc7\xc7\x6a\xea\x00\xaa\xeb\xa3\x9a\xbf\xc5\xab\xbb\xbf\xb8\x84\xff\xcc\xb7\xaf\x27\x76\x78\x92\x5b\x6b\x6a\x96\x91\x3d\xb7\x93\x93\x37\x9a\xa0\x96\x3d\xb9\x6a\x8f\xdf\xec\xd0\x8f\xc5\xdb\x03\x15\x89\x7f\x84\x6a\x0f\xb5\x87\xdd\xf6\x78\x92\x83\x85\x53\x83\xc9\x51\x54\x2d\x06\xe5\xd0\x94\x77\x98\x4d\xea\x82\xa9\x76\x83\xb9\x14\x14\xb4\x8b\xf9\x2a\x90\x4f\xb6\xef\x8b\xd8\x85\x5c\x65\xf9\x6d\xc0\x00\xda\xfc\xac\x20\x8e\xfa\xdb\x90\xaf\x16\x77\x49\x5c\xd1\xd9\x25\xef\x0d\x75\x5d\x12\xd7\x35\xf5\x80\x3b\x19\xc1\x99\x22\xe8\x80\x3b\x95\x45\xb5\xe1\x63\x1d\x73\xe5\x62\x39\x3f\xeb\xd4\xa4\xab\x9c\xd9\x48\xc8\x37\x65\x39\x7b\xc5\x5d\x3a\x26\x53\xd0\x6d\x6b\x1b\x65\x5d\x8b\x65\xc2\xbf\xca\xda\x31\x45\x0a\xa0\x8f\x72\x97\xfa\xa7\xe9\x10\xaf\xa2\x26\xa5\xfa\xab\x5c\x89\x2a\x4e\x6c\x86\xac\x98\xd9\x9c\xfe\xea\xaf\x32\x13\x8a\xff\x08\x67\x3f\xf8\x0b\xff\x1d\x00\x00\xff\xff\xfc\xe4\xe2\x8f\x75\x08\x00\x00")

func dataVideoUsherApiVideoapiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiVideoapiJson,
		"data/video-usher-api-videoapi.json",
	)
}

func dataVideoUsherApiVideoapiJson() (*asset, error) {
	bytes, err := dataVideoUsherApiVideoapiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-videoapi.json", size: 2165, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoUsherApiViewcountJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\x94\x8e\xc1\x4a\xc5\x30\x10\x45\xd7\x33\x5f\xf1\x98\x95\xc2\xa3\xd9\x77\x27\x28\xb8\x53\xd0\x9d\x88\x84\x66\x4c\x23\x36\x29\x93\x49\x5c\x94\xfe\xbb\x84\x76\xa5\x16\x7c\xdb\x3b\x67\xee\xb9\x0b\x02\xe5\x3a\x50\x7f\xa2\x21\x39\xee\x3e\x4a\xd6\x10\x3b\xad\xa6\x06\xc7\xc9\x94\x3c\xb2\x18\x3b\x07\x53\x03\x7f\x0d\xa9\x44\xa5\x33\x02\x49\x2a\xca\x99\xfa\xd3\x0b\x02\x2c\x08\x00\x34\x5b\x55\x96\xd8\xaa\x8c\x94\x18\x43\xf4\x57\x5d\xff\x9e\x64\xb2\x7a\xdd\x9e\x00\x28\xda\x89\x1b\xb0\xdf\xf7\x74\x62\x1d\x93\x6b\xf9\xfd\xdd\xcd\x2d\x21\xc0\x7a\xfe\xb3\xb6\x6d\xb0\xde\x0b\x7b\xab\x49\x9c\x29\x73\x66\xd1\x43\xcb\x0f\xfc\x6d\xc3\x7f\x49\x1f\x1f\x9e\x9e\x2f\x90\x3a\xfe\x64\xe5\x7f\x4b\x37\xfc\x58\x8a\xf0\x8a\x2b\x7e\x07\x00\x00\xff\xff\xb0\x29\x67\xf3\x88\x01\x00\x00")

func dataVideoUsherApiViewcountJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoUsherApiViewcountJson,
		"data/video-usher-api-viewcount.json",
	)
}

func dataVideoUsherApiViewcountJson() (*asset, error) {
	bytes, err := dataVideoUsherApiViewcountJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/video-usher-api-viewcount.json", size: 392, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVideoshimJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xb4\x94\x4f\x6b\xdc\x30\x10\xc5\xef\xfe\x14\xc2\xe7\x10\xdd\xf7\x56\x88\x69\x0f\x85\x16\x9a\x9e\x4a\x11\x5a\x69\xb0\xd5\x58\x7f\xd0\x8c\x1c\x4c\xc8\x77\x2f\xf2\x2e\x34\xc4\x52\xb2\xae\xb3\x17\xc1\xae\x7e\x9a\xf7\xe6\x69\xe4\xa7\x86\xb1\x16\x27\xd5\x1e\x58\xab\xbc\x86\xdb\x3f\x09\xc9\xb8\x5b\x9a\xf8\x64\x34\xf8\xd3\x8a\x83\xb1\xed\x4d\x46\xa3\x4f\x04\xd8\x1e\xd8\xaf\x86\x31\xc6\x9e\x96\x95\xb1\x36\x48\x22\x88\x2e\x97\xe1\x64\x0d\x37\x2e\xff\x94\x23\xc7\x19\x09\xec\xb9\x18\x52\x04\x69\x85\xf6\x8f\x6e\x29\xb7\x1c\x75\xd2\x42\x3e\x17\x3c\x92\x28\x12\x16\x68\xf0\x3a\x33\xdf\xbf\xfd\xb8\x6f\x97\xbf\x9f\x6f\xea\x06\x64\x78\x61\x20\x21\x44\x1e\xa2\x0f\x10\xc9\x00\xae\x75\x7b\x20\x91\x21\x51\x82\xfe\x49\x7f\xee\x2e\x51\x4e\x34\x9c\xbb\x7c\x80\xb9\xac\x95\x19\x51\x60\xb6\x4a\xbd\x6c\x72\x34\x13\x70\x25\xc7\xf1\x28\xd5\x43\x25\xda\xcc\x88\x35\xb3\x2b\xdc\xd9\x27\x4a\x47\x10\x38\xc8\x68\x5c\xcf\x0f\x34\x07\xe0\x07\xa3\xb9\xf2\x36\x8c\x40\x50\x31\xf3\xea\xa0\x58\xe3\xbb\x7c\xc9\xa4\xcd\x71\x04\x61\x65\x6f\x94\x88\x80\xc1\x3b\x2c\x5d\xfe\x62\xe6\x5d\xfa\x1a\x5e\x72\x4a\x05\x3f\xa9\x66\xa7\xe8\xe6\xe7\xd5\x82\x39\x4d\xea\xc5\xb9\x6c\x1f\xd9\xd3\xa8\x4c\x06\x1e\x51\x28\x9f\x1c\x95\xc3\x28\x02\x7b\x12\x98\xbc\x46\x6e\x0d\xa2\x71\x7d\xb9\xed\x4c\x88\x15\xb1\xa7\xd7\x45\x33\x82\xf2\x51\xbf\xad\x5a\x60\x76\xeb\x16\xe7\xec\xac\x78\x6d\x99\xe5\x06\xcb\x32\xff\x77\x73\x95\x17\x5c\xd3\xd8\xfe\x5a\xeb\xbd\x68\xc8\x1f\xa8\x9a\xd4\x5d\xf7\xb5\xbb\xef\x2e\x12\x1b\x40\x8e\x34\x54\x9e\xdc\x7a\x7b\xe3\xcd\xc4\xe4\x5c\x75\xc8\x56\x9b\x1f\x55\x7c\x00\xa9\xdf\xaa\xfe\xa5\xfb\x74\xf7\x7e\x79\x0d\xc7\x54\x71\xfe\x6a\xab\xe4\xbb\x61\xec\x77\xf3\xdc\xfc\x0d\x00\x00\xff\xff\x5c\xc6\xfd\x30\xd3\x08\x00\x00")

func dataVideoshimJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVideoshimJson,
		"data/videoshim.json",
	)
}

func dataVideoshimJson() (*asset, error) {
	bytes, err := dataVideoshimJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/videoshim.json", size: 2259, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageApiJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x9b\xcd\x8e\xdb\x36\x10\xc7\xcf\xf6\x53\x04\xd6\x35\x88\x82\x04\xc8\xc1\xe7\x2e\x8a\x02\x45\x13\x20\xdb\x53\x51\x08\x34\x39\xb6\xd8\x95\x44\x81\xa4\xbc\xbb\x0d\xf2\xee\x85\x3e\x2c\x4b\x16\x29\x89\x43\xd6\x7b\xca\x66\xf9\x17\x7f\x1c\xcd\x68\x66\x44\x71\x7f\x6c\x37\x3b\x75\xa6\xbb\xfd\xbb\x1d\x15\x0c\x3e\xfc\x53\x29\xcd\x8b\x0f\xfa\x1c\x03\x3b\x41\x7c\xe6\x8a\x9c\x20\xa6\x39\xeb\x7e\xdc\xbd\xdf\x6e\x76\x52\x54\x1a\xd4\x6e\xff\xee\xaf\xed\x66\xf3\x63\xbb\xd9\x6c\x76\x25\xd1\x1a\x64\x51\xcf\x13\x93\x92\xc7\x95\x02\xa9\xe2\x7d\xfd\x4f\xc2\x59\x9c\x91\xe2\x54\x75\x97\x6f\x36\xbb\x82\xe4\x50\x4b\x7b\x65\x74\x23\xc8\x41\xa7\x82\xd5\x92\x6f\x7f\x3e\xee\xb6\x9b\xcd\xcf\xf7\x6b\x51\x47\x91\x65\xe2\x59\xc5\x27\x92\x83\x8a\x33\x7e\x36\x41\xeb\xc1\xa4\x53\x46\x03\xcd\x95\xfb\xeb\x83\x0f\x77\x09\xc9\x0b\x06\x2f\x81\x99\xf1\x9e\xb3\x25\xae\x4a\xc5\xf3\x1b\x60\xab\x92\x11\x1d\xdc\xb7\x2b\xc0\x0c\x94\x96\xe2\x75\x42\xfe\xe5\xe1\xf7\x87\xc7\x07\x1c\x9c\xa6\xa4\x28\x20\x33\xf9\xb8\x1b\xf2\x76\xf3\x51\x72\x28\x98\x4a\x79\xa9\xda\x55\x18\x58\x03\x4d\x34\xd4\xb8\x70\x2e\xa6\xc4\xfb\xcb\xca\x39\x8b\x4b\xd2\xfc\x4a\x48\x06\xd2\xc0\x6d\x87\xa3\xe1\xf0\xc0\xa3\x5f\xbf\xfb\x30\xab\x32\x13\xc4\xe4\xd4\x0e\x3a\x1a\x0f\x46\xa5\x95\xd2\x22\x4f\x9a\xff\xd9\xd9\x06\x55\xa0\x5b\x6d\x67\x62\xe3\x07\x05\xa3\x12\x8c\x0f\xa9\xdf\xcd\x35\x3f\xa4\xbd\x3f\x91\x79\x01\x4d\xf4\x4a\x08\x57\x6a\x4d\x93\x82\x55\x54\xdb\xb3\x80\x8a\xc6\x12\x9c\x03\x39\x8b\x09\xa5\xa0\x54\xa2\xc5\x13\x14\x73\x38\x83\xee\x6d\x99\x5f\xbf\x3d\xfe\xf6\xf5\x8f\xef\x2e\x5c\xc8\x0f\xc6\xac\xd3\x03\x87\x02\xb4\x75\xaa\x3a\x28\x2a\x79\xa9\xb9\x98\xb5\x2e\x90\x03\xcf\x1c\x9e\xe7\xad\x1a\x29\xee\xcf\x41\x38\x8a\xa6\x44\x27\xa5\x14\x25\x48\xcd\x8d\x0d\x4f\x0f\x35\x4b\xd1\x56\x96\x52\x1c\x79\x06\xc9\xa1\xfe\xdd\xac\xb5\x46\x25\x32\xb3\x71\x56\x57\xe2\xa4\xb1\xa5\x10\x9a\x1f\x39\x25\x75\xf8\x2c\x3f\x22\xcb\x97\x85\x48\xb6\xaf\xa2\xd2\x09\x14\x9a\xeb\x57\x63\xf6\xbb\x8e\x73\xb0\xf4\x81\xf7\x00\x07\x2f\x32\x03\x7c\x5c\xc0\xf3\x8a\x25\x5c\x55\x01\x4a\xea\x10\x0f\x8c\x9b\xca\xc1\x2d\x7f\x20\x0b\xbb\x00\xac\xdf\xef\xc4\x0e\x5d\xec\xdd\xe8\x81\x0a\xff\x60\x05\x67\xce\x40\x24\x39\x29\xc8\x09\x64\x93\x20\x24\x64\x44\x03\x4b\x9a\x11\x53\x4a\x1c\x5d\x12\x19\xe5\xde\x6e\x99\x2e\xab\x7d\xe6\x92\x94\x9f\xd2\x8c\x9f\x52\x53\x8c\x8e\x17\x66\xb9\xc0\xff\x71\x9d\xae\x0d\x5e\x4a\x21\x97\x57\x34\x92\x05\x5e\xc7\x22\x3c\x58\xb2\x1c\x9b\x5f\x12\xa5\x93\x83\x14\x84\x51\xa2\xf4\x72\xb8\x98\xf5\x81\xe3\xa5\xf7\xf9\xf2\x7a\x26\xd2\xc0\x4b\x91\xd0\x1b\xbb\xe2\x51\xba\xd5\x86\x0e\xd6\x27\x9e\x65\x89\xcb\x92\x2c\x17\xdc\x3b\x78\x83\xbe\x42\xba\xa1\x03\xd7\xfa\xb1\x3f\xcc\xb5\x7e\xbc\x80\x80\x95\xde\x90\xb9\xcc\xd5\xfe\x26\x6f\x05\xac\xf5\x93\x25\xe0\x12\xd7\xdd\xe8\x61\xeb\xbd\x3b\x3f\xd8\xab\xfe\x5c\x73\x8f\xbc\xc5\x4a\x03\xc9\x2d\x73\x37\x63\xd8\x89\xdb\x17\xbc\x98\x17\x47\x61\x98\x5a\x3f\x73\x4d\xd3\x4e\x14\x0d\x44\x08\x84\xed\xbd\x67\xcc\xc0\x6e\x46\x04\x80\xac\x7b\xa9\x3d\x0b\xb6\x6a\xc7\xa3\xd6\xf9\xee\xb0\xf4\xac\xe6\x75\x90\x11\x4d\x6c\xa0\x5b\x01\x8a\x92\x57\x75\x77\xa9\x25\xa1\x4f\xc6\x6a\x5e\x83\x0c\x1a\x9c\x45\x6d\xcb\x48\xca\x12\x88\x69\x13\xb5\xb5\xca\x20\x72\x49\x0c\x41\x69\xcb\x55\x28\x24\xce\x2d\x18\x6d\x0c\x74\x4a\x5d\x9a\xd8\x2b\x57\x9e\x05\xeb\xcc\xb6\x84\xd9\x65\x14\xdd\x8c\x68\x4e\x9f\xa0\xd9\x43\x62\x15\xd5\xfd\x1e\x5e\xce\x75\x02\xb9\xd0\x9c\x1a\xb7\xf1\x6e\xae\x8a\xcc\x57\x38\x85\xc4\xcc\x42\x0e\x84\x19\xbf\x6f\x5a\x56\x31\x94\x7b\x2f\x41\x42\x2e\xce\xe0\x72\x2f\xcc\x57\x38\x3a\xde\xb0\x94\x35\x37\x00\x57\xd9\x70\xb0\x50\x5f\x1e\xdb\x79\x4d\xf1\xdd\x8d\xf8\x7e\xd2\x5d\xb3\x7d\xd0\x7e\x2a\xf7\xde\x36\xb8\x12\x33\x71\xe2\x45\x72\x26\x19\x67\x44\x0b\x53\x47\xdf\x7d\x9d\x37\xea\x70\xcc\xf6\xdb\x28\xb0\x38\x15\x4a\xf3\xe2\x34\xd7\x5d\x5d\xb4\xc9\x58\x8b\x02\x5b\x8d\xf3\x0a\x11\xeb\xac\xd8\x70\x68\xbd\xea\xb0\x9d\x14\x20\x20\xae\x4c\x3b\x04\xf9\xd4\x1e\x81\xe8\x4a\x02\x4b\x6c\xc7\x22\xc6\x02\xf4\x6d\x13\xf2\xc0\xd5\xc5\x90\x4b\xd8\x18\x70\x8d\xae\xbb\x53\xd1\x8d\xee\xed\x78\xeb\xba\x83\x11\xd3\x76\x3f\x47\xc0\xa1\x08\x6d\x9d\x07\x09\x69\x57\xbc\x57\x14\x12\xcd\x75\x06\x89\x31\x26\x27\xe8\x10\x36\x06\xa0\x22\xec\xd5\xa2\x5c\x42\x5d\x25\x68\xfb\x90\x14\x84\x3d\x0a\x88\xa4\xe9\x12\x6c\xa4\x42\x5b\xe5\xc5\x72\xb7\x6d\x09\x14\x24\x77\x99\x93\xf0\xd8\x20\x5c\x2a\x76\xc5\xa0\xeb\xe2\x00\xb4\xd6\x9c\xf6\x67\xb4\x51\xed\xb9\xa0\x45\x07\xe1\x37\x24\x5b\x4c\xd7\x97\xd8\x30\x51\xfe\x9a\x8c\x25\xee\x96\x78\x20\x5c\x02\xba\x9b\xa3\xdf\x61\xb3\xf2\x02\xd9\x83\x07\xb9\x58\x95\x83\x26\x96\x5d\x95\xee\xee\x8d\x05\xee\x41\x8d\x27\xb8\xd8\xa1\xb4\x04\x92\x5b\xc3\x39\x1a\x8f\xbb\x3b\x05\x3b\xbf\x93\x0d\xb3\xb9\xd9\xb7\x00\xe0\x66\x77\x7a\x42\x44\x71\xe4\xa7\x4a\x12\xcb\x19\xa1\x2e\x6a\x0d\x2a\xc4\x43\x12\x80\x85\x88\xaf\xf9\xce\xce\xb3\x79\xf4\x61\x60\x6c\x59\xea\xc1\xfd\x9b\x7d\x7f\x12\xc6\xae\xc5\xc4\x19\x28\x19\xe0\x41\x2e\x56\xf1\xe2\x04\xe6\x6f\xdd\x2d\x63\x3c\xee\x6e\x0c\x76\x7e\x17\x1b\x24\x58\x8e\x2c\xb4\x88\xd1\x30\xa2\xc9\xc0\x4d\xef\x62\x00\xa9\x74\x2a\x24\xff\xd7\xb4\x5b\xd9\x42\x6e\x15\xee\x8e\x20\x47\x0d\x32\x59\x41\x32\xea\x10\x29\x34\xe3\x50\xe8\x99\xf7\xb6\xe8\x56\x81\xb0\x89\x52\x51\xd5\x53\x98\x3f\xae\x75\x06\x4d\x45\xce\xa4\xe6\x7e\x34\x6e\x82\x42\x73\x7a\xed\x59\xa7\x9d\x6d\x2d\x8a\x0c\x4a\x24\xb3\xd9\xe8\x9b\x87\x0d\x25\xee\xe1\x7d\x35\x6d\x36\x2e\xae\x76\x61\xc3\xa2\xfb\x13\x91\xc1\x6b\xfa\xed\x1f\x89\xa0\x5f\xa4\x5e\x0e\xe2\x65\xb1\x66\xd7\x22\xef\xf6\xa0\x21\xcd\xf4\x9c\x0d\xc4\xde\xd4\x2e\xfb\xa4\x01\xb4\x89\x7d\xae\x00\x34\x9c\x56\x86\xb5\x42\x29\xd3\x33\xd3\x4e\xac\xa6\x4f\xca\xda\xb5\x97\x92\x9f\x79\x06\xc6\x2f\x2f\xcd\xe4\xb7\x02\x77\x04\xe3\x8a\x8a\xa2\x00\xe3\x59\xff\x86\x31\x51\xb8\x43\xac\x59\xbf\x01\xe0\x6b\x0a\x13\x9a\x7c\x9a\x9e\xa8\x88\x73\xa2\x69\x6a\xfb\x04\xdd\x5c\x14\x4d\x24\x4e\x67\x48\x8c\x27\xc2\x3d\xfe\xa2\x45\xc5\x39\x29\x2d\x93\x0e\x46\x1c\xe7\x5c\x0e\x7d\xaa\xf0\x81\xdf\xec\x37\xf0\x33\xc4\x9a\x9c\x8c\x4b\xef\xc6\xa3\xc1\xb8\xeb\x83\xf5\xf9\xcb\xc7\x98\xb0\x44\x02\xe3\xd2\x1e\xa2\x9f\xbf\x7c\x8c\xa6\x2a\x4f\x56\xf2\x69\x1d\xad\xd7\x61\x78\x6b\xf2\x6c\xcd\xf3\x4d\xb5\xb9\x38\xf0\x0c\x16\x71\xad\xcc\x9b\x96\x92\x4c\x2c\xb2\xca\x8c\xe8\xa3\x90\xb9\x37\xed\x32\x51\x7b\x98\xe1\x4d\xa8\x27\x28\x40\x9a\x1b\x99\x1e\x78\xa3\x71\xca\x73\x23\xd8\x42\xe7\xd4\x03\x67\xfb\x26\x57\xe8\x6c\x99\xe8\x91\x7e\xa5\x42\x8a\xa7\xea\x7e\x0e\x6c\x68\xff\xb7\xe3\x1a\xc8\xbd\x1c\xd6\xc0\xee\xe1\x28\x63\xd3\xd9\x9c\x25\xa8\xeb\x29\xfa\x08\x44\x77\x68\xf0\xc3\xbe\x5e\x22\x31\xad\xdf\x7e\x76\x70\xe5\xdc\xf1\x9e\xd0\x3a\x5e\x96\x18\xfb\xaa\x78\x2a\xc4\xf3\x34\xae\x1a\xce\x76\xf3\xf7\xf6\xe7\x7f\x01\x00\x00\xff\xff\x02\x8d\x6d\x14\x5c\x40\x00\x00")

func dataVisageApiJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageApiJson,
		"data/visage-api.json",
	)
}

func dataVisageApiJson() (*asset, error) {
	bytes, err := dataVisageApiJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-api.json", size: 16476, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageKrakenJson = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x9a\xcd\x8e\xe4\x26\x10\xc7\xcf\xee\xa7\x58\xd9\xb7\x68\xb5\x48\x39\xce\x39\xa3\x28\x52\x94\x59\x69\x27\xa7\x28\xb2\x68\xa8\xb1\x49\xdb\xe0\x00\xee\x9d\xc9\x6a\xdf\x3d\xf2\x47\xaf\xc1\x36\xfe\x00\xef\xf6\xa5\xbb\x35\xfc\x5d\x3f\xa8\x2a\xa0\x30\xf3\xe5\x14\xc5\xea\x4a\xe2\x87\x77\x31\x11\x14\x3e\xfc\x53\x2b\xcd\xf8\x07\x7d\x45\x40\x33\x40\x57\xa6\x70\x06\x88\x94\xb4\xff\x19\xbf\x3f\x45\xb1\x14\xb5\x06\x15\x3f\xbc\xfb\xeb\x14\x45\x5f\x4e\x51\x14\xc5\x15\xd6\x1a\x24\x6f\xec\xa0\x8b\xc4\x17\xe0\x48\x69\x09\xb8\x54\xe8\x45\x14\x85\xf8\x0c\xb4\x79\x34\x8a\x62\x8e\x4b\x68\x64\xa3\x3f\x97\xa0\x73\x41\x9b\x86\x5f\x1f\x9f\xe3\x53\x14\x7d\x7d\xbf\xc5\xf8\x03\xc9\x31\xe7\x50\x8c\x8c\x77\xcd\x41\xa6\x67\x2d\x2a\x3f\x93\xb5\x02\xa9\xd0\x43\xf3\x95\x16\x22\x63\x1c\x91\x1c\xeb\x11\xa1\xd7\x1a\x2d\x9e\x3e\x91\x40\x44\x59\x02\xa7\x40\x11\xbe\x62\x56\xe0\x73\x01\xf3\xb0\x2d\x8f\x84\xf7\x62\xc4\x5e\x57\xee\x44\x0a\x5c\xeb\xfc\x67\x44\x0a\x06\x5c\x37\x39\xd1\xfe\x48\x19\x45\x12\x14\xe8\x54\x01\x91\xe0\x70\xb7\xfd\x6c\x32\xf3\xc0\xd0\x99\x8f\x4f\x9f\x76\xf7\x66\x13\x95\x48\xc0\x7a\xea\x6f\x1f\x1e\xe2\xf0\x79\x13\x73\xd0\x05\x7a\x9b\x8d\xe3\x3b\xcf\x53\xb9\xf8\xb1\xc0\xba\xa2\xb3\x4e\xfd\x73\x3b\xb2\xf9\x04\xae\x19\x19\x0c\xcd\x33\x25\xfc\x5b\x83\xd2\xc9\xcc\x03\x7e\x83\x6d\x57\x89\x4d\x48\x53\xe9\x99\x3a\xcd\xa7\x90\xec\xbf\xed\x63\x34\xd5\x7e\x03\xc4\xcd\xea\xbf\x8d\x67\x28\x3d\x07\x58\x40\x86\xc7\x5b\x84\xc3\x9b\x86\xd2\x6f\x60\x5a\x5c\x60\x5b\xe4\x4c\x65\x60\xe4\xb0\x66\x82\xaf\xce\x8c\x1b\x98\x82\xd2\x52\xbc\x4d\xd0\xbf\x3c\xfe\xfe\xf8\xfc\xb8\x0a\x9f\x67\x74\x5f\x09\xe3\x14\x5e\xfd\x1c\x78\xc6\xca\x91\x81\xbd\x6d\x43\xe0\xb9\x29\xbd\x00\xd6\xb5\x9c\xec\x48\xb6\x2a\x19\xa9\x3c\x59\xaa\x2e\x4b\x2c\xdf\x96\x51\xb6\x68\x27\x29\xc3\x25\x28\xa4\x45\x35\xcf\x68\x9b\x93\xa1\xd9\xcb\xfa\xb2\xc7\x3a\x44\x98\xbf\x18\xcf\x40\xb9\x36\xca\xbe\x31\x24\xad\xae\x8c\x82\x58\x70\x53\xd7\xee\xef\xa7\xde\xbe\xa3\xcc\xb5\x21\x61\x45\x6f\x4f\x72\x4e\xf3\x1e\xe2\xbf\xd3\x9a\x75\x2a\xa3\xe8\x5c\x08\x72\x71\x04\xa6\x6b\x0b\x89\xcb\x2c\xcc\x3d\xb8\x1e\x78\xf0\xe0\x56\x79\x21\x55\x84\x1f\x31\x70\x75\x1e\x53\xbb\x94\x53\xa8\x3f\x28\x39\xc2\xd9\xab\x0e\x8c\xe7\x98\xeb\x1e\xf7\x8d\x7d\x58\x68\xf7\xa3\x0f\x8c\xf2\x7e\xf8\xc1\x01\xaf\x6a\x95\xa7\xaa\x3e\x2b\x22\x59\xd5\xd4\x05\x8e\x90\x4f\x75\x07\x46\x7f\x6a\xdc\xed\x87\x99\x8e\x1c\x96\x0a\x81\xfd\x38\x30\x2f\x02\x7b\x72\x70\x92\x6c\xec\x48\x2b\x3f\x38\x34\x4b\xac\x50\xf3\x4b\x96\x03\x93\xfb\x8e\xf3\xea\xbe\xb3\xe9\xde\x73\xe8\xde\x33\xe7\x0c\x1a\x0f\xef\xaa\x30\xa7\xa2\x74\xec\xdf\x86\x30\xb1\x84\x3b\xbd\x6e\x6e\x1d\xb7\x5d\xc2\xf9\xb2\xb0\x55\x26\xb6\x2a\x88\xd7\x15\xf3\xab\x40\x5b\x16\x42\x6c\xdf\xfe\x49\xc2\x5c\x47\xf4\x6f\xcc\x89\x70\xef\xa9\xd9\xc2\x76\x91\x4a\x2f\xe0\x38\xa2\x7d\xc3\x4e\x84\xfb\x73\xc8\x02\x77\x65\xfa\x0a\xd4\x12\x85\x78\x17\x28\xd3\x42\xae\xe1\x6c\x55\x08\x4f\xcf\xbc\x3c\x1f\xd3\xb4\xff\xab\xf4\x81\xd5\xff\x9a\xec\x66\x8e\x03\xf7\x51\x0b\xf2\x7a\x07\xdc\xab\xd3\x51\xcb\xf2\x7a\x6d\x39\x24\xef\x8f\x80\x84\x2c\xf1\xf3\x17\x38\x63\x42\x78\xc0\xbe\xef\x10\x2a\xbd\x58\xdb\xdc\x14\x61\xe1\xd0\x08\x4a\xa1\x19\x71\x26\x79\xa3\x49\x6e\x9a\x34\xcc\x67\x03\x2c\x65\x25\xce\x16\x36\x04\x13\x69\x2a\x7d\x98\xed\x8a\xb5\x63\x90\xa1\xac\x33\xa6\xcb\x43\xb3\x04\x9e\x94\x05\xf3\xfe\xf9\xa0\x00\x4b\x92\xaf\x1c\xeb\x3b\x51\x32\x12\xf9\x91\xda\x77\x7d\x8b\x18\x53\xe1\xc7\x98\xbf\x7b\xb5\x29\x41\x37\xb1\x3d\xa7\x3d\x11\x2c\x52\x4c\x85\x1f\xe3\x2a\xe8\x32\xc2\x10\x78\x11\x16\x8d\x07\x4c\xfe\x85\x1d\xbc\x6d\x0a\xb6\xed\x9e\x13\x9d\x7d\xff\x49\x51\xe1\xb7\xb2\xbd\x24\x84\xd7\xa6\x09\x17\x48\x02\xa9\x65\xe1\x28\xf1\x26\xf2\xc4\x96\xef\xad\x2f\xa7\xf8\x0a\xbf\x55\xae\xba\x76\x4a\xb7\xd4\xe1\xf0\x57\x25\x8a\x02\x6f\x85\x5b\xea\x60\xbf\x77\xd6\x9a\xa3\xd8\x3e\xbe\xf1\xc4\xee\xea\x7e\x7a\xff\xdf\x56\xd1\xa9\xd2\x58\xd7\xae\x45\xbe\xbf\x2d\x9e\x51\xee\xf4\xc1\x4f\x15\xd6\x8e\x39\xd9\xdf\x5f\x11\x21\x55\x5a\x49\x78\x29\x58\x96\x4f\xff\xbd\xe0\xe9\xe3\xf3\x6f\x4f\x7f\x7c\x3a\x82\x24\x45\xad\x19\xcf\x52\x90\x52\xc8\x09\xa8\x25\x9c\xa2\xbf\x4f\x5f\xff\x0f\x00\x00\xff\xff\x94\xfe\xd9\x52\xff\x23\x00\x00")

func dataVisageKrakenJsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageKrakenJson,
		"data/visage-kraken.json",
	)
}

func dataVisageKrakenJson() (*asset, error) {
	bytes, err := dataVisageKrakenJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-kraken.json", size: 9215, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV1Json = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x99\x5d\x6f\xb3\x36\x14\xc7\xaf\xc9\xa7\x78\x04\x77\xd3\xa3\xa2\xec\x32\xd7\x8b\xa6\x49\xd3\x5a\xa9\xdd\xd5\x34\x21\xc7\x9c\x12\xaf\x80\x99\x6d\x68\xb3\xaa\xdf\x7d\xe2\x25\xc5\xe0\x03\x89\x0d\x7d\x72\xd3\x46\x39\xff\xfc\x7f\xf8\x1c\xbf\x1c\xe0\x7d\xe3\xf9\xb2\xa2\xfe\xee\x9b\x4f\x79\x0c\x77\xff\x94\x52\xb1\xfc\x4e\x55\x21\xc4\x09\x84\x15\x93\x24\x81\x90\x66\x71\xf7\xd1\xff\xbe\xf1\x7c\xc1\x4b\x05\xd2\xdf\x7d\xfb\x6b\xe3\x79\xef\x1b\xcf\xf3\xfc\x82\x28\x05\x22\xaf\x7d\xc2\x6a\x1b\x4a\x25\x80\x64\x32\x7c\xe6\x69\xca\x5f\x21\xae\x7f\xe6\x79\x7e\x4e\x32\xa8\x25\xa3\xaf\x33\x50\x47\x1e\xd7\x81\x5f\xf7\x4f\xfe\xc6\xf3\x3e\xbe\x5f\x32\xde\xd1\x23\xc9\x73\x48\x47\xc6\x6d\xd8\xd9\x16\x75\x93\xf6\x76\x9c\x94\xea\xf8\x73\x48\x53\x06\xb9\xaa\x2f\xb6\xf9\x10\xb1\x38\x14\x20\x41\x45\x12\xa8\x00\x35\xa2\x19\xbf\x0b\x10\x71\x7f\x11\x0f\xf7\x8f\x56\x57\x71\x91\x46\x05\x10\x05\x8b\x39\x61\x0e\xaf\x17\x59\xbd\x66\x41\x56\xd9\x78\x5a\x99\x1c\x79\xe4\x3f\x06\x54\x16\x31\x9a\xbc\x3f\xaf\x43\xd5\x7f\x21\x57\x8c\xf6\x26\x26\x4b\xc0\xbf\x25\x48\x15\x20\x62\xfb\xc1\xa5\x3c\x61\xf9\x45\x94\xae\x72\x98\x12\xf5\x5f\x2e\xd8\x7f\xd7\x8d\x49\x57\xda\x0f\x88\xd4\x5b\xca\x65\x8e\xa6\x72\x18\x50\x0a\x09\x19\xef\x39\x48\xd6\x34\x95\xfd\x40\x14\x7f\x81\xcb\x95\xd1\x55\x0b\x2a\x43\x14\xe3\xf9\xec\x0c\x3f\x03\x63\x90\x4a\xf0\x93\x81\xfc\x65\xff\xfb\xfe\x69\x3f\x0b\x35\xbd\xab\x6d\xc0\xf2\x18\xde\xec\x93\x74\x20\x12\x99\x4d\xd5\x36\xd0\x02\x0e\xe7\xc9\x33\x10\x55\x0a\xe3\xa0\xea\x15\xc1\x48\xe1\xc0\x90\x65\x96\x11\x71\x9a\x46\x0c\x05\x16\x84\x84\x64\x20\x43\xc5\x0b\xd3\xbb\x09\x05\x7d\xc8\xda\x75\x3a\x33\xad\xb5\x7b\x5e\x58\x9e\x80\xc4\x0e\xa6\x2e\xe0\x3a\x45\x2a\x16\x03\x9f\x48\x47\x1b\x73\xcb\x47\xe7\x3b\xd1\xd3\xf4\xe6\xee\xdd\x4d\x47\x40\x97\x63\x67\xee\x76\xa2\x95\x12\x84\x0c\x77\xf5\xbf\xba\x0b\x39\xa4\x9c\xbe\x20\x89\x6f\xbf\x77\xcd\x3b\x0a\xc1\x07\xd3\x81\x56\x1c\xcc\x2c\xc7\xf5\x74\xb6\x27\x2d\xd8\x25\xc7\xb4\x76\x1a\xc9\xb0\xeb\x74\x91\x72\x75\x8a\x95\xea\x35\xe6\xe1\xe3\x3c\x33\x57\x29\x9d\x1d\x72\xa5\x2a\xda\x41\x57\x2c\x68\x51\xca\x63\x24\xcb\x83\xa4\x82\x15\xf5\xb9\x8b\x94\xd4\xd4\xac\x54\x5d\xd3\x18\x1f\x37\x72\x01\xab\x94\x7a\x01\x7f\xa5\xba\x2f\xb8\x82\x15\x27\xc1\x15\x17\xd0\x48\x57\x2c\xc1\x14\x63\x89\xed\x94\xe3\x82\xc9\x7a\x83\xf5\x71\x9b\x55\x71\xab\xb5\x70\xab\x15\x70\x00\x45\x3e\x9b\x60\x41\xf2\x98\x67\xc8\xf9\xa9\x89\x82\x81\xc8\x22\xbb\xfa\x96\x7e\xde\xc1\x4d\xd4\x59\x15\x0c\x15\xce\x9c\xb6\x01\x9e\x05\x0d\x25\xae\x24\xca\xb3\x0c\x04\x65\xd8\x2d\xe8\x27\xcb\x10\xd9\xdc\x1d\x0e\x70\x6d\x35\xa2\x17\x40\x6e\x59\x3e\x71\x86\xc8\x6e\x6e\x0c\x80\x6d\x8b\x3b\x03\x1b\x08\x5c\xb3\x08\x31\x53\x5c\xcc\x61\x86\x0a\x57\x8e\x42\x9e\x28\xea\x14\xe5\xf6\x6c\xb1\x67\x74\x9f\x8c\x53\x05\xb9\xc1\x5c\x63\xc3\xbc\x0c\xc6\x77\x93\x35\xb6\xcd\xf9\x5e\xad\x9f\x8c\x5f\x69\xee\xba\xf5\xe2\x4f\xaa\x75\xe7\x65\x05\xf9\x9a\x4b\x2e\xd4\x64\xef\x70\x8e\xba\xa7\x5b\x85\x90\x71\xc5\x28\x3a\x59\xeb\x78\x70\x8e\x47\xee\xb9\xe9\x21\x11\xcb\x48\x32\xb1\x41\xeb\x28\x5d\x65\xcb\x6a\x76\x96\x2b\x07\xb5\x84\x71\x20\xf1\xf4\x50\x06\x41\x07\xf7\x09\x5b\xb7\x3a\x4b\x20\x82\x1e\x67\x6e\x5f\x5b\x41\x30\x12\xd8\x13\x9a\xe7\x50\x93\xf6\x7a\xd4\xde\x1b\x7f\x31\xd4\xbb\x3b\xbf\x22\xea\xfc\x9b\xae\x79\xd2\x5d\x8f\xda\x7b\x57\x3c\x9e\xb6\xd6\x82\xd6\xce\x93\xa6\x8e\x8b\x75\xe2\xa4\x6c\xbe\x5e\xe4\x89\xcf\xe9\xd6\xd7\x6d\x52\x17\xe4\x94\x35\x2f\x85\xe0\xad\xfe\x9a\xa4\xa1\x00\x5a\x8a\x14\x69\x91\x0c\x69\x30\x94\xda\xf4\x65\x26\xb6\x20\xa7\x02\xeb\x03\x4d\xea\x40\xb9\x0c\xfa\x26\x79\x9a\x92\x6b\xa0\x03\xe5\xa2\xfc\xb6\x4e\xf5\xed\xc8\xf5\x5c\x4d\x6d\xd5\xfd\x9a\xef\x6b\x9b\x8e\x33\x92\x8a\xa8\x12\xdb\x74\xbb\xb7\x7f\x88\xca\x62\xcc\x3f\x15\x44\x21\x6b\xaa\xda\x06\x94\x0b\x19\x15\x02\x9e\x53\x96\x1c\xcd\x57\xc0\xf7\x0f\x4f\xbf\xdd\xff\xf1\xe8\xea\x2e\x78\xa9\x58\x9e\x44\x20\x04\x17\x86\x79\xe3\xba\xf1\xfe\xde\x7c\xfc\x1f\x00\x00\xff\xff\x4b\x32\x9a\x06\x24\x20\x00\x00")

func dataVisageV1JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV1Json,
		"data/visage-v1.json",
	)
}

func dataVisageV1Json() (*asset, error) {
	bytes, err := dataVisageV1JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v1.json", size: 8228, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV2Json = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x99\x5d\x6f\xbb\x36\x14\xc6\xaf\xc9\xa7\xf8\x0b\xee\xa6\xaa\x48\xb9\xcc\xf5\xa2\x69\xd2\xb4\x56\x6a\x77\x35\x4d\xc8\x31\xa7\xc4\x2b\x60\x66\x1b\xda\xac\xea\x77\x9f\x78\x49\x31\xf8\x40\x62\x43\x97\x9b\x36\xca\x79\xf2\xfc\xf0\x39\x7e\x39\xc0\xc7\xc6\xf3\x65\x45\xfd\xdd\x0f\x9f\xf2\x18\xee\xff\x2e\xa5\x62\xf9\xbd\xaa\x42\x88\x13\x08\x2b\x26\x49\x02\x21\xcd\xe2\xee\xa3\x7f\xb7\xf1\x7c\xc1\x4b\x05\xd2\xdf\xfd\xf8\x73\xe3\x79\x1f\x1b\xcf\xf3\xfc\x82\x28\x05\x22\xaf\x7d\xc2\x6a\x1b\x4a\x25\x80\x64\x32\x7c\xe1\x69\xca\xdf\x20\xae\x7f\xe6\x79\x7e\x4e\x32\xa8\x25\xa3\xaf\x33\x50\x47\x1e\xd7\x81\x5f\xf6\xcf\xfe\xc6\xf3\x3e\xef\x2e\x19\xef\xe8\x91\xe4\x39\xa4\x23\xe3\x36\xec\x6c\x8b\xba\x49\x7b\x3b\x4e\x4a\x75\xdc\x86\x34\x65\x90\xab\xfa\x62\x9b\x0f\x11\x8b\x43\x01\x12\x54\x24\x81\x0a\x50\x23\x9a\xf1\xbb\x00\x11\xf7\x17\xf1\xf8\xf0\x64\x75\x15\x17\x69\x54\x00\x51\xb0\x98\x13\xe6\xf0\x76\x91\xd5\x6b\x16\x64\x95\x8d\xa7\x95\xc9\x91\x47\xfe\xff\x80\xca\x22\x46\x93\xf7\xc7\x75\xa8\xfa\x2f\xe4\x8a\xd1\xde\xc4\x64\x09\xf8\xa7\x04\xa9\x02\x44\x6c\x3f\xb8\x94\x27\x2c\xbf\x88\xd2\x55\x0e\x53\xa2\xfe\xcb\x05\xfb\xf7\xba\x31\xe9\x4a\xfb\x01\x91\x7a\x4b\xb9\xcc\xd1\x54\x0e\x03\x4a\x21\x21\xe3\x3d\x07\xc9\x9a\xa6\xb2\x1f\x88\xe2\xaf\x70\xb9\x32\xba\x6a\x41\x65\x88\x62\x3c\x9f\x9d\xe1\x67\x60\x0c\x52\x09\x7e\x32\x90\x3f\xef\x7f\xdb\x3f\xef\x67\xa1\xa6\x77\xb5\x0d\x58\x1e\xc3\xbb\x7d\x92\x0e\x44\x22\xb3\xa9\xda\x06\x5a\xc0\xe1\x3c\x79\x01\xa2\x4a\x61\x1c\x54\xbd\x22\x18\x29\x1c\x18\xb2\xcc\x32\x22\x4e\xd3\x88\xa1\xc0\x82\x90\x90\x0c\x64\xa8\x78\x61\x7a\x37\xa1\xa0\x0f\x59\xbb\x4e\x67\xa6\xb5\x76\xcf\x0b\xcb\x13\x90\xd8\xc1\xd4\x05\x5c\xa7\x48\xc5\x62\xe0\x13\xe9\x68\x63\x6e\xf9\xe8\x7c\x27\x7a\x9a\xde\xdc\xbd\xbb\xe9\x08\xe8\x72\xec\xcc\xdd\x4e\xb4\x52\x82\x90\xe1\xae\xfe\x57\x77\x21\x87\x94\xd3\x57\x24\xf1\xed\xf7\xae\x79\x47\x21\xf8\x60\x3a\xd0\x8a\x83\x99\xe5\xb8\x9e\xce\xf6\xa4\x05\xbb\xe4\x98\xd6\x4e\x23\x19\x76\x9d\x2e\x52\xae\x4e\xb1\x52\xbd\xc6\x3c\x7c\x9c\x67\xe6\x2a\xa5\xb3\x43\xae\x54\x45\x3b\xe8\x8a\x05\x2d\x4a\x79\x8c\x64\x79\x90\x54\xb0\xa2\x3e\x77\x91\x92\x9a\x9a\x95\xaa\x6b\x1a\xe3\xe3\x46\x2e\x60\x95\x52\x2f\xe0\xaf\x54\xf7\x05\x57\xb0\xe2\x24\xb8\xe2\x02\x1a\xe9\x8a\x25\x98\x62\x2c\xb1\x9d\x72\x5c\x30\x59\x6f\xb0\x3e\x6e\xb3\x2a\x6e\xb5\x16\x6e\xb5\x02\x0e\xa0\xc8\x57\x13\x2c\x48\x1e\xf3\x0c\x39\x3f\x35\x51\x30\x10\x59\x64\x57\xdf\xd2\xcf\x3b\xb8\x89\x3a\xab\x82\xa1\xc2\x99\xd3\x36\xc0\xb3\xa0\xa1\xc4\x95\x44\x79\x96\x81\xa0\x0c\xbb\x05\xfd\x62\x19\x22\x9b\xbb\xc3\x01\xae\xad\x46\xf4\x0a\xc8\x2d\xcb\x17\xce\x10\xd9\xcd\x8d\x01\xb0\x6d\x71\x67\x60\x03\x81\x6b\x16\x21\x66\x8a\x8b\x39\xcc\x50\xe1\xca\x51\xc8\x13\x45\x9d\xa2\xdc\x9e\x2d\xf6\x8c\xee\x93\x71\xaa\x20\x37\x98\x6b\x6c\x98\x97\xc1\xf8\x6e\xb2\xc6\xb6\x39\xdf\xab\xf5\x93\xf1\x3b\xcd\x5d\xb7\x5e\xfc\x49\xb5\xee\xbc\xac\x20\xdf\x73\xc9\x85\x9a\xec\x1d\xce\x51\xf7\x74\xab\x10\x32\xae\x18\x45\x27\x6b\x1d\x0f\xce\xf1\xc8\x3d\x37\x3d\x24\x62\x19\x49\x26\x36\x68\x1d\xa5\xab\x6c\x59\xcd\xce\x72\xe5\xa0\x96\x30\x0e\x24\x9e\x1e\xca\x20\xe8\xe0\x3e\x61\xeb\x56\x67\x09\x44\xd0\xe3\xcc\xed\x6b\x2b\x08\x46\x02\x7b\x42\xf3\x1c\x6a\xd2\x5e\x8f\xda\x7b\xe3\x2f\x86\x7a\x77\xe7\x57\x44\x9d\x7f\xd3\x35\x4f\xba\xeb\x51\x7b\xef\x8a\xc7\xd3\xd6\x5a\xd0\xda\x79\xd2\xd4\x71\xb1\x4e\x9c\x94\xcd\xd7\x8b\x3c\xf1\x39\xdd\xfa\xba\x4d\xea\x82\x9c\xb2\xe6\xa5\x10\xbc\xd7\x5f\x93\x34\x14\x40\x4b\x91\x22\x2d\x92\x21\x0d\x86\x52\x9b\xbe\xcc\xc4\x16\xe4\x54\x60\x7d\xa0\x49\x1d\x28\x97\x41\xdf\x25\x4f\x53\x72\x0d\x74\xa0\x5c\x94\xdf\xd6\xa9\xbe\x1d\xb9\x9e\xab\xa9\xad\xba\x5f\xf3\x7d\x6d\xd3\x71\x46\x52\x11\x55\x62\x9b\x6e\xf7\xf6\x0f\x51\x59\x8c\xf9\xa7\x82\x28\x64\x4d\x55\xdb\x80\x72\x21\xa3\x42\xc0\x4b\xca\x92\xa3\xf9\x0a\xf8\xe1\xf1\xf9\xd7\x87\xdf\x9f\x5c\xdd\x05\x2f\x15\xcb\x93\x08\x84\xe0\xc2\x30\x6f\x5c\x37\xde\x5f\x9b\xcf\xff\x02\x00\x00\xff\xff\xf4\x93\xf1\x18\x24\x20\x00\x00")

func dataVisageV2JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV2Json,
		"data/visage-v2.json",
	)
}

func dataVisageV2Json() (*asset, error) {
	bytes, err := dataVisageV2JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v2.json", size: 8228, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV3Json = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x99\x5d\x6f\xb3\x36\x14\xc7\xaf\xc9\xa7\x78\x04\x77\xd3\xa3\x22\x2d\x77\xb9\x5e\x34\x4d\x9a\xd6\x4a\xed\xae\xa6\x09\x39\xe6\x94\x78\x05\xcc\x6c\x43\x9b\x55\xfd\xee\x13\x2f\x29\x06\x1f\x48\x6c\xe8\x93\x9b\x36\xca\xf9\xe7\xff\xc3\xe7\xf8\xe5\x00\xef\x1b\xcf\x97\x15\xf5\x77\xdf\x7c\xca\x63\xb8\xfb\xa7\x94\x8a\xe5\x77\xaa\x0a\x21\x4e\x20\xac\x98\x24\x09\x84\x34\x8b\xbb\x8f\xfe\xf7\x8d\xe7\x0b\x5e\x2a\x90\xfe\xee\xdb\x5f\x1b\xcf\x7b\xdf\x78\x9e\xe7\x17\x44\x29\x10\x79\xed\x13\x56\xdb\x50\x2a\x01\x24\x93\xe1\x33\x4f\x53\xfe\x0a\x71\xfd\x33\xcf\xf3\x73\x92\x41\x2d\x19\x7d\x9d\x81\x3a\xf2\xb8\x0e\xfc\xba\x7f\xf2\x37\x9e\xf7\xf1\xfd\x92\xf1\x8e\x1e\x49\x9e\x43\x3a\x32\x6e\xc3\xce\xb6\xa8\x9b\xb4\xb7\xe3\xa4\x54\xc7\x9f\x43\x9a\x32\xc8\x55\x7d\xb1\xcd\x87\x88\xc5\xa1\x00\x09\x2a\x92\x40\x05\xa8\x11\xcd\xf8\x5d\x80\x88\xfb\x8b\x78\xb8\x7f\xb4\xba\x8a\x8b\x34\x2a\x80\x28\x58\xcc\x09\x73\x78\xbd\xc8\xea\x35\x0b\xb2\xca\xc6\xd3\xca\xe4\xc8\x23\xff\x31\xa0\xb2\x88\xd1\xe4\xfd\x79\x1d\xaa\xfe\x0b\xb9\x62\xb4\x37\x31\x59\x02\xfe\x2d\x41\xaa\x00\x11\xdb\x0f\x2e\xe5\x09\xcb\x2f\xa2\x74\x95\xc3\x94\xa8\xff\x72\xc1\xfe\xbb\x6e\x4c\xba\xd2\x7e\x40\xa4\xde\x52\x2e\x73\x34\x95\xc3\x80\x52\x48\xc8\x78\xcf\x41\xb2\xa6\xa9\xec\x07\xa2\xf8\x0b\x5c\xae\x8c\xae\x5a\x50\x19\xa2\x18\xcf\x67\x67\xf8\x19\x18\x83\x54\x82\x9f\x0c\xe4\x2f\xfb\xdf\xf7\x4f\xfb\x59\xa8\xe9\x5d\x6d\x03\x96\xc7\xf0\x66\x9f\xa4\x03\x91\xc8\x6c\xaa\xb6\x81\x16\x70\x38\x4f\x9e\x81\xa8\x52\x18\x07\x55\xaf\x08\x46\x0a\x07\x86\x2c\xb3\x8c\x88\xd3\x34\x62\x28\xb0\x20\x24\x24\x03\x19\x2a\x5e\x98\xde\x4d\x28\xe8\x43\xd6\xae\xd3\x99\x69\xad\xdd\xf3\xc2\xf2\x04\x24\x76\x30\x75\x01\xd7\x29\x52\xb1\x18\xf8\x44\x3a\xda\x98\x5b\x3e\x3a\xdf\x89\x9e\xa6\x37\x77\xef\x6e\x3a\x02\xba\x1c\x3b\x73\xb7\x13\xad\x94\x20\x64\xb8\xab\xff\xd5\x5d\xc8\x21\xe5\xf4\x05\x49\x7c\xfb\xbd\x6b\xde\x51\x08\x3e\x98\x0e\xb4\xe2\x60\x66\x39\xae\xa7\xb3\x3d\x69\xc1\x2e\x39\xa6\xb5\xd3\x48\x86\x5d\xa7\x8b\x94\xab\x53\xac\x54\xaf\x31\x0f\x1f\xe7\x99\xb9\x4a\xe9\xec\x90\x2b\x55\xd1\x0e\xba\x62\x41\x8b\x52\x1e\x23\x59\x1e\x24\x15\xac\xa8\xcf\x5d\xa4\xa4\xa6\x66\xa5\xea\x9a\xc6\xf8\xb8\x91\x0b\x58\xa5\xd4\x0b\xf8\x2b\xd5\x7d\xc1\x15\xac\x38\x09\xae\xb8\x80\x46\xba\x62\x09\xa6\x18\x4b\x6c\xa7\x1c\x17\x4c\xd6\x1b\xac\x8f\xdb\xac\x8a\x5b\xad\x85\x5b\xad\x80\x03\x28\xf2\xd9\x04\x0b\x92\xc7\x3c\x43\xce\x4f\x4d\x14\x0c\x44\x16\xd9\xd5\xb7\xf4\xf3\x0e\x6e\xa2\xce\xaa\x60\xa8\x70\xe6\xb4\x0d\xf0\x2c\x68\x28\x71\x25\x51\x9e\x65\x20\x28\xc3\x6e\x41\x3f\x59\x86\xc8\xe6\xee\x70\x80\x6b\xab\x11\xbd\x00\x72\xcb\xf2\x89\x33\x44\x76\x73\x63\x00\x6c\x5b\xdc\x19\xd8\x40\xe0\x9a\x45\x88\x99\xe2\x62\x0e\x33\x54\xb8\x72\x14\xf2\x44\x51\xa7\x28\xb7\x67\x8b\x3d\xa3\xfb\x64\x9c\x2a\xc8\x0d\xe6\x1a\x1b\xe6\x65\x30\xbe\x9b\xac\xb1\x6d\xce\xf7\x6a\xfd\x64\xfc\x4a\x73\xd7\xad\x17\x7f\x52\xad\x3b\x2f\x2b\xc8\xd7\x5c\x72\xa1\x26\x7b\x87\x73\xd4\x3d\xdd\x2a\x84\x8c\x2b\x46\xd1\xc9\x5a\xc7\x83\x73\x3c\x72\xcf\x4d\x0f\x89\x58\x46\x92\x89\x0d\x5a\x47\xe9\x2a\x5b\x56\xb3\xb3\x5c\x39\xa8\x25\x8c\x03\x89\xa7\x87\x32\x08\x3a\xb8\x4f\xd8\xba\xd5\x59\x02\x11\xf4\x38\x73\xfb\xda\x0a\x82\x91\xc0\x9e\xd0\x3c\x87\x9a\xb4\xd7\xa3\xf6\xde\xf8\x8b\xa1\xde\xdd\xf9\x15\x51\xe7\xdf\x74\xcd\x93\xee\x7a\xd4\xde\xbb\xe2\xf1\xb4\xb5\x16\xb4\x76\x9e\x34\x75\x5c\xac\x13\x27\x65\xf3\xf5\x22\x4f\x7c\x4e\xb7\xbe\x6e\x93\xba\x20\xa7\xac\x79\x29\x04\x6f\xf5\xd7\x24\x0d\x05\xd0\x52\xa4\x48\x8b\x64\x48\x83\xa1\xd4\xa6\x2f\x33\xb1\x05\x39\x15\x58\x1f\x68\x52\x07\xca\x65\xd0\x37\xc9\xd3\x94\x5c\x03\x1d\x28\x17\xe5\xb7\x75\xaa\x6f\x47\xae\xe7\x6a\x6a\xab\xee\xd7\x7c\x5f\xdb\x74\x9c\x91\x54\x44\x95\xd8\xa6\xdb\xbd\xfd\x43\x54\x16\x63\xfe\xa9\x20\x0a\x59\x53\xd5\x36\xa0\x5c\xc8\xa8\x10\xf0\x9c\xb2\xe4\x68\xbe\x02\xbe\x7f\x78\xfa\xed\xfe\x8f\x47\x57\x77\xc1\x4b\xc5\xf2\x24\x02\x21\xb8\x30\xcc\x1b\xd7\x8d\xf7\xf7\xe6\xe3\xff\x00\x00\x00\xff\xff\x5e\xf1\x07\xa4\x24\x20\x00\x00")

func dataVisageV3JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV3Json,
		"data/visage-v3.json",
	)
}

func dataVisageV3Json() (*asset, error) {
	bytes, err := dataVisageV3JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v3.json", size: 8228, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _dataVisageV4Json = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xc4\x99\x5d\x8f\x9c\x36\x14\x86\xaf\x99\x5f\x11\xc1\x5d\x15\xc5\x52\x35\x57\x7b\xdd\x55\x55\xa9\xea\x46\xca\xf6\xaa\xaa\x90\xc7\x3e\xcb\xb8\x0b\x98\xda\x86\xec\x36\xca\x7f\xaf\xf8\x98\x60\xf0\x81\x19\x1b\x92\xbd\xd9\x45\x9c\x77\xde\x07\x9f\xe3\x2f\xcc\x97\x43\x14\xeb\x86\xc5\x77\xef\x62\x26\x39\x7c\xf8\xa7\xd6\x46\x94\x1f\x4c\x43\x80\x67\x40\x1a\xa1\x69\x06\x84\x15\x7c\xb8\x8c\xdf\x1f\xa2\x58\xc9\xda\x80\x8e\xef\xde\xfd\x75\x88\xa2\x2f\x87\x28\x8a\xe2\x8a\x1a\x03\xaa\x6c\x7d\x48\x73\x24\xda\x28\xa0\x85\x26\x4f\x32\xcf\xe5\x67\xe0\xed\xcf\xa2\x28\x2e\x69\x01\xad\x64\x76\xbb\x00\x73\x96\xbc\x0d\xfc\x7a\xff\x18\x1f\xa2\xe8\xeb\xfb\x6b\xc6\x77\xec\x4c\xcb\x12\xf2\x99\x71\x1f\x0e\xb6\x45\xdd\xb4\xbf\x5d\xad\x41\x69\x72\xd7\xfe\x4b\x73\x99\x89\x92\xb0\x33\x35\x33\xf7\xe6\x68\xdf\x0d\xc8\x81\x02\x26\x8b\x02\x4a\x0e\x9c\xd0\x86\x8a\x9c\x9e\x72\x70\x21\xb7\xc8\xb7\xd1\x67\xcc\x75\x95\x07\x4a\xd2\xda\x9c\x7f\x26\x2c\x17\x50\x9a\xb6\xe6\xdd\x45\x2a\x38\x51\xa0\xc1\xa4\x1a\x98\x02\x24\xad\xd3\xdf\x25\x88\x78\x7c\x88\x8f\x0f\x9f\xbc\x9e\xe2\x2a\x8d\x29\xa0\xc6\xcd\xab\x2f\x87\x94\xf0\xf9\x2a\x6b\xd4\x6c\xc8\xaa\x98\xd7\xcf\xe5\xe8\xb3\xfc\x31\xa0\xba\xe2\x68\xf2\xfe\xbc\x0d\xd5\xfe\x85\xd2\x08\x36\x9a\xb8\x2c\x05\xff\xd6\xa0\x4d\x82\x88\xfd\x1b\xd7\x8d\xee\xab\x28\x5b\x15\xd0\x25\xda\xbf\x52\x89\xff\x6e\x6b\x93\xad\xf4\x6f\x10\x6d\x67\xe6\xeb\x1c\x4b\x15\xd0\xa0\x1c\x32\x3a\x9f\xba\x91\xac\x59\x2a\xff\x86\x18\xf9\x0c\xd7\x2b\x63\xab\x36\x54\x86\x1a\x21\xcb\xd5\x1e\x7e\x01\x72\xd0\x46\xc9\x57\x07\xf9\xcb\xfd\xef\xf7\x8f\xf7\xab\x50\xd7\xbb\x39\x26\xa2\xe4\xf0\xe2\x9f\xa4\x13\xd5\x48\x6f\x6a\x8e\x89\x15\x08\x58\x14\x9e\x80\x9a\x5a\x39\x2b\xc2\xa8\x48\x66\x8a\x00\x86\xae\x8b\x82\xaa\xd7\x65\xc4\x54\xe0\x41\xc8\x68\x01\x9a\x18\x59\xb9\xde\x5d\x28\x19\x43\xde\xae\xcb\x99\xe9\xad\xc3\xf3\x22\xca\x0c\x34\xb6\x30\x0d\x81\xd0\x2e\xd2\x08\x0e\x72\x21\x1d\x7d\x2c\x2c\x1f\x83\xef\xc2\xd6\x70\x34\x0f\xdf\x24\x0e\x04\x74\x38\x0e\xe6\x61\x2b\x9a\xbd\xaf\x13\x9c\x9c\x72\xc9\x9e\x91\xc4\xf7\xf7\x43\xf3\x8e\x42\xf0\xc6\x0c\xa0\x1d\x1b\xb3\xca\x09\x5d\x9d\xfd\x49\x1b\x66\xc9\x39\xad\xef\x46\x9a\x0c\x2f\x0c\x48\xb9\x06\xc5\x4e\xf5\x9a\xf3\xf0\x76\x5e\x98\xbb\x94\xce\x0f\xb9\x53\x15\xfd\xa0\x3b\x16\xb4\xaa\xf5\x39\xd5\xf5\x49\x33\x25\xaa\x76\xdd\x45\x4a\xea\x6a\x76\xaa\xae\x6b\x8c\xb7\x1b\x79\x80\x5d\x4a\xbd\x81\xbf\x53\xdd\x37\x3c\xc1\x8e\x9d\xe0\x86\x07\xe8\xa4\x3b\x96\x60\x89\xb1\xc5\x76\xc9\x71\x43\x67\x7d\x83\xf1\xf1\x36\xa3\xe2\xad\xc6\xc2\x5b\x8d\x80\x13\x18\x3a\x9e\xab\xd0\x92\xcb\x02\x59\x3f\x2d\x51\x32\x11\x79\x64\xd7\x9e\xd2\x2f\x33\x38\x7a\x78\xd5\xa9\x92\xa9\x22\x98\xd3\x6f\x80\x57\x41\x53\x49\x28\xa9\x3b\x91\x52\x4c\x60\xaf\xa0\xdf\x58\x8e\xc8\xe7\xed\x70\x82\xeb\xab\x91\x3e\x03\xf2\xca\xf2\x0d\xe7\x88\xfc\xfa\xc6\x04\xd8\x6f\x71\x57\x60\x13\x41\x68\x16\x81\x0b\x23\xd5\x1a\x66\xaa\x08\xe5\x18\xe4\x60\xd6\xa6\x98\xb0\x23\xda\x91\x31\x5c\x39\xab\x0a\xf2\x82\xb9\xc7\x84\x79\x1d\x8c\xcf\x26\x7b\x4c\x9b\xeb\x7b\xb5\xb1\x33\x7e\x4f\xf3\xd0\xa9\x17\x3f\xf0\xb7\x9d\xb7\x15\xe4\xfb\x3c\x72\x65\x16\xf7\x0e\x97\x68\x78\xba\x0d\x81\x42\x1a\xc1\xd0\xce\xda\xc6\x93\x4b\x3c\x0d\xcf\xcd\x08\x49\x45\x41\xb3\x85\x09\xda\x46\xd9\x2a\x5f\x56\x37\xb3\xdc\xd8\xa8\x2d\x8c\x13\xe5\xcb\x4d\x99\x04\x03\xdc\x17\x6c\xc3\xea\xac\x81\x2a\x76\x5e\x79\x7d\xed\x05\xc9\x4c\xe0\x4f\xe8\xce\xa1\x16\xed\xed\xa8\xbf\x37\xfe\x7d\x6d\x74\x0f\xfe\xd2\x36\xf8\x77\xbb\xe6\x45\x77\x3b\xea\xef\xdd\x48\xbe\x6c\x6d\x05\xbd\x9d\x17\x4d\x03\x07\xeb\xc2\x4a\xd9\xdd\xde\xe4\x89\xf7\xe9\xde\x37\xac\x53\x57\xf4\xb5\xe8\x3e\x0a\xc1\x4b\x7b\x9b\xe6\x44\x01\xab\x55\x8e\x6c\x91\x1c\x69\x32\x95\xfa\xec\xcb\x5c\x6c\x45\x5f\x2b\x6c\x1f\xe8\x52\x27\xca\x6d\xd0\x17\x2d\xf3\x9c\xde\x02\x9d\x28\x37\xe5\xb7\x77\x6a\x5f\x47\x6e\xe7\x5a\x6a\xaf\xdd\xaf\xfb\xbd\xb6\xdb\x71\xa6\xda\x50\x53\x63\x93\xee\xf0\xf5\x0f\x51\x79\xb4\xf9\xa7\x8a\x1a\x64\x4c\x35\xc7\x84\x49\xa5\xd3\x4a\xc1\x53\x2e\xb2\xb3\xfb\x09\xf8\xe1\xe3\xe3\x6f\x0f\x7f\x7c\x0a\x75\x57\xb2\x36\xa2\xcc\x52\x50\x4a\x2a\xc7\xbc\x73\x3d\x44\x7f\x1f\xbe\xfe\x1f\x00\x00\xff\xff\x01\x8c\x16\x11\x6b\x21\x00\x00")

func dataVisageV4JsonBytes() ([]byte, error) {
	return bindataRead(
		_dataVisageV4Json,
		"data/visage-v4.json",
	)
}

func dataVisageV4Json() (*asset, error) {
	bytes, err := dataVisageV4JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "data/visage-v4.json", size: 8555, mode: os.FileMode(420), modTime: time.Unix(1420070400, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"data/almanac.json":                   dataAlmanacJson,
	"data/audrey.json":                    dataAudreyJson,
	"data/channels.json":                  dataChannelsJson,
	"data/cohesion.json":                  dataCohesionJson,
	"data/digestion.json":                 dataDigestionJson,
	"data/discovery.json":                 dataDiscoveryJson,
	"data/friendship.json":                dataFriendshipJson,
	"data/im-store.json":                  dataImStoreJson,
	"data/partnerships.json":              dataPartnershipsJson,
	"data/presence.json":                  dataPresenceJson,
	"data/pubsub-broker.json":             dataPubsubBrokerJson,
	"data/rails.json":                     dataRailsJson,
	"data/similar-channels.json":          dataSimilarChannelsJson,
	"data/skadi.json":                     dataSkadiJson,
	"data/streams-api.json":               dataStreamsApiJson,
	"data/tmi-api.json":                   dataTmiApiJson,
	"data/tmi-clue.json":                  dataTmiClueJson,
	"data/tmi-pubsub.json":                dataTmiPubsubJson,
	"data/tmi-room.json":                  dataTmiRoomJson,
	"data/users-service.json":             dataUsersServiceJson,
	"data/video-usher-api-find.json":      dataVideoUsherApiFindJson,
	"data/video-usher-api-usher.json":     dataVideoUsherApiUsherJson,
	"data/video-usher-api-video.json":     dataVideoUsherApiVideoJson,
	"data/video-usher-api-videoapi.json":  dataVideoUsherApiVideoapiJson,
	"data/video-usher-api-viewcount.json": dataVideoUsherApiViewcountJson,
	"data/videoshim.json":                 dataVideoshimJson,
	"data/visage-api.json":                dataVisageApiJson,
	"data/visage-kraken.json":             dataVisageKrakenJson,
	"data/visage-v1.json":                 dataVisageV1Json,
	"data/visage-v2.json":                 dataVisageV2Json,
	"data/visage-v3.json":                 dataVisageV3Json,
	"data/visage-v4.json":                 dataVisageV4Json,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"data": &bintree{nil, map[string]*bintree{
		"almanac.json":                   &bintree{dataAlmanacJson, map[string]*bintree{}},
		"audrey.json":                    &bintree{dataAudreyJson, map[string]*bintree{}},
		"channels.json":                  &bintree{dataChannelsJson, map[string]*bintree{}},
		"cohesion.json":                  &bintree{dataCohesionJson, map[string]*bintree{}},
		"digestion.json":                 &bintree{dataDigestionJson, map[string]*bintree{}},
		"discovery.json":                 &bintree{dataDiscoveryJson, map[string]*bintree{}},
		"friendship.json":                &bintree{dataFriendshipJson, map[string]*bintree{}},
		"im-store.json":                  &bintree{dataImStoreJson, map[string]*bintree{}},
		"partnerships.json":              &bintree{dataPartnershipsJson, map[string]*bintree{}},
		"presence.json":                  &bintree{dataPresenceJson, map[string]*bintree{}},
		"pubsub-broker.json":             &bintree{dataPubsubBrokerJson, map[string]*bintree{}},
		"rails.json":                     &bintree{dataRailsJson, map[string]*bintree{}},
		"similar-channels.json":          &bintree{dataSimilarChannelsJson, map[string]*bintree{}},
		"skadi.json":                     &bintree{dataSkadiJson, map[string]*bintree{}},
		"streams-api.json":               &bintree{dataStreamsApiJson, map[string]*bintree{}},
		"tmi-api.json":                   &bintree{dataTmiApiJson, map[string]*bintree{}},
		"tmi-clue.json":                  &bintree{dataTmiClueJson, map[string]*bintree{}},
		"tmi-pubsub.json":                &bintree{dataTmiPubsubJson, map[string]*bintree{}},
		"tmi-room.json":                  &bintree{dataTmiRoomJson, map[string]*bintree{}},
		"users-service.json":             &bintree{dataUsersServiceJson, map[string]*bintree{}},
		"video-usher-api-find.json":      &bintree{dataVideoUsherApiFindJson, map[string]*bintree{}},
		"video-usher-api-usher.json":     &bintree{dataVideoUsherApiUsherJson, map[string]*bintree{}},
		"video-usher-api-video.json":     &bintree{dataVideoUsherApiVideoJson, map[string]*bintree{}},
		"video-usher-api-videoapi.json":  &bintree{dataVideoUsherApiVideoapiJson, map[string]*bintree{}},
		"video-usher-api-viewcount.json": &bintree{dataVideoUsherApiViewcountJson, map[string]*bintree{}},
		"videoshim.json":                 &bintree{dataVideoshimJson, map[string]*bintree{}},
		"visage-api.json":                &bintree{dataVisageApiJson, map[string]*bintree{}},
		"visage-kraken.json":             &bintree{dataVisageKrakenJson, map[string]*bintree{}},
		"visage-v1.json":                 &bintree{dataVisageV1Json, map[string]*bintree{}},
		"visage-v2.json":                 &bintree{dataVisageV2Json, map[string]*bintree{}},
		"visage-v3.json":                 &bintree{dataVisageV3Json, map[string]*bintree{}},
		"visage-v4.json":                 &bintree{dataVisageV4Json, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
