// Code generated by protoc-gen-go.
// source: code.justin.tv/release/trace/pbmsg/transaction.proto
// DO NOT EDIT!

package pbmsg

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import code_justin_tv_release_trace_pbmsg_iana "code.justin.tv/release/trace/pbmsg/iana"
import code_justin_tv_release_trace_pbmsg_memcached "code.justin.tv/release/trace/pbmsg/memcached"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// HTTPMethod from public import code.justin.tv/release/trace/pbmsg/iana/iana.proto
type HTTPMethod code_justin_tv_release_trace_pbmsg_iana.HTTPMethod

var HTTPMethod_name = code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_name
var HTTPMethod_value = code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_value

func (x HTTPMethod) String() string {
	return (code_justin_tv_release_trace_pbmsg_iana.HTTPMethod)(x).String()
}
func (x HTTPMethod) Enum() *HTTPMethod {
	return (*HTTPMethod)((code_justin_tv_release_trace_pbmsg_iana.HTTPMethod)(x).Enum())
}
func (x *HTTPMethod) UnmarshalJSON(data []byte) error {
	return (*code_justin_tv_release_trace_pbmsg_iana.HTTPMethod)(x).UnmarshalJSON(data)
}

const HTTPMethod_UNKNOWN = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_UNKNOWN)
const HTTPMethod_GET = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_GET)
const HTTPMethod_HEAD = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_HEAD)
const HTTPMethod_POST = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_POST)
const HTTPMethod_PUT = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_PUT)
const HTTPMethod_DELETE = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_DELETE)
const HTTPMethod_CONNECT = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_CONNECT)
const HTTPMethod_OPTIONS = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_OPTIONS)
const HTTPMethod_TRACE = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_TRACE)
const HTTPMethod_PATCH = HTTPMethod(code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_PATCH)

// Command from public import code.justin.tv/release/trace/pbmsg/memcached/memcached.proto
type Command code_justin_tv_release_trace_pbmsg_memcached.Command

var Command_name = code_justin_tv_release_trace_pbmsg_memcached.Command_name
var Command_value = code_justin_tv_release_trace_pbmsg_memcached.Command_value

func (x Command) String() string {
	return (code_justin_tv_release_trace_pbmsg_memcached.Command)(x).String()
}
func (x Command) Enum() *Command {
	return (*Command)((code_justin_tv_release_trace_pbmsg_memcached.Command)(x).Enum())
}
func (x *Command) UnmarshalJSON(data []byte) error {
	return (*code_justin_tv_release_trace_pbmsg_memcached.Command)(x).UnmarshalJSON(data)
}

const Command_UNKNOWN_COMMAND = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_UNKNOWN_COMMAND)
const Command_SET = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_SET)
const Command_ADD = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_ADD)
const Command_REPLACE = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_REPLACE)
const Command_APPEND = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_APPEND)
const Command_PREPEND = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_PREPEND)
const Command_CAS = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_CAS)
const Command_GET = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_GET)
const Command_GETS = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_GETS)
const Command_DELETE = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_DELETE)
const Command_INCR = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_INCR)
const Command_DECR = Command(code_justin_tv_release_trace_pbmsg_memcached.Command_DECR)

// A Transaction groups together a collection of Calls into one
// tree. It provides access to the transaction_id which is shared by
// all of its constituent Calls.
type Transaction struct {
	// 128-bit identifier for the transaction, as set in
	// code.justin.tv.release.trace.pbmsg.Event messages: two 64-bit
	// integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,1,rep,packed,name=transaction_id" json:"transaction_id,omitempty"`
	// root stores the data on the root call of the transaction.
	Root *Call `protobuf:"bytes,2,opt,name=root" json:"root,omitempty"`
	// In some rare cases, the root client of a transaction may be
	// known. If that's the case, such data can be stored in the
	// optional client field.
	Client           *Service `protobuf:"bytes,3,opt,name=client" json:"client,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Transaction) Reset()                    { *m = Transaction{} }
func (m *Transaction) String() string            { return proto.CompactTextString(m) }
func (*Transaction) ProtoMessage()               {}
func (*Transaction) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *Transaction) GetTransactionId() []uint64 {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func (m *Transaction) GetRoot() *Call {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *Transaction) GetClient() *Service {
	if m != nil {
		return m.Client
	}
	return nil
}

// A Call represents a single RPC call out to a service in the
// distributed stack trace.
//
// The client of the call is not explicitly listed here. The client
// can instead be inferred from the entire Transaction's tree:
//
//   - If this is the root call in the RPC tree, then the Transaction
//     has an optional client field which lists the client if it sends
//     data to trace. If not, then the client can't be known.
//   - If this is non-root node, then it has a parent. The svc of the
//     parent call is the client of this call.
type Call struct {
	// subcalls are the subcalls that this call depended on, in path order.
	Subcalls []*Call `protobuf:"bytes,1,rep,name=subcalls" json:"subcalls,omitempty"`
	// path is the same path identifier as used in event.proto.
	Path []uint32 `protobuf:"varint,2,rep,packed,name=path" json:"path,omitempty"`
	// svc holds the identity of the service which served the RPC
	// call. This might be left unset if the service does not send data
	// to Trace.
	Svc *Service `protobuf:"bytes,3,opt,name=svc" json:"svc,omitempty"`
	// params are the parameters of the Call, like the HTTP URI or SQL
	// query. They may be filled by either client or server; the
	// server's log of its outbound request should be preferred if they
	// conflict, since server owners are responsible for maintaining
	// metadata about what RPCs they provide.
	Params *RPCParams `protobuf:"bytes,4,opt,name=params" json:"params,omitempty"`
	// client_timestamps and service_timestamps provide lists of timing
	// information accordiong to each side of the call. They will only
	// be available if the respective side is sending Trace data. They
	// will be sorted by increasing time values (earliest first, in
	// other words). It's guaranteed that at least one set of timestamps
	// will have at least one value.
	ClientTimestamps  []*Timestamp `protobuf:"bytes,5,rep,name=client_timestamps" json:"client_timestamps,omitempty"`
	ServiceTimestamps []*Timestamp `protobuf:"bytes,6,rep,name=service_timestamps" json:"service_timestamps,omitempty"`
	// request_sent_to is the host:port that the client established its
	// connection to to make the RPC. This is the client's perception,
	// and doesn't necessarily reflect where the server is actually
	// listening; proxies might be in between.
	RequestSentTo    *string `protobuf:"bytes,7,opt,name=request_sent_to" json:"request_sent_to,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (m *Call) String() string            { return proto.CompactTextString(m) }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *Call) GetSubcalls() []*Call {
	if m != nil {
		return m.Subcalls
	}
	return nil
}

func (m *Call) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Call) GetSvc() *Service {
	if m != nil {
		return m.Svc
	}
	return nil
}

func (m *Call) GetParams() *RPCParams {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Call) GetClientTimestamps() []*Timestamp {
	if m != nil {
		return m.ClientTimestamps
	}
	return nil
}

func (m *Call) GetServiceTimestamps() []*Timestamp {
	if m != nil {
		return m.ServiceTimestamps
	}
	return nil
}

func (m *Call) GetRequestSentTo() string {
	if m != nil && m.RequestSentTo != nil {
		return *m.RequestSentTo
	}
	return ""
}

// Service represents an application which is capable of handling RPC
// calls.
type Service struct {
	// The name of the service
	Name *string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The FQDN of the host that the service is running on
	Host *string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	// PID of the process
	Pid *int32 `protobuf:"zigzag32,3,opt,name=pid" json:"pid,omitempty"`
	// The ip:port sending the request to this service.
	Peer             *string `protobuf:"bytes,4,opt,name=peer" json:"peer,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *Service) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Service) GetHost() string {
	if m != nil && m.Host != nil {
		return *m.Host
	}
	return ""
}

func (m *Service) GetPid() int32 {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return 0
}

func (m *Service) GetPeer() string {
	if m != nil && m.Peer != nil {
		return *m.Peer
	}
	return ""
}

// Timestamp provides a marker for when something happened in a call.
type Timestamp struct {
	// time is when a call started, recorded as unix epoch
	// time in nanoseconds
	Time *int64 `protobuf:"fixed64,1,opt,name=time" json:"time,omitempty"`
	// kind describes what happened at the specified time
	Kind             *Event_Kind `protobuf:"varint,2,opt,name=kind,enum=code.justin.tv.release.trace.pbmsg.Event_Kind" json:"kind,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Timestamp) Reset()                    { *m = Timestamp{} }
func (m *Timestamp) String() string            { return proto.CompactTextString(m) }
func (*Timestamp) ProtoMessage()               {}
func (*Timestamp) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *Timestamp) GetTime() int64 {
	if m != nil && m.Time != nil {
		return *m.Time
	}
	return 0
}

func (m *Timestamp) GetKind() Event_Kind {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return Event_REQUEST_HEAD_RECEIVED
}

// RPCParams contains data on the details of the request that the
// client made.
type RPCParams struct {
	Http             *HTTPParams      `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
	Sql              *SQLParams       `protobuf:"bytes,2,opt,name=sql" json:"sql,omitempty"`
	Memcached        *MemcachedParams `protobuf:"bytes,3,opt,name=memcached" json:"memcached,omitempty"`
	Grpc             *GRPCParams      `protobuf:"bytes,4,opt,name=grpc" json:"grpc,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *RPCParams) Reset()                    { *m = RPCParams{} }
func (m *RPCParams) String() string            { return proto.CompactTextString(m) }
func (*RPCParams) ProtoMessage()               {}
func (*RPCParams) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *RPCParams) GetHttp() *HTTPParams {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *RPCParams) GetSql() *SQLParams {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *RPCParams) GetMemcached() *MemcachedParams {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *RPCParams) GetGrpc() *GRPCParams {
	if m != nil {
		return m.Grpc
	}
	return nil
}

type HTTPParams struct {
	// The path part of the URI of the request.
	UriPath *string `protobuf:"bytes,1,opt,name=uri_path" json:"uri_path,omitempty"`
	// HTTP Status code. Values less than zero indicate an error
	// observed by the client which caused it to give up on the request
	// before getting a status code from the server.
	Status *int32 `protobuf:"zigzag32,2,opt,name=status" json:"status,omitempty"`
	// Method of HTTP request.
	Method *code_justin_tv_release_trace_pbmsg_iana.HTTPMethod `protobuf:"varint,3,opt,name=method,enum=code.justin.tv.release.trace.pbmsg.iana.HTTPMethod" json:"method,omitempty"`
	// If we have sufficient data to give a name to the route, then that
	// human-readable name will be stored here.
	Route            *string `protobuf:"bytes,4,opt,name=route" json:"route,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *HTTPParams) Reset()                    { *m = HTTPParams{} }
func (m *HTTPParams) String() string            { return proto.CompactTextString(m) }
func (*HTTPParams) ProtoMessage()               {}
func (*HTTPParams) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *HTTPParams) GetUriPath() string {
	if m != nil && m.UriPath != nil {
		return *m.UriPath
	}
	return ""
}

func (m *HTTPParams) GetStatus() int32 {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return 0
}

func (m *HTTPParams) GetMethod() code_justin_tv_release_trace_pbmsg_iana.HTTPMethod {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return code_justin_tv_release_trace_pbmsg_iana.HTTPMethod_UNKNOWN
}

func (m *HTTPParams) GetRoute() string {
	if m != nil && m.Route != nil {
		return *m.Route
	}
	return ""
}

type SQLParams struct {
	// Name of the database where the query runs.
	Dbname *string `protobuf:"bytes,1,opt,name=dbname" json:"dbname,omitempty"`
	// Username used to connect to the database.
	Dbuser *string `protobuf:"bytes,2,opt,name=dbuser" json:"dbuser,omitempty"`
	// Query string with all user data removed.
	StrippedQuery *string `protobuf:"bytes,3,opt,name=stripped_query" json:"stripped_query,omitempty"`
	// List of tables directly referenced in the query.
	Tables           []string `protobuf:"bytes,4,rep,name=tables" json:"tables,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *SQLParams) Reset()                    { *m = SQLParams{} }
func (m *SQLParams) String() string            { return proto.CompactTextString(m) }
func (*SQLParams) ProtoMessage()               {}
func (*SQLParams) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *SQLParams) GetDbname() string {
	if m != nil && m.Dbname != nil {
		return *m.Dbname
	}
	return ""
}

func (m *SQLParams) GetDbuser() string {
	if m != nil && m.Dbuser != nil {
		return *m.Dbuser
	}
	return ""
}

func (m *SQLParams) GetStrippedQuery() string {
	if m != nil && m.StrippedQuery != nil {
		return *m.StrippedQuery
	}
	return ""
}

func (m *SQLParams) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

type MemcachedParams struct {
	// The command sent to memcached by a client
	Command *code_justin_tv_release_trace_pbmsg_memcached.Command `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.pbmsg.memcached.Command" json:"command,omitempty"`
	// The number of keys in the client's request
	NKeysRequest *uint32 `protobuf:"varint,2,opt,name=n_keys_request" json:"n_keys_request,omitempty"`
	// The number of keys in the server's response
	NKeysResponse    *uint32 `protobuf:"varint,3,opt,name=n_keys_response" json:"n_keys_response,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *MemcachedParams) Reset()                    { *m = MemcachedParams{} }
func (m *MemcachedParams) String() string            { return proto.CompactTextString(m) }
func (*MemcachedParams) ProtoMessage()               {}
func (*MemcachedParams) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *MemcachedParams) GetCommand() code_justin_tv_release_trace_pbmsg_memcached.Command {
	if m != nil && m.Command != nil {
		return *m.Command
	}
	return code_justin_tv_release_trace_pbmsg_memcached.Command_UNKNOWN_COMMAND
}

func (m *MemcachedParams) GetNKeysRequest() uint32 {
	if m != nil && m.NKeysRequest != nil {
		return *m.NKeysRequest
	}
	return 0
}

func (m *MemcachedParams) GetNKeysResponse() uint32 {
	if m != nil && m.NKeysResponse != nil {
		return *m.NKeysResponse
	}
	return 0
}

type GRPCParams struct {
	// Fully-qualified method name, including proto package name,
	// service name, and method name.
	Method           *string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GRPCParams) Reset()                    { *m = GRPCParams{} }
func (m *GRPCParams) String() string            { return proto.CompactTextString(m) }
func (*GRPCParams) ProtoMessage()               {}
func (*GRPCParams) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *GRPCParams) GetMethod() string {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return ""
}

func init() {
	proto.RegisterType((*Transaction)(nil), "code.justin.tv.release.trace.pbmsg.Transaction")
	proto.RegisterType((*Call)(nil), "code.justin.tv.release.trace.pbmsg.Call")
	proto.RegisterType((*Service)(nil), "code.justin.tv.release.trace.pbmsg.Service")
	proto.RegisterType((*Timestamp)(nil), "code.justin.tv.release.trace.pbmsg.Timestamp")
	proto.RegisterType((*RPCParams)(nil), "code.justin.tv.release.trace.pbmsg.RPCParams")
	proto.RegisterType((*HTTPParams)(nil), "code.justin.tv.release.trace.pbmsg.HTTPParams")
	proto.RegisterType((*SQLParams)(nil), "code.justin.tv.release.trace.pbmsg.SQLParams")
	proto.RegisterType((*MemcachedParams)(nil), "code.justin.tv.release.trace.pbmsg.MemcachedParams")
	proto.RegisterType((*GRPCParams)(nil), "code.justin.tv.release.trace.pbmsg.GRPCParams")
}

var fileDescriptor2 = []byte{
	// 620 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x54, 0xcf, 0x6f, 0xd3, 0x3e,
	0x1c, 0xfd, 0xa6, 0xed, 0xda, 0xe5, 0xd3, 0x6f, 0xb3, 0xce, 0x07, 0x88, 0x26, 0x0e, 0x53, 0x4e,
	0x95, 0x10, 0x99, 0x54, 0x7e, 0x08, 0x8d, 0x21, 0xa1, 0x55, 0x8c, 0x21, 0x98, 0x54, 0x58, 0x25,
	0x24, 0x2e, 0x91, 0x9b, 0x58, 0x6b, 0x58, 0x12, 0x7b, 0xb6, 0x53, 0x69, 0x57, 0x8e, 0xf0, 0x3f,
	0xf0, 0x8f, 0x72, 0xc1, 0xf9, 0x24, 0x5b, 0x0a, 0x17, 0xcc, 0x2e, 0x55, 0x5c, 0xe7, 0xbd, 0xcf,
	0x7b, 0xcf, 0xcf, 0x81, 0x27, 0x31, 0x4f, 0x58, 0xf8, 0xa5, 0x54, 0x3a, 0x2d, 0x42, 0xbd, 0x3e,
	0x90, 0x2c, 0x63, 0x54, 0xb1, 0x03, 0x2d, 0x69, 0xcc, 0x0e, 0xc4, 0x32, 0x57, 0x17, 0xd5, 0x73,
	0xa1, 0x68, 0xac, 0x53, 0x5e, 0x84, 0x42, 0x72, 0xcd, 0x49, 0xf0, 0x3b, 0x2a, 0x6c, 0x50, 0x21,
	0xa2, 0x42, 0x44, 0xed, 0x4d, 0x2d, 0x98, 0x53, 0x5a, 0x50, 0xfc, 0xa9, 0x79, 0xf7, 0x8e, 0x2c,
	0x30, 0x39, 0xcb, 0x63, 0x1a, 0xaf, 0x58, 0xd2, 0x3e, 0x35, 0xe8, 0xd0, 0x02, 0xcd, 0xd6, 0xac,
	0xd0, 0xf5, 0xfb, 0xc1, 0x0f, 0x07, 0x86, 0x8b, 0xd6, 0x1b, 0xd9, 0x03, 0x6f, 0xc3, 0x6a, 0x94,
	0x26, 0xbe, 0xb3, 0xdf, 0x9d, 0xf4, 0x8f, 0x3b, 0x63, 0x87, 0x3c, 0x83, 0x9e, 0xe4, 0x5c, 0xfb,
	0x9d, 0x7d, 0x67, 0x32, 0x9c, 0x4e, 0xc2, 0xbf, 0x07, 0x10, 0xce, 0x68, 0x96, 0x91, 0x17, 0xd0,
	0x8f, 0xb3, 0xd4, 0xcc, 0xf4, 0xbb, 0x88, 0x7c, 0x68, 0x83, 0x3c, 0x67, 0x72, 0x9d, 0xc6, 0x2c,
	0xf8, 0xd9, 0x81, 0x1e, 0xb2, 0x1c, 0xc2, 0xb6, 0x2a, 0x97, 0xb1, 0x79, 0x54, 0xa8, 0xe9, 0x5f,
	0x14, 0x8c, 0xa1, 0x27, 0xa8, 0x5e, 0x19, 0xe5, 0xdd, 0xc9, 0x08, 0xbd, 0x3c, 0x87, 0xae, 0x5a,
	0xc7, 0x77, 0x10, 0x44, 0x5e, 0x42, 0x5f, 0x50, 0x49, 0x73, 0xe5, 0xf7, 0x10, 0xfc, 0xc8, 0x06,
	0xfc, 0x71, 0x3e, 0x9b, 0x23, 0x88, 0x9c, 0xc2, 0x6e, 0x1d, 0x46, 0xa4, 0xd3, 0x9c, 0x29, 0x4d,
	0x73, 0xa1, 0xfc, 0x2d, 0xf4, 0x63, 0xc5, 0xb4, 0xb8, 0x41, 0x91, 0xb7, 0x40, 0x54, 0xad, 0x69,
	0x93, 0xaa, 0x7f, 0x17, 0xaa, 0xfb, 0xb0, 0x23, 0xd9, 0x55, 0x69, 0x56, 0x91, 0x42, 0x69, 0xdc,
	0x1f, 0x18, 0x73, 0x6e, 0xf0, 0x0a, 0x06, 0x37, 0xbe, 0xff, 0x87, 0x5e, 0x41, 0x73, 0x66, 0xb2,
	0x37, 0x1b, 0xd5, 0x6a, 0xc5, 0x55, 0xdd, 0x05, 0x97, 0x0c, 0xa1, 0x2b, 0x4c, 0x55, 0xaa, 0x34,
	0x77, 0xab, 0x2d, 0xc1, 0x98, 0xc4, 0x78, 0xdc, 0xe0, 0x13, 0xb8, 0xed, 0x1c, 0xb3, 0x55, 0x49,
	0x45, 0x8e, 0x31, 0x39, 0x82, 0xde, 0x65, 0x5a, 0x24, 0xc8, 0xe1, 0x4d, 0x43, 0x1b, 0xc9, 0xaf,
	0xb1, 0xba, 0xef, 0x0c, 0x2a, 0xf8, 0xde, 0x01, 0xb7, 0x8d, 0xd5, 0x70, 0xad, 0xb4, 0x16, 0xc8,
	0x3c, 0xb4, 0xe3, 0x3a, 0x5d, 0x2c, 0xe6, 0x0d, 0xfa, 0xd0, 0xb4, 0xe1, 0x2a, 0x6b, 0x8a, 0x6d,
	0x95, 0xdd, 0xf9, 0x87, 0xf7, 0x0d, 0xf6, 0x04, 0xdc, 0xdb, 0x4b, 0xd8, 0xf4, 0xe9, 0xb1, 0x0d,
	0xc3, 0xd9, 0x0d, 0xa8, 0x75, 0x70, 0x21, 0x45, 0xdc, 0xb4, 0xca, 0xca, 0xc1, 0x9b, 0x5b, 0xff,
	0xc1, 0x57, 0x07, 0x60, 0xc3, 0xd0, 0x18, 0xb6, 0x4b, 0x99, 0x46, 0x58, 0xfa, 0xfa, 0xc0, 0x3c,
	0xe8, 0x9b, 0x33, 0xd0, 0xa5, 0x42, 0x97, 0xbb, 0x64, 0x06, 0xfd, 0x9c, 0xe9, 0x15, 0xaf, 0x35,
	0x7b, 0x76, 0x9a, 0xf1, 0x33, 0x55, 0x8d, 0x39, 0x43, 0x28, 0x19, 0xc1, 0x96, 0xe4, 0xa5, 0x66,
	0xcd, 0x59, 0x9f, 0x83, 0xdb, 0xe6, 0x62, 0x06, 0x26, 0xcb, 0x8d, 0xc6, 0xe0, 0xba, 0x34, 0x8d,
	0x6d, 0x3a, 0x73, 0x0f, 0x3c, 0xa5, 0x65, 0x2a, 0x04, 0x4b, 0x22, 0x53, 0x3d, 0x79, 0x8d, 0x42,
	0xf0, 0x3d, 0x4d, 0x97, 0x19, 0xab, 0xee, 0x57, 0xd7, 0x90, 0x7e, 0x73, 0x60, 0xe7, 0xcf, 0xac,
	0x4e, 0x60, 0x10, 0xf3, 0x3c, 0xa7, 0x45, 0x82, 0xe4, 0xde, 0xf4, 0xa9, 0x8d, 0xfa, 0xf6, 0x5b,
	0x39, 0xab, 0xc1, 0x95, 0x86, 0x22, 0xba, 0x64, 0xd7, 0x2a, 0x6a, 0xea, 0x8f, 0xda, 0x46, 0xd5,
	0x7d, 0xb8, 0xfd, 0x5f, 0x09, 0x5e, 0x28, 0x86, 0xe2, 0x46, 0xc1, 0x03, 0x80, 0x36, 0xf4, 0x4a,
	0x6a, 0x93, 0x21, 0x5a, 0x3c, 0x1e, 0x7c, 0xde, 0xc2, 0x49, 0xf3, 0xff, 0xe6, 0xce, 0xaf, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x16, 0x58, 0x4b, 0xcb, 0x56, 0x06, 0x00, 0x00,
}
