pg-healthcheck
==============

Health-check daemon for postgresql intended to provide a better HAProxy
"is the service up?" health check.

This daemon will periodically issue a postgresql `select 1` to the
host and ports provided and expose an HTTP endpoint which returns `200
OK` if the the postgresql backend is responding without error to the
query. If something goes wrong, the HTTP endpoint will return an error
code.

Usage
-----

To use this package, you generally want to run it on the same host as
postgres or pgbouncer. For example, to connect to a typical pgbouncer:

    ./pg-healthcheck -database=justintv_dev -port=6543 -port=6544


API
---

Issue an HTTP GET to an URL of the form
`http://$pgh-host:$pgh-port/$be-port`. For example, to locally check if the
pgbouncer listening on port 6543 is running:

    curl -v http://localhost:6545/port/6543

If pg-healthcheck believes postgresql is running and servicing
requests modulo time boundary parameters passed in, you the service
will return `200 OK` with a payload similar to:

    Healthy. Last checked at 2015-01-06 15:31:35.241530978 -0800 PST.

If pg-healthcheck believes the service is not in a state to
service new clients, the service will return some kind of `5xx` error
with a message.
