package common

import (
	"log"
)

//Closeable is anything with the close method, since a lot of things use that pattern
type Closeable interface {
	Close() error
}

//CloseResource is a util method for closing a thing.
//A lot of things need to be defer thing.Close()'d, but we want to capture & log errors from that
func CloseResource(resource Closeable) {
	err := resource.Close()
	if err != nil {
		log.Println(err)
	}
}
