package common

import (
	"database/sql"
	"time"
)

//BackendChecker is what the healthcheck rig hits to determine the current
//health or unhealth of the backend.  Really, we end up chaining a ton of these
//to add different capabilities (logging, statsd, etc.) to the checker process
type BackendChecker interface {
	Check() (healthyMsg string, err error)
	Open() (*sql.DB, error)
}

//StatsTracker is a cache for the current state of the backend.  We tend to
//hit this when a client requests the status and then update it as the backend
//checker has new information
type StatusTracker interface {
	Status(port int) (status Status, err error)
	MarkDown(port int, reason string) error
	MarkUp(port int, reason string) error
}

//The backend status for a single point in time
type Status interface {
	Ok() bool
	At() time.Time
	Message() string
}
