package common

import (
	"fmt"
	"time"
)

type status struct {
	at  time.Time
	ok  bool
	msg string
}

func NewStatus(ok bool, msg string, at time.Time) Status {
	status := new(status)
	status.at = at
	status.ok = ok
	status.msg = msg
	return status
}

func (s *status) Ok() bool {
	return s.ok
}

func (s *status) Message() string {
	return s.msg
}

func (s *status) At() time.Time {
	return s.at
}

func (s *status) String() string {
	msg := "ok"
	if !s.ok {
		msg = "bad"
	}
	return fmt.Sprintf("%v: '%v' at %v", msg, s.msg, s.at)
}
