package main

import (
	"database/sql"
	"log"

	_ "github.com/lib/pq"

	"code.justin.tv/d8a/pg-healthcheck/common"
)

func NewLogProxy(innerBackend common.BackendChecker) common.BackendChecker {
	return &logProxy{innerBackend: innerBackend}
}

type logProxy struct {
	innerBackend common.BackendChecker
}

func (lp *logProxy) Check() (string, error) {
	healthy, err := lp.innerBackend.Check()

	if err != nil {
		log.Println(err)
	}

	return healthy, err
}

func (lp *logProxy) Open() (*sql.DB, error) {
	return lp.innerBackend.Open()
}
