DROP FUNCTION pg_antifreeze(IN relid regclass, IN startblock bigint);
CREATE FUNCTION pg_antifreeze(IN relid regclass)
RETURNS VOID
AS 'MODULE_PATHNAME', 'pg_antifreeze'
LANGUAGE C STRICT;
COMMENT ON FUNCTION pg_antifreeze(regclass) IS
'scans a table, removing any multixact that''s oldest than
vacuum_multixact_min_age.  TransactionIds are also tested: any page
that must be dirtied for other reasons also has its old Xids frozen,
but we skip that if we can (i.e. we skip it if there are no multixacts
worth pruning).';

