-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION antifreeze" to load this file. \quit

CREATE FUNCTION pg_antifreeze(IN relid regclass)
RETURNS VOID
AS 'MODULE_PATHNAME', 'pg_antifreeze'
LANGUAGE C STRICT;
COMMENT ON FUNCTION pg_antifreeze(regclass) IS
'scans a table, removing any multixact that''s oldest than
vacuum_multixact_min_age.  TransactionIds are also tested: any page
that must be dirtied for other reasons also has its old Xids frozen,
but we skip that if we can (i.e. we skip it if there are no multixacts
worth pruning).';

CREATE FUNCTION pg_update_datfrozenxid()
RETURNS VOID
AS 'MODULE_PATHNAME', 'pg_update_datfrozenxid'
LANGUAGE C STRICT;
COMMENT ON FUNCTION pg_update_datfrozenxid() IS
'Scans pg_class, determines the oldest relfrozenxid and relminmxid, and
update the pg_database attributes accordingly';
