package avro

var goodBooleans map[bool][]byte = map[bool][]byte{
	false: []byte{0x00},
	true:  []byte{0x01},
}

var badBooleans map[error][]byte = map[error][]byte{
	InvalidBool: []byte{0x02},
}

var goodInts map[int32][]byte = map[int32][]byte{
	27:        []byte{0x36},
	-8:        []byte{0x0F},
	-1:        []byte{0x01},
	0:         []byte{0x00},
	1:         []byte{0x02},
	-64:       []byte{0x7F},
	64:        []byte{0x80, 0x01},
	123456789: []byte{0xAA, 0xB4, 0xDE, 0x75},
	987654321: []byte{0xE2, 0xA2, 0xF3, 0xAD, 0x07},
}

var goodLongs map[int64][]byte = map[int64][]byte{
	27:                   []byte{0x36},
	-8:                   []byte{0x0F},
	-1:                   []byte{0x01},
	0:                    []byte{0x00},
	1:                    []byte{0x02},
	-64:                  []byte{0x7F},
	64:                   []byte{0x80, 0x01},
	123456789:            []byte{0xAA, 0xB4, 0xDE, 0x75},
	987654321:            []byte{0xE2, 0xA2, 0xF3, 0xAD, 0x07},
	9223372036854775807:  []byte{0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01},
	-9223372036854775808: []byte{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01},
	-5468631321897454687: []byte{0xBD, 0xB1, 0xAE, 0xD4, 0xD2, 0xCD, 0xBD, 0xE4, 0x97, 0x01},
}

var goodFloats map[float32][]byte = map[float32][]byte{
	0.0:            []byte{0x00, 0x00, 0x00, 0x00},
	1.0:            []byte{0x00, 0x00, 0x80, 0x3F},
	1.15:           []byte{0x33, 0x33, 0x93, 0x3F},
	-53.964:        []byte{0x23, 0xDB, 0x57, 0xC2},
	-123456789.123: []byte{0xA3, 0x79, 0xEB, 0xCC},
	987654.111115:  []byte{0x62, 0x20, 0x71, 0x49},
}

var goodDoubles map[float64][]byte = map[float64][]byte{
	0.0:                                  []byte{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	1.0:                                  []byte{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F},
	1.15:                                 []byte{0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xF2, 0x3F},
	-53.964:                              []byte{0x08, 0xAC, 0x1C, 0x5A, 0x64, 0xFB, 0x4A, 0xC0},
	-123456789.123:                       []byte{0xB6, 0xF3, 0x7D, 0x54, 0x34, 0x6F, 0x9D, 0xC1},
	987654.111115:                        []byte{0xB6, 0x10, 0xE4, 0x38, 0x0C, 0x24, 0x2E, 0x41},
	123456789.123456789:                  []byte{0x75, 0x6B, 0x7E, 0x54, 0x34, 0x6F, 0x9D, 0x41},
	9999999.99999999999999999999999:      []byte{0x00, 0x00, 0x00, 0x00, 0xD0, 0x12, 0x63, 0x41},
	916734926348163.01973408746523:       []byte{0x18, 0xFC, 0x1A, 0xDD, 0x1F, 0x0E, 0x0A, 0x43},
	-267319348967891263.1928357138913857: []byte{0x0A, 0x8F, 0xA6, 0x40, 0xAC, 0xAD, 0x8D, 0xC3},
}

var goodBytes = [][]byte{
	[]byte{0x02, 0x02},
	[]byte{0x04, 0x03, 0xFF},
	[]byte{0x08, 0xEC, 0xAB, 0x44, 0x00},
	[]byte{0x0C, 0xAC, 0xDC, 0x01, 0x00, 0x10, 0x0F},
}

var badBytes [][]interface{} = [][]interface{}{
	[]interface{}{EOF, []byte(nil)},                                    //empty array with no length
	[]interface{}{NegativeBytesLength, []byte{0x05, 0x03, 0xFF, 0x0A}}, //negative length
	[]interface{}{EOF, []byte{0x08, 0xFF}},                             //length > array size
}

var goodStrings map[string][]byte = map[string][]byte{
	"":                     []byte{0x00},
	"foo":                  []byte{0x06, 0x66, 0x6F, 0x6F},
	"avro":                 []byte{0x08, 0x61, 0x76, 0x72, 0x6F},
	"apache":               []byte{0x0C, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65},
	"oppan gangnam style!": []byte{0x28, 0x6F, 0x70, 0x70, 0x61, 0x6E, 0x20, 0x67, 0x61, 0x6E, 0x67, 0x6E, 0x61, 0x6D, 0x20, 0x73, 0x74, 0x79, 0x6C, 0x65, 0x21},
	"че-то по русски":      []byte{0x36, 0xD1, 0x87, 0xD0, 0xB5, 0x2D, 0xD1, 0x82, 0xD0, 0xBE, 0x20, 0xD0, 0xBF, 0xD0, 0xBE, 0x20, 0xD1, 0x80, 0xD1, 0x83, 0xD1, 0x81, 0xD1, 0x81, 0xD0, 0xBA, 0xD0, 0xB8},
	"世界":                   []byte{0x0C, 0xE4, 0xB8, 0x96, 0xE7, 0x95, 0x8C},
	"!№;%:?*\"()@#$^&":     []byte{0x22, 0x21, 0xE2, 0x84, 0x96, 0x3B, 0x25, 0x3A, 0x3F, 0x2A, 0x22, 0x28, 0x29, 0x40, 0x23, 0x24, 0x5E, 0x26},
}

var badStrings [][]interface{} = [][]interface{}{
	[]interface{}{EOF, []byte(nil)},                                          //empty array with no length
	[]interface{}{InvalidStringLength, []byte{0x05, 0x66, 0x6F, 0x6F, 0x6F}}, //negative length
	[]interface{}{EOF, []byte{0x08, 0x66}},                                   //length > array size
}
