##
# Sets up the Group for Twitch Developers
##

# Create group
resource "aws_iam_group" "developers" {
	name = "developers"
}

# Attach resource policy
resource "aws_iam_policy_attachment" "developers_full" {
	name = "developers_full"
	groups = ["${aws_iam_group.developers.name}"]
	policy_arn = "${module.full_global.arn}"
}

# Memberships
resource "aws_iam_group_membership" "developers" {
	name = "developers"
	users = [
		"${aws_iam_user.abrash.name}",
		"${aws_iam_user.dlin.name}",
		"${aws_iam_user.will.name}",
		"${aws_iam_user.mstith.name}",
		"${aws_iam_user.cc.name}",
		"${aws_iam_user.swang.name}",
		]
	group = "${aws_iam_group.developers.name}"
}

