##
# Administrators of IAM
##

# Create read-only policy
module "iam_admin" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/policies/iam/admin/"
}

# Create IAM administrators group
resource "aws_iam_group" "iam_admins" {
	name = "iam_admins"
}

# Attach group and policy
resource "aws_iam_policy_attachment" "iam_admins" {
	name = "iam_admins"
	groups = ["${aws_iam_group.iam_admins.name}"]
	policy_arn = "${module.iam_admin.arn}"
}

# Memberships
resource "aws_iam_group_membership" "iam_admins" {
	name = "iam_admins"
	users = [
		"${aws_iam_user.abrash.name}",
		"${aws_iam_user.dlin.name}",
		"${aws_iam_user.will.name}",
		"${aws_iam_user.mstith.name}",
		"${aws_iam_user.cc.name}",
		]
	group = "${aws_iam_group.iam_admins.name}"
}
