##
# Sets up the Group for RedisLabs Developers
##

# Create group
resource "aws_iam_group" "redislabs" {
  name = "redislabs"
}

# Attach resource policy
resource "aws_iam_policy_attachment" "redislabs" {
  name = "redislabs"
  groups = ["${aws_iam_group.redislabs.name}"]
  policy_arn = "${aws_iam_policy.redislabs_policy.arn}"
}

# Attach IAM policy
resource "aws_iam_policy_attachment" "redislabs_manage_own_credentials" {
  name = "redislabs_manage_own_credentials"
  groups = [
    "${aws_iam_group.redislabs.name}",
    "${aws_iam_group.developers.name}",
    "${aws_iam_group.redislabs-cluster4.name}",
  ]
  policy_arn = "arn:aws:iam::673337243802:policy/Manage_Own_Credentials"
}

# Memberships
resource "aws_iam_group_membership" "redislabs" {
  name = "redislabs_group"
  users = [
    "${aws_iam_user.redislabs-cluster.name}",

    "${aws_iam_user.avner.name}",
    "${aws_iam_user.eran.name}",
    "${aws_iam_user.igor_zilberman.name}",
    "${aws_iam_user.michael_lev.name}",
    "${aws_iam_user.ran.name}",
    "${aws_iam_user.yaron.name}",
    "${aws_iam_user.yuri.name}",
    ]
  group = "${aws_iam_group.redislabs.name}"
}

# Modern cluster management
# This setup was requested by redislabs for managing their new clusters on 2017-06-27

resource "aws_iam_group" "redislabs-cluster4" {
  name = "redislabs4"
}
resource "aws_iam_policy_attachment" "redislabs-cluster4" {
  name = "redislab-cluster4"
  groups = [
    "${aws_iam_group.redislabs-cluster4.name}",
  ]
  policy_arn = "${aws_iam_policy.redislabs-cluster4-policy.arn}"
}
resource "aws_iam_group_membership" "redislabs-cluster4" {
  name = "redislabs-cluster4"
  users = [
    "${aws_iam_user.redislabs-cluster4.name}",
  ]
  group = "${aws_iam_group.redislabs-cluster4.name}"
}
