# Full access minus IAM
module "full_global" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/policies/full/global/"
  #source = "../../../../../web/terraform/modules/policies/full/global/"
}

data "template_file" "redislabs_policy_tpl" {
  template = "${file("redislabs_policy.tpl")}"
}

resource "aws_iam_policy" "redislabs_policy" {
    name = "redislabs_policy"
    description = "Gives access to all ec2, all r53 and s3 read only resources"
    policy = "${data.template_file.redislabs_policy_tpl.rendered}"
}

output "arn" {
  value = "${aws_iam_policy.redislabs_policy.arn}"
}

data "template_file" "redislabs-cluster4-policy_tpl" {
  template = "${file("redislabs-cluster4-policy.tpl")}"
}

resource "aws_iam_policy" "redislabs-cluster4-policy" {
    name = "redislabs-cluster4-policy"
    description = "Access policies requested fro cluster management"
    policy = "${data.template_file.redislabs-cluster4-policy_tpl.rendered}"
}
