{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "ec2:Describe*",
        "ec2:CreateKeyPair",
        "ec2:DeleteKeyPair",
        "ec2:ImportKeyPair"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "cloudWath",
      "Effect": "Allow",
      "Action": [
        "cloudwatch:*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "CreateDescTags",
      "Effect": "Allow",
      "Action": [
        "ec2:CreateTags",
        "ec2:DescribeTags"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "CreateSGAndVolumeAllow",
      "Effect": "Allow",
      "Action": [
        "ec2:CreateSecurityGroup",
        "ec2:CreateVolume",
        "ec2:DescribeVolumes",
        "ec2:AttachVolume"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "NeededIAMForChef",
      "Effect": "Allow",
      "Action": [
        "iam:PassRole",
        "iam:ListInstanceProfiles"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "NeededEC2ForChef",
      "Effect": "Allow",
      "Action": [
        "ec2:RunInstances"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "OnlyCreateVPCNoDelete",
      "Effect": "Allow",
      "Action": [
        "ec2:CreateVpc",
        "ec2:*Subnet*",
        "ec2:CreateInternetGateway",
        "ec2:AttachInternetGateway",
        "ec2:*Vpn*",
        "ec2:*Route*",
        "ec2:*Address*",
        "ec2:CreateSecurityGroup",
        "ec2:AuthorizeSecurityGroupIngress",
        "ec2:AuthorizeSecurityGroupEgress",
        "ec2:*NetworkAcl*",
        "ec2:*DhcpOptions*"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Sid": "RoleAccessInstancesAllowBasedOnTag",
      "Effect": "Allow",
      "Action": [
        "iam:PassRole",
        "iam:ListInstanceProfiles"
      ],
      "Resource": [
        "arn:aws:ec2:*:673337243802:instance/*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "VPCAccessWithTAG",
      "Effect": "Allow",
      "Action": [
        "ec2:*Vpc*",
        "ec2:*Subnet*",
        "ec2:*Gateway*",
        "ec2:*Vpn*",
        "ec2:*Route*",
        "ec2:*Address*",
        "ec2:*SecurityGroup*",
        "ec2:*NetworkAcl*",
        "ec2:*DhcpOptions*",
        "ec2:RunInstances",
        "ec2:StartInstances",
        "ec2:Describe*"
      ],
      "Resource": [
        "*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "ec2MinorActionsOnlyWithTag",
      "Effect": "Allow",
      "Action": [
        "ec2:RevokeSecurityGroupEgress",
        "ec2:RevokeSecurityGroupIngress"
      ],
      "Resource": [
        "*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "AllowIngressSG",
      "Effect": "Allow",
      "Action": [
        "ec2:AuthorizeSecurityGroupEgress",
        "ec2:AuthorizeSecurityGroupIngress"
      ],
      "Resource": [
        "*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "InstanceActionsOnlyTaggedInstances",
      "Effect": "Allow",
      "Action": [
        "ec2:AttachVolume",
        "ec2:CreateVolume",
        "ec2:DetachVolume",
        "ec2:StartInstances",
        "ec2:RunInstances"
      ],
      "Resource": [
        "arn:aws:ec2:*:673337243802:instance/*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "DeleteVolumesTagged",
      "Effect": "Allow",
      "Action": [
        "ec2:DeleteVolume"
      ],
      "Resource": [
        "*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:ResourceTag/RedisLabsIdentifier": "RedisLabs"
        }
      }
    },
    {
      "Sid": "InstanceActionsOnlyBasedOnROLE",
      "Effect": "Allow",
      "Action": [
        "ec2:RebootInstances",
        "ec2:StopInstances",
        "ec2:TerminateInstances"
      ],
      "Resource": [
        "arn:aws:ec2:*:673337243802:instance/*"
      ],
      "Condition": {
        "StringEquals": {
          "ec2:InstanceProfile": [
            "arn:aws:iam::673337243802:instance-profile/redislabs-cluster-node-role"
          ]
        }
      }
    }
  ]
}
