# Cluster node access
resource "aws_iam_instance_profile" "redislabs-cluster-node-role-profile" {
  name = "redislabs-cluster-node-role"
  role = "${aws_iam_role.redislabs-cluster-node-role.name}"
}

data "template_file" "redislabs-cluster-node-assume-role-policy" {
  template = "${file("redislabs-cluster-node-assume-role-policy.tpl")}"
}

resource "aws_iam_role" "redislabs-cluster-node-role" {
  name               = "redislabs-cluster-node-role"
  description        = "Role for redislabs instances"
  assume_role_policy = "${data.template_file.redislabs-cluster-node-assume-role-policy.rendered}"
}

data "template_file" "redislabs-cluster-node-policy" {
  template = "${file("redislabs-cluster-node-policy.tpl")}"
}

resource "aws_iam_role_policy" "redislabs-cluster-node-policy" {
  name     = "redislabs-cluster-node-policy"
  role     = "${aws_iam_role.redislabs-cluster-node-role.id}"
  provider = "aws"
  policy   = "${data.template_file.redislabs-cluster-node-policy.rendered}"
}

#S3 access

resource "aws_iam_instance_profile" "redislabs-backups-role-profile" {
  name = "redislabs-backups-role"
  role = "${aws_iam_role.redislabs-backups-role.name}"
}

data "template_file" "redislabs-backups-assume-role-policy" {
  template = "${file("redislabs-backups-assume-role-policy.tpl")}"
}

resource "aws_iam_role" "redislabs-backups-role" {
  name               = "redislabs-backups-role"
  description        = "Role for viewing and download backups of redislabs instances in S3"
  assume_role_policy = "${data.template_file.redislabs-backups-assume-role-policy.rendered}"
}

data "template_file" "redislabs-backups-policy" {
  template = "${file("redislabs-backups-access-policy.tpl")}"
}

resource "aws_iam_role_policy" "redislabs-backups-policy" {
  name     = "redislabs-backups-policy"
  role     = "${aws_iam_role.redislabs-backups-role.id}"
  provider = "aws"
  policy   = "${data.template_file.redislabs-backups-policy.rendered}"
}
