##
# Setup NAT instances in Public subnets
##

variable nat {
	default {
		ami = "ami-69ae8259"
		instance = "c4.8xlarge"
	}
}
module "nat_dev" {
  #source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/nat/"
  source = "../../../../../web/terraform/modules/nat"
  ami = "${var.nat["ami"]}"
  instance = "${var.nat["instance"]}"
  count = 3
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  subnet_ids = ["${aws_subnet.public_dev_a.id}","${aws_subnet.public_dev_b.id}","${aws_subnet.public_dev_c.id}"]
  cidr = "${var.vpc_dev["cidr"]}"
  security_groups = "${module.twitch_dev_subnets.id}"
}
