variable sfo_dx {
	default = "vgw-082df216"
}

variable "web_dev_peercx" {
    description = "Hardcoded vpc peer connection to web-dev"
    default = "pcx-b3a873da" 
}

variable "rlec_igw"{
    description = "internet gateway for redislabs"
    default = "igw-81c787e4"
}

## Peering Connections

resource "aws_vpc_peering_connection" "chat_peer" {
    peer_owner_id = "603200399373"
    peer_vpc_id = "vpc-6183fe04"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-chat/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_aws_dev_peer" {
    peer_owner_id = "673385534282"
    peer_vpc_id = "vpc-1e13b17b"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-aws/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_emr_dev_peer" {
    peer_owner_id = "540889859834"
    peer_vpc_id = "vpc-523fff36"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-emr/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_creative_dev_peer" {
    peer_owner_id = "068626529051"
    peer_vpc_id = "vpc-52fe4a36"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-creative/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_feeds_dev_peer" {
    peer_owner_id = "724951484461"
    peer_vpc_id = "vpc-5bb8fe3f"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-feeds/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_discovery_dev_peer" {
    peer_owner_id = "924637445623"
    peer_vpc_id = "vpc-15e70b72"
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    tags {
		Name = "twitch-discovery/development"
	}
}

resource "aws_vpc_peering_connection" "twitch_capacity_dev_peer" {
  peer_owner_id = "857224489803"
  peer_vpc_id = "vpc-964d3cf2"
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  tags {
    Name = "twitch-cape-capacitymanagement-aws-test/development"
  }
}

resource "aws_vpc_peering_connection_accepter" "twitch_users_service_dev_peer" {
  vpc_peering_connection_id = "pcx-c191e4a8"
  auto_accept = true

  tags {
    Name = "twitch-users-service-dev/development"
  }
}

## Route Tables
resource "aws_route_table" "external" {
	vpc_id = "${module.rlec_dev_vpc.vpc_id}"

	tags {
		Name = "external_dev_routes"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${module.rlec_dev_vpc.igw_id}"
	}

	route {
		cidr_block = "10.194.0.0/18"
		vpc_peering_connection_id = "${var.web_dev_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_dev_peer.id}"
	}

	route {
		cidr_block = "10.198.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_dev_peer.id}"
	}

	route {
		cidr_block = "10.200.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_dev_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_dev_peer.id}"
  }

  route {
    cidr_block = "10.202.68.0/22"
    vpc_peering_connection_id = "${aws_vpc_peering_connection_accepter.twitch_users_service_dev_peer.id}"
  }

	#propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_a" {
	vpc_id = "${module.rlec_dev_vpc.vpc_id}"

	tags {
		Name = "internal_dev_routes_a"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}


	route {
		cidr_block = "10.194.0.0/18"
		vpc_peering_connection_id = "${var.web_dev_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_dev_peer.id}"
	}

	route {
		cidr_block = "10.198.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_dev_peer.id}"
	}

	route {
		cidr_block = "10.200.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_dev_peer.id}"
	}
	
  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_dev_peer.id}"
  }

  route {
    cidr_block = "10.202.68.0/22"
    vpc_peering_connection_id = "${aws_vpc_peering_connection_accepter.twitch_users_service_dev_peer.id}"
  }

	#propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_b" {
	vpc_id = "${module.rlec_dev_vpc.vpc_id}"

	tags {
		Name = "internal_dev_routes_b"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

	route {
		cidr_block = "10.194.0.0/18"
		vpc_peering_connection_id = "${var.web_dev_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_dev_peer.id}"
	}

	route {
		cidr_block = "10.198.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_dev_peer.id}"
	}
	
	route {
		cidr_block = "10.200.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_dev_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_dev_peer.id}"
  }

  route {
    cidr_block = "10.202.68.0/22"
    vpc_peering_connection_id = "${aws_vpc_peering_connection_accepter.twitch_users_service_dev_peer.id}"
  }

#	propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_c" {
	vpc_id = "${module.rlec_dev_vpc.vpc_id}"

	tags {
		Name = "internal_dev_routes_c"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

	route {
		cidr_block = "10.194.0.0/18"
		vpc_peering_connection_id = "${var.web_dev_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_dev_peer.id}"
	}

	route {
		cidr_block = "10.196.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_dev_peer.id}"
	}

	route {
		cidr_block = "10.198.0.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_dev_peer.id}"
	}
	
	route {
		cidr_block = "10.200.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_dev_peer.id}"
	}
	
  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_dev_peer.id}"
  }

  route {
    cidr_block = "10.202.68.0/22"
    vpc_peering_connection_id = "${aws_vpc_peering_connection_accepter.twitch_users_service_dev_peer.id}"
  }

#	propagating_vgws = ["${var.sfo_dx}"]
}

## Route Table Associations
resource "aws_route_table_association" "route_public_a" {
	subnet_id = "${aws_subnet.public_dev_a.id}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_b" {
	subnet_id = "${aws_subnet.public_dev_b.id}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_c" {
	subnet_id = "${aws_subnet.public_dev_c.id}"
	route_table_id = "${aws_route_table.external.id}"
}


resource "aws_route_table_association" "route_dev_a" {
	subnet_id = "${aws_subnet.dev_a.id}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_dev_b" {
	subnet_id = "${aws_subnet.dev_b.id}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_dev_c" {
	subnet_id = "${aws_subnet.dev_c.id}"
	route_table_id = "${aws_route_table.internal_c.id}"
}


resource "aws_vpc_endpoint" "private-s3" {
    vpc_id = "${module.rlec_dev_vpc.vpc_id}"
    service_name = "com.amazonaws.us-west-2.s3"
    route_table_ids = ["${aws_route_table.internal_a.id}", "${aws_route_table.internal_b.id}","${aws_route_table.internal_c.id}"]
    policy = <<POLICY
{
    "Version": "2008-10-17",
    "Statement": [
        {
            "Action": "*",
            "Effect": "Allow",
            "Resource": "*",
            "Principal": "*"
        }
    ]
}
POLICY
}
