resource "aws_subnet" "dev_a" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2a"
  cidr_block = "${var.subnets["dev_a"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Development - A"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "dev_b" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2b"
  cidr_block = "${var.subnets["dev_b"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Development - B"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "dev_c" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2c"
  cidr_block = "${var.subnets["dev_c"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Development - C"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "public_dev_a" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2a"
  cidr_block = "${var.subnets["public_dev_a"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Development - A"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "public_dev_b" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2b"
  cidr_block = "${var.subnets["public_dev_b"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Development - B"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "public_dev_c" {
  vpc_id = "${module.rlec_dev_vpc.vpc_id}"
  availability_zone = "us-west-2c"
  cidr_block = "${var.subnets["public_dev_c"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Development - C"
    Owner = "${var.owner}"
  }
}

output "dev_a" {
  value = "${aws_subnet.dev_a.id}"
}

output "dev_b" {
  value = "${aws_subnet.dev_b.id}"
}

output "dev_c" {
  value = "${aws_subnet.dev_c.id}"
}

output "public_dev_a" {
  value = "${aws_subnet.public_dev_a.id}"
}

output "public_dev_b" {
  value = "${aws_subnet.public_dev_b.id}"
}

output "public_dev_c" {
  value = "${aws_subnet.public_dev_c.id}"
}
