##
# Shared variables for this account
##

variable "vpc_prod" {
	default = {
		name = "Production"
		cidr = "10.195.128.0/19"
	}
}
variable "vpc_dev" {
  default = {
    name = "Development"
    cidr = "10.195.160.0/19"
  }
}

variable "subnets" {
	default = {
		dev_a = "10.195.160.0/21"
		dev_b = "10.195.168.0/21"
		dev_c = "10.195.176.0/21"
    public_dev_a = "10.195.184.0/24"
    public_dev_b = "10.195.185.0/24"
    public_dev_c = "10.195.186.0/24"
		growth_b = "10.195.187.0/22"
	}
}

variable "account_id" {
	default = "641044725657"
}

variable "map_public_ip_on_launch"{
  default = "true"
}

variable "owner" {
	description = "Tag used to identify resource 'Owner'"
	default = "swong@twitch.tv"
}

variable "project_tag" {
    description = "Tag used on resource tags and names to help locate resources in AWS"
    default = "d8a/redis"
}

