####
## Description : Sets up Development VPC with subnets for d8a/rlec service
## Author : Steven Wong (swong@twitch.tv)
####

module "rlec_dev_vpc" {
	#source = "../../../modules/vpc/twitch-web-dev/"
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/vpc"
	name = "${var.vpc_dev["name"]}"
	owner = "${var.owner}"
	cidr = "${var.vpc_dev["cidr"]}"
  domain_name = "us-west-2.compute.internal"
  domain_name_servers = "AmazonProvidedDNS"
}

#this is a security group (deceptive name)
module "twitch_dev_subnets" {
	source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/sg"
	owner = "${var.owner}"
	vpc_id = "${module.rlec_dev_vpc.vpc_id}"
}
