##
# Setup NAT instances in Public subnets
##

variable nat {
  type = "map"
  default {
    ami = "ami-69ae8259"
    instance = "c4.8xlarge"
  }
}

module "nat_prod" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/nat/"
  #source = "../../../../../web/terraform/modules/nat"
  ami = "${var.nat["ami"]}"
  instance = "${var.nat["instance"]}"
  count = 3
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  subnet_ids = [ "${aws_subnet.public_prod_a.id}", "${aws_subnet.public_prod_b.id}", "${aws_subnet.public_prod_c.id}" ]
  cidr = "${var.vpc_prod["cidr"]}"
  security_groups = "${module.twitch_prod_subnets.id}"
}
