variable sfo_dx {
	default = "vgw-082df216"
}

variable "web_aws_peercx" {
    description = "Hardcoded vpc peer connection to web-dev"
    default = "pcx-1ea47f77" 
}

variable "rlec_igw"{
		description = "internet gateway for redislabs"
		default = "igw-25470440"
}

## Peering Connections

resource "aws_vpc_peering_connection" "chat_peer" {
    peer_owner_id = "603200399373"
    peer_vpc_id = "vpc-6183fe04"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-chat/production"
	}
}


resource "aws_vpc_peering_connection" "twitch_aws_prod_peer" {
    peer_owner_id = "673385534282"
    peer_vpc_id = "vpc-0213b167"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-aws/production"
	}
}

resource "aws_vpc_peering_connection" "twitch_emr_prod_peer" {
    peer_owner_id = "540889859834"
    peer_vpc_id = "vpc-523fff36"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-emr/production"
	}
}

resource "aws_vpc_peering_connection" "twitch_creative_prod_peer" {
    peer_owner_id = "727894822935"
    peer_vpc_id = "vpc-0d842869"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-creative/production"
	}
}

resource "aws_vpc_peering_connection" "twitch_feeds_prod_peer" {
    peer_owner_id = "914569885343"
    peer_vpc_id = "vpc-29b8fe4d"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-feeds/production"
	}
}

resource "aws_vpc_peering_connection" "twitch_discovery_prod_peer" {
    peer_owner_id = "924637445623"
    peer_vpc_id = "vpc-dfe00cb8"
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    tags {
		Name = "twitch-discovery/production"
	}
}

resource "aws_vpc_peering_connection" "twitch_capacity_prod_peer" {
  peer_owner_id = "857224489803"
  peer_vpc_id = "vpc-964d3cf2"
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  tags {
    Name = "twitch-cape-capacitymanagement-aws-test/production"
  }
}

resource "aws_vpc_peering_connection_accepter" "twitch_users_service_prod_peer" {
  vpc_peering_connection_id = "pcx-72abc21b"
  auto_accept = true

  tags {
    Name = "twitch-users-service-aws/production"
  }
}

## Route Tables
resource "aws_route_table" "external" {
	vpc_id = "${module.rlec_prod_vpc.vpc_id}"

	tags {
		Name = "external_prod_routes"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.web_aws_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.128.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_prod_peer.id}"
	}

	route {
		cidr_block = "10.198.64.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_prod_peer.id}"
	}

	route {
		cidr_block = "10.200.128.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_prod_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_prod_peer.id}"
  }

	#propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_a" {
	vpc_id = "${module.rlec_prod_vpc.vpc_id}"

	tags {
		Name = "internal_prod_routes_a"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

#	route {
#		cidr_block = "0.0.0.0/0"
#		instance_id = "${module.nat_prod.nat_a}"
#	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.web_aws_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.128.0/18" #change to creative
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_prod_peer.id}"
	}

	route {
		cidr_block = "10.198.64.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_prod_peer.id}"
	}
	
	route {
		cidr_block = "10.200.128.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_prod_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_prod_peer.id}"
  }

	#propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_b" {
	vpc_id = "${module.rlec_prod_vpc.vpc_id}"

	tags {
		Name = "internal_prod_routes_b"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

#	route {
#		cidr_block = "0.0.0.0/0"
#		instance_id = "${module.nat_prod.nat_b}"
#	}

		route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.web_aws_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}
	
	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_prod_peer.id}"
	}

	route {
		cidr_block = "10.198.64.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_prod_peer.id}"
	}

	route {
		cidr_block = "10.200.128.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_prod_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_prod_peer.id}"
  }

#	propagating_vgws = ["${var.sfo_dx}"]
}

resource "aws_route_table" "internal_c" {
	vpc_id = "${module.rlec_prod_vpc.vpc_id}"

	tags {
		Name = "internal_prod_routes_c"
		Owner = "${var.owner}"
	}

	route {
		cidr_block = "0.0.0.0/0"
		gateway_id = "${var.rlec_igw}"
	}

#	route {
#		cidr_block = "0.0.0.0/0"
#		instance_id = "${module.nat_prod.nat_c}"
#	}

	route {
		cidr_block = "10.194.192.0/18"
		vpc_peering_connection_id = "${var.web_aws_peercx}"
	}

	route {
		cidr_block = "10.193.192.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.chat_peer.id}"
	}

	route {
		cidr_block = "10.192.64.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_aws_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.64.0/21"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_emr_prod_peer.id}"
	}

	route {
		cidr_block = "10.196.128.0/18"
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_creative_prod_peer.id}"
	}

	route {
		cidr_block = "10.198.64.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_feeds_prod_peer.id}"
	}

	route {
		cidr_block = "10.200.128.0/18" 
		vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_discovery_prod_peer.id}"
	}

  route {
    cidr_block = "10.197.64.0/18"
    vpc_peering_connection_id = "${aws_vpc_peering_connection.twitch_capacity_prod_peer.id}"
  }

#	propagating_vgws = ["${var.sfo_dx}"]
}

## Route Table Associations
resource "aws_route_table_association" "route_public_a" {
	subnet_id = "${aws_subnet.public_prod_a.id}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_b" {
	subnet_id = "${aws_subnet.public_prod_b.id}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_public_c" {
	subnet_id = "${aws_subnet.public_prod_c.id}"
	route_table_id = "${aws_route_table.external.id}"
}

resource "aws_route_table_association" "route_prod_a" {
	subnet_id = "${aws_subnet.prod_a.id}"
	route_table_id = "${aws_route_table.internal_a.id}"
}

resource "aws_route_table_association" "route_prod_b" {
	subnet_id = "${aws_subnet.prod_b.id}"
	route_table_id = "${aws_route_table.internal_b.id}"
}

resource "aws_route_table_association" "route_prod_c" {
	subnet_id = "${aws_subnet.prod_c.id}"
	route_table_id = "${aws_route_table.internal_c.id}"
}

resource "aws_vpc_endpoint" "private-s3" {
    vpc_id = "${module.rlec_prod_vpc.vpc_id}"
    service_name = "com.amazonaws.us-west-2.s3"
    route_table_ids = ["${aws_route_table.internal_a.id}", "${aws_route_table.internal_b.id}","${aws_route_table.internal_c.id}"]
    policy = <<POLICY
{
    "Version": "2008-10-17",
    "Statement": [
        {
            "Action": "*",
            "Effect": "Allow",
            "Resource": "*",
            "Principal": "*"
        }
    ]
}
POLICY
}
