resource "aws_subnet" "prod_a" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2a"
  cidr_block = "${var.subnets["prod_a"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Production - A"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "prod_b" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2b"
  cidr_block = "${var.subnets["prod_b"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Production - B"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "prod_c" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2c"
  cidr_block = "${var.subnets["prod_c"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "RedisLabs Production - C"
    Owner = "${var.owner}"
  }
}

resource "aws_subnet" "public_prod_a" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2a"
  cidr_block = "${var.subnets["public_prod_a"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Production - A"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "public_prod_b" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2b"
  cidr_block = "${var.subnets["public_prod_b"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Production - B"
    Owner = "${var.owner}"
  }
}
resource "aws_subnet" "public_prod_c" {
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
  availability_zone = "us-west-2c"
  cidr_block = "${var.subnets["public_prod_c"]}"
  map_public_ip_on_launch = "${var.map_public_ip_on_launch}"
  tags {
    Name = "Public Production - C"
    Owner = "${var.owner}"
  }
}


output "prod_a" {
  value = "${aws_subnet.prod_a.id}"
}

output "prod_b" {
  value = "${aws_subnet.prod_b.id}"
}

output "prod_c" {
  value = "${aws_subnet.prod_c.id}"
}

output "public_prod_a" {
  value = "${aws_subnet.public_prod_a.id}"
}

output "public_prod_b" {
  value = "${aws_subnet.public_prod_b.id}"
}

output "public_prod_c" {
  value = "${aws_subnet.public_prod_c.id}"
}
