####
## Description : Sets up Production VPC with subnets for d8a/rlec service
## Author : Steven Wong (swong@twitch.tv)
####

module "rlec_prod_vpc" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/vpc"
  name = "${var.vpc_prod["name"]}"
  owner = "${var.owner}"
  cidr = "${var.vpc_prod["cidr"]}"
  domain_name = "us-west-2.compute.internal"
  domain_name_servers = "AmazonProvidedDNS"

}
module "twitch_prod_subnets" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/sg"
  owner = "${var.owner}"
  vpc_id = "${module.rlec_prod_vpc.vpc_id}"
}

