provider "pagerduty" {
  token = "${var.pagerduty_key}"
}

data "pagerduty_vendor" "cloudwatch" {
  name = "Amazon CloudWatch"
}

resource "pagerduty_service_integration" "cloudwatch_alarms" {
  name = "SiteDB ${var.env} cloudwatch alarms"
  service = "${var.pagerduty_service}"
  vendor  = "${data.pagerduty_vendor.cloudwatch.id}"
}

resource "aws_sns_topic" "cloudwatch_alarms" {
  name = "sitedb-staging-cloudwatch-alarms"
}

resource "aws_sns_topic_subscription" "alarms_subscription" {
  endpoint = "https://events.pagerduty.com/integration/${pagerduty_service_integration.cloudwatch_alarms.integration_key}/enqueue"
  endpoint_auto_confirms = true
  protocol = "https"
  topic_arn = "${aws_sns_topic.cloudwatch_alarms.arn}"
}

output "topic_arn" {
  value = "${aws_sns_topic.cloudwatch_alarms.arn}"
  #value = "${aws_sns_topic_subscription.alarms_subscription.arn}"
}
