resource "aws_cloudwatch_metric_alarm" "monitor_latency" {
  alarm_name          = "${var.name}-${var.env}-latency-monitor"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods  = "2"
  metric_name         = "Latency"
  namespace           = "AWS/ELB"
  period              = "60"
  statistic           = "Average"
  threshold           = "${var.threshold_latency}"

  dimensions {
    LoadBalancerName = "${var.elb_name}"
  }

  alarm_description = "Average time in seconds for ${var.name} ${var.env} elb to connect to instance"
  alarm_actions     = ["${var.topic_arn}"]
}

resource "aws_cloudwatch_metric_alarm" "monitor_connections" {
  alarm_name          = "${var.name}-${var.env}-connection-monitor"
  comparison_operator = "LessThanThreshold"
  evaluation_periods  = "2"
  metric_name         = "RequestCount"
  namespace           = "AWS/ELB"
  period              = "60"
  statistic           = "Sum"
  threshold           = "${var.threshold_connection}"

  dimensions {
    LoadBalancerName = "${var.elb_name}"
  }

  alarm_description = "Sum of active connections to ${var.name} ${var.env} elb"
  alarm_actions     = ["${var.topic_arn}"]
}
