variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_dns"
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}
variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

resource "aws_rds_cluster" "cohesion-cluster" {
  cluster_identifier        = "${var.cluster_identifier}"
  availability_zones        = ["us-west-2a","us-west-2b","us-west-2c"]
  database_name             = "${var.database_name}"
  master_username           = "${var.master_username}"
  master_password           = "${var.master_password}"
  backup_retention_period   = 5
  preferred_backup_window   = "07:00-09:00"  #UTC Time
  final_snapshot_identifier = "${var.final_snapshot_identifier}"
  port                      = "3306"
  vpc_security_group_ids    = ["${split(",",var.vpc_security_group_ids)}"]
  db_subnet_group_name      = "${var.subnet_group_id}"
}

resource "aws_rds_cluster_instance" "cohesion-cluster" {
  count                 = "${var.instance_count}"
  identifier            = "${aws_rds_cluster.cohesion-cluster.id}-${count.index}"
  cluster_identifier    = "${aws_rds_cluster.cohesion-cluster.id}"
  instance_class        = "${var.instance_class}"
  publicly_accessible   = "${var.publicly_accessible}"
  db_subnet_group_name  = "${var.subnet_group_id}"
}

resource "aws_route53_record" "primary_endpoint_cname" {
  provider = "aws.twitch_dns"
  name = "${var.cluster_identifier}-primary.${var.environment}.us-west2.justin.tv"
  records = ["${aws_rds_cluster.cohesion-cluster.endpoint}"]
  ttl = "300"
  type = "CNAME"
  zone_id = "${var.r53_zone_id}"
}

resource "aws_route53_record" "read_endpoint_cname" {
  provider = "aws.twitch_dns"
  name = "${var.cluster_identifier}.${var.environment}.us-west2.justin.tv"
  records = ["${element(aws_rds_cluster_instance.cohesion-cluster.*.endpoint, count.index)}"]
  ttl = "300"
  type = "CNAME"
  zone_id = "${var.r53_zone_id}"
}

output "status"{
  value = "${aws_rds_cluster.cohesion-cluster.status}"
}

output "cluster_endpoint"{
  value = "${aws_rds_cluster.cohesion-cluster.endpoint}"
}

output "cluster_members"{
  value = "${aws_rds_cluster.cohesion-cluster.cluster_members}"
}

output "fqdn" {
    value = "${aws_route53_record.primary_endpoint_cname.fqdn}"
}

# SLW : add more writers if you increase cluster size

output "writer_0"{
  value = "${aws_rds_cluster_instance.cohesion-cluster.0.writer}"
}

