variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_dns_access_key}"
  alias = "twitch_dns"
  region = "us-west-2"
  secret_key = "${var.twitch_dns_secret_key}"
}
variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}



resource "aws_db_instance" "cohesion-game-follows" {
  allocated_storage    = "${var.allocated_storage}"
  db_subnet_group_name = "${var.db_subnet_group_name}"
  engine               = "aurora"
  engine_version       = "${var.engine_version}"
  instance_class       = "${var.instance_class}"
  identifier           = "${var.identifier}"
  multi_az             = "${var.multi_az}"
  name                 = "${var.name}"
  parameter_group_name = "${var.parameter_group_name}"
  password             = "${var.password}"
  port                 = "3306"
  publicly_accessible  = "${var.publicly_accessible}"
  storage_type         = "${var.storage_type}"
  username             = "${var.username}"
  vpc_security_group_ids = ["${split(",", var.vpc_security_group_ids)}"]
}

resource "aws_route53_record" "dns" {
  provider = "aws.twitch_dns"
  name = "${var.name}.${var.environment}.us-west2.justin.tv"
  records = ["${aws_db_instance.cohesion-game-follows.endpoint}"]
  ttl = "300"
  type = "CNAME"
  zone_id = "${var.r53_zone_id}"
}


/*output "endpoint"{
  value = "${aws_db_instance.cohesion-game-follows.endpoint}"
}*/

output "username"{
  value = "${aws_db_instance.cohesion-game-follows.username}"
}

output "port"{
  value = "${aws_db_instance.cohesion-game-follows.port}"
}
