variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
provider "aws" {
  access_key = "${var.twitch_aws_access_key}"
  #alias = "twitch_web_aws"
  region = "us-west-2"
  secret_key = "${var.twitch_aws_secret_key}"
}

variable "cluster_identifier"{
  description = "cohesion-staging-subnet"
}

variable "subnet_ids"{
  description = "subnet-123456"
}

resource "aws_db_subnet_group" "rds-subnet-group" {
  name = "d8a-cohesion-subnet-group"
  description = "D8A Subnets"
  subnet_ids = ["${split(",", var.subnet_ids)}"]
  tags {
    key = "Name"
    value = "${var.cluster_identifier}"
    propagate_at_launch = true
  }
  tags {
    key = "Owner"
    value = "d8a@twitch.tv"
    propagate_at_launch = true
  }
}

output "rds-subnet-group-id"{
  value = "${aws_db_subnet_group.rds-subnet-group.id}"
}