variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}

module "common_local" {
  source = "../../../modules/variables/twitch-web-aws/"
}

module "cohesion-chat-production-cluster"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  source = "../../lib/cohesion-cluster.20160525"

  name                      = "cohesion-chat-aurora"
  cluster_identifier        = "cohesion-chat-aurora"
  database_name             = "${var.database_name}"
  final_snapshot_identifier = "cohesion-chat-production-identifier"
  master_username           = "${var.master_username}"
  master_password           = "${var.master_password}"
  instance_class            = "db.r3.8xlarge"
  instance_count            = "6"
  publicly_accessible       = "${var.publicly_accessible}"
  subnet_group_id           = "${var.subnet_group_id}"
  vpc_security_group_ids    = "${var.vpc_security_group_ids}"

  r53_zone_id          = "${var.r53_zone_id}"
  environment          = "${var.environment}"
}

output "Cluster Members"{
  value = "${module.cohesion-chat-production-cluster.cluster_members}"
}

output "CNAME of Cluster"{
  value = "${module.cohesion-chat-production-cluster.fqdn}"
}

# SLW : add more writers if you increase cluster size

output "writer_0"{
  value = "${module.cohesion-chat-production-cluster.writer_0}"
}
