variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}

module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}


module "cohesion-friends-staging-cluster"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  source = "../../lib/cohesion-cluster.20160525"

  name                      = "cohesion-friends"
  cluster_identifier        = "cohesion-friends"
  database_name             = "${var.database_name}"
  final_snapshot_identifier = "cohesion-friends-staging-identifier"
  master_username           = "${var.master_username}"
  master_password           = "${var.master_password}"
  instance_class            = "db.r3.large"
  instance_count            = "2"
  publicly_accessible       = "${var.publicly_accessible}"
  subnet_group_id           = "${var.subnet_group_id}"
  vpc_security_group_ids    = "${var.vpc_security_group_ids}"

  r53_zone_id          = "${var.r53_zone_id}"
  environment          = "${var.environment}"
}

output "Cluster Members"{
  value = "${module.cohesion-friends-staging-cluster.cluster_members}"
}

output "CNAME of Cluster"{
  value = "${module.cohesion-friends-staging-cluster.fqdn}"
}

# SLW : add more writers if you increase cluster size

output "writer_0"{
  value = "${module.cohesion-friends-staging-cluster.writer_0}"
}
