variable "twitch_aws_access_key" {}
variable "twitch_aws_secret_key" {}
variable "twitch_dns_access_key" {}
variable "twitch_dns_secret_key" {}

module "common_local" {
  source = "../../../modules/variables/twitch-web-dev/"
}


module "cohesion-game-follows-staging-cluster"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  source = "../../lib/cohesion-game-follows-cluster.20160512"

  name                    = "${var.name}"
  cluster_identifier      = "${var.cluster_identifier}"
  database_name           = "${var.database_name}"
  master_username         = "${var.master_username}"
  master_password         = "${var.master_password}"
  instance_class          = "db.r3.large"
  instance_count          = "2"
  publicly_accessible     = "${var.publicly_accessible}"
  subnet_ids              = "${module.common_local.data_a},${module.common_local.data_b},${module.common_local.data_c}"
  vpc_security_group_ids  = "${var.vpc_security_group_ids}"

  r53_zone_id          = "${var.r53_zone_id}"
  environment          = "${var.environment}"
}

module "cohesion-friends-staging-cluster-1"{
  twitch_aws_access_key = "${var.twitch_aws_access_key}"
  twitch_aws_secret_key = "${var.twitch_aws_secret_key}"

  twitch_dns_access_key = "${var.twitch_dns_access_key}"
  twitch_dns_secret_key = "${var.twitch_dns_secret_key}"
  source = "../../lib/cohesion-cluster.20160525"

  name                      = "cohesion-friends-1"
  cluster_identifier        = "cohesion-friends-1"
  database_name             = "${var.database_name}"
  final_snapshot_identifier = "cohesion-follow-games-staging-identifier"
  master_username           = "${var.master_username}"
  master_password           = "${var.master_password}"
  instance_class            = "db.r3.large"
  instance_count            = "2"
  publicly_accessible       = "${var.publicly_accessible}"
  subnet_group_id           = "${var.subnet_group_id}"
  vpc_security_group_ids    = "${var.vpc_security_group_ids}"

  r53_zone_id          = "${var.r53_zone_id}"
  environment          = "${var.environment}"
}


output "Cluster Members"{
  value = "${module.cohesion-game-follows-staging-cluster.cluster_members}"
}

output "CNAME of Cluster"{
  value = "${module.cohesion-game-follows-staging-cluster.fqdn}"
}

# SLW : add more writers if you increase cluster size

output "writer_0"{
  value = "${module.cohesion-game-follows-staging-cluster.writer_0}"
}

output "writer_1"{
  value = "${module.cohesion-game-follows-staging-cluster.writer_1}"
}
